<?php

/**
 * this class is used for 2c2p jwe token mgmt
 * @class CardEnc2c2p
 * @access public
 * @category utitily
 */
class CardEnc2c2p {

    /**
     * Read data from `php://input`. Useful when interacting with JSON
     * Getting input with a decoding function:
     * $RequestObj->getRawPostData("json_decode")
     * $RequestObj->getRawPostData("json_decode",true)
     * Any additional parameters are applied to the callback in the order they are given.
     * @method getRawPostData
     * @access public
     * @return The decoded/processed request data.
     */
    protected function getRawPostData() {
        $fh = fopen('php://input', 'r');
        $input = stream_get_contents($fh);
        fclose($fh);
        $args = func_get_args();
        if (!empty($args)) {
            $callback = array_shift($args);
            array_unshift($args, $input);
            return call_user_func_array($callback, $args);
        }
        return $input;
    }

    /**
     * This method is used to get all request data
     * @method getALLRequestData
     * @access protected
     * @return array
     */
    protected function getALLRequestData() {
        $getParams = isset($_GET) && !empty($_GET) ? $_GET : array();
        $postParams = isset($_POST) && !empty($_POST) ? $_POST : array();
        $raw = $this->getRawPostData();
        $requestBody = !empty($raw) ? json_decode($raw, true) : array();
        $_temp = json_last_error();
        if (JSON_ERROR_NONE != $_temp) {
            $request_body = array();
        }
        return array_merge($postParams, $requestBody, $getParams);
    }

    /**
     * This method is used to convert array into xml
     * @method arrayToXml
     * @access protected
     * @param array $data
     * @param string $xml_data(plz pass by reference)
     * @return void
     */
    protected function arrayToXml($data, &$xml_data) {
        foreach ($data as $key => $value) {
            if (is_array($value)) {
                if (is_numeric($key)) {
                    $key = 'item' . $key;
                }
                $subnode = $xml_data->addChild($key);
                $this->arrayToXml($value, $subnode);
            } else {
                $xml_data->addChild("$key", htmlspecialchars("$value"));
            }
        }
    }

    /**
     * This method is used to get response data
     * @method _getCurlResponse
     * @param string $url 
     * @param array $params 
     * @param array $header
     * @access private
     * @return array $responseArray
     */
    private function _getCurlResponse($url, $params, array $header = array()) {
        $headerArray = array_merge(array('Content-Type: text/plain'), $header);
        if (is_array($params)) {
            $paramsString = json_encode($params);
        } else {
            $paramsString = $params;
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headerArray);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $paramsString);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        return $response;
    }

    /**
     * This method is used to check error in response
     * @method checkErrorInResponse
     * @access protected
     * @param string $responseStr
     * @throws Exception
     * @return void
     */
    protected function checkErrorInResponse($responseStr) {
        if (strpos($responseStr, "error:") === 0) {
            throw new \Exception($responseStr);
        }
    }

    /**
     * This method is used to process JWE response
     * @method processCardRequest
     * @access public
     * @throws Exception
     * @return array
     */
    public function processCardRequest() {
        $requestData = $this->getALLRequestData();
        if (!isset($requestData['card_details']) || empty($requestData['card_details']) || !isset($requestData['card_management_2c2p_url']) || empty($requestData['card_management_2c2p_url'])) {
            throw new \Exception("Invalid input: card_details_or_card_management_2c2p_url_missing");
        }
        $javaClass = 'PGW_JWT';//for prod env
        if (isset($requestData['testMode']) && !empty($requestData['testMode'])) {
            $javaClass = 'PGW_JWT_TEST';//for test env
        }
        // convert array to xml
        $xml = new \SimpleXMLElement('<MaintenanceRequest></MaintenanceRequest>');
        $this->arrayToXml($requestData['card_details'], $xml);
        $xmlFormat = $xml->asXML();
        $xmlFormat = trim(str_replace('<?xml version="1.0"?>', '', $xmlFormat));
        $xmlFormat = trim($xmlFormat);
        // convert xml to encrypted payload data
        $createTokenExecCmd = 'java -cp ".:java-jar/json-smart-1.3.1.jar:java-jar/jcip-annotations-1.0-1.jar:java-jar/bcprov-jdk15on-1.55.jar:java-jar/bcpkix-jdk15on-1.55.jar:java-jar/nimbus-jose-jwt-4.34.2.jar" ' . $javaClass . ' createJWEToken "' . $xmlFormat . '"';        
        $encCardData = shell_exec($createTokenExecCmd);
        $this->checkErrorInResponse($encCardData);
        $addCardResponse = $this->_getCurlResponse($requestData['card_management_2c2p_url'], $encCardData);
        $addCardResponse = trim($addCardResponse);
        $decryptTokenExecCmd = 'java -cp ".:java-jar/json-smart-1.3.1.jar:java-jar/jcip-annotations-1.0-1.jar:java-jar/bcprov-jdk15on-1.55.jar:java-jar/bcpkix-jdk15on-1.55.jar:java-jar/nimbus-jose-jwt-4.34.2.jar" ' . $javaClass . ' decryptJWEToken "' . $addCardResponse . '"';
        $decCardData = shell_exec($decryptTokenExecCmd);
        $this->checkErrorInResponse($decCardData);
        $decCardDataObj = simplexml_load_string($decCardData, "SimpleXMLElement", LIBXML_NOCDATA);
        return array('response' => $decCardDataObj);
    }

}

$response = array();
try {
    $CardEnc2c2p = new CardEnc2c2p();
    $response = $CardEnc2c2p->processCardRequest();
} catch (Exception $ex) {
    $response = array(
        'msg' => $ex->getMessage(), 'error' => 1
    );
} finally {
    echo json_encode($response);
    die;
}
