import axios from "axios";

const axiosClient = axios.create({
  baseURL: process.env.REACT_APP_BASE_URL,
});

// note:- create another axios instance if new url pops-up (in future)

//All request will wait max for 10(configure here) seconds before timeout
axiosClient.defaults.timeout = 10000;
axiosClient.defaults.withCredentials = true;
export function getRequest(URL) {
  return axiosClient.get(URL).then((response) => response);
}

export function postRequest(URL, payload, headers) {
  return axiosClient
    .post(URL, payload, {
      headers: headers,
    })
    .then((response) => response);
}
