import React from "react";
import SalesGraph from "./SalesGraph";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import { useEffect } from "react";
import { useState } from "react";
import responseHandler from "../../services/responseHandler";
import { messages } from "../../configuration/GlobalConfig";

const AccountSummary = () => {
  const axiosPrivate = useAxiosIntercept();
  const [accountSummary, setAccountSummary] = useState([]);
  const [error, setError] = useState("");
  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    let response = {};
    const getData = async () => {
      let URL = process.env.REACT_APP_GET_ACCOUNT_SUMMARY;
      try {
        const { data } = await axiosPrivate.get(URL, {
          signal: controller.signal,
        });
        if (data?.status === 200 && isMounted) {
          response = responseHandler(data, "API_SUCCESS");
          setAccountSummary(response.response.data);
          // setTotalRecords(response.response.data.total_records);
        } else {
          response = responseHandler(data, "API_ERROR");
          //Handler Error Here...
          setError(messages.API_ERROR);
        }
      } catch (err) {
        response = responseHandler(err, "NETWORK_ERROR");
        //Handler Error Here...
        setError(messages.NETWORK_ERROR);
      }
    };

    isMounted && getData();

    return () => {
      isMounted = false;
      controller.abort();
    };
  }, []);
  const { partner, corporate, total } = accountSummary;
  return (
    <div className="xRow mt-8 recordData fullWidth">
      <div className="boxT1 penBill">
        <h4>Total unbilled amount</h4>
        <p>{`$${total * -1}`}</p>
        <div className="smallTable">
          <p>
            <span>Partners</span>
            <span>{`$${partner?.total * -1}`}</span>
          </p>
          <p>
            <span>Corporate</span>
            <span>{`$${corporate?.total * -1}`}</span>
          </p>
        </div>
      </div>
    </div>
  );
};

export default AccountSummary;
