import React, { useEffect, useRef, useState } from "react";
import useAuth from "../../hooks/useAuth";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import TransactionList from "./TransactionList";
import { useParams } from "react-router-dom";

function AccountsData({ wallet_id, success, setSuccess }) {

  const [expanded, setExpanded] = useState(0);
  const effectRef = useRef(true);
  const { auth } = useAuth();
  const params = useParams();
  const axiosPrivate = useAxiosIntercept();
  const [walletBalance, setWalletBalance] = useState("");

  const getWalletBalance = async () => {
    try {
      let url = process.env.REACT_APP_GET_BILLING_BALANCE;
      url = `${url}&wallet_id=${wallet_id}`;

      const response = await axiosPrivate.get(url);
      if (response?.data?.response?.data) {
        return response?.data?.response?.data;
      }
    } catch (err) {
      console.log("something went wrong", err);
    }
  };

  useEffect(() => {
    if (effectRef.current) {
      effectRef.current = false;
      getWalletBalance().then((data) => {
        if (data?.balance != null) setWalletBalance(data.balance);
      });
    }
  }, []);

  return (
    <>
      <TransactionList
        wallet_id={wallet_id}
        success={success}
        setSuccess={setSuccess}
      />
    </>
  );
}

export default AccountsData;
