import React from "react";
import SalesGraph from "./SalesGraph";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import { useEffect } from "react";
import { useState } from "react";
import responseHandler from "../../services/responseHandler";
import { messages, unavailable } from "../../configuration/GlobalConfig";
import AccountSummary from "./AccountSummary";
import moment from "moment";

const AccountsDetails = () => {
  const axiosPrivate = useAxiosIntercept();
  const [revenueData, setRevenueData] = useState([]);
  const [error, setError] = useState("");
  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    let response = {};
    const today = new Date();
    const getData = async () => {
      let URL = process.env.REACT_APP_GET_TOTAL_REVENUE;
      try {
        const { data } = await axiosPrivate.get(URL, {
          signal: controller.signal,
          from_date: moment(today).startOf('month').format('YYYY-MM-DD') + " 00:00:00",
          to_date: moment(today).format('YYYY-MM-DD') + " 23:59:59",
        });
        if (data?.status === 200 && isMounted) {
          response = responseHandler(data, "API_SUCCESS");
          setRevenueData(response.response.data);
          // setTotalRecords(response.response.data.total_records);
        } else {
          response = responseHandler(data, "API_ERROR");
          //Handler Error Here...
          setError(messages.API_ERROR);
        }
      } catch (err) {
        response = responseHandler(err, "NETWORK_ERROR");
        //Handler Error Here...
        setError(messages.NETWORK_ERROR);
      }
    };

    isMounted && getData();

    return () => {
      isMounted = false;
      controller.abort();
    };
  }, []);

  return (
    <>
      <AccountSummary />
      <div className="xRow aDashboard mt-24">
        <SalesGraph />

        <div className="column graphIndexData">
          <div className="boxT1 mb-16">
            <p>Customers</p>
            <span>{`${
              revenueData?.customer_sales
                ? "$" + revenueData?.customer_sales
                : unavailable
            }`}</span>
          </div>
          <div className="boxT1 mb-16">
            <p>Partners</p>
            <span>{`${
              revenueData?.partner_sales
                ? "$" + revenueData?.partner_sales
                : unavailable
            }`}</span>
          </div>
          <div className="boxT1">
            <p>Corporates</p>
            <span>{`${
              revenueData?.corporate_sales
                ? "$" + revenueData?.corporate_sales
                : unavailable
            }`}</span>
          </div>
        </div>
      </div>
    </>
  );
};

export default AccountsDetails;
