import React from "react";
import { useState } from "react";
import { axiosPrivate } from "../../api/PrivateRequestServices";
import Overlay from "../../utils/Overlay";
import Error from "../UI/Error";
import Success from "../UI/Success";

const AddBalance = ({
  wallet_id,
  onBackdropClick,
  showPopup,
  customer_name,
  setShowPopup,
  success,
  setSuccess,
}) => {
  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, setErrorMessage] = useState("");
  const [enableSubmit, setEnableSubmit] = useState(true);
  const [data, setData] = useState({
    amount: "",
    remarks: "",
  });
  const [error, setError] = useState({
    ammountEmpty: "",
    remarksEmpty: "",
    amountValue: "",
  });
  const handelClose = () => {
    onBackdropClick();
    setSuccessMessage("");
    setErrorMessage("");
    setData({
      amount: "",
      remarks: "",
    });
    setError({
      ammountEmpty: "",
      remarksEmpty: "",
      amountValue: "",
    });
  };
  const handelAmmount = (e) => {
    setData((prev) => ({
      ...prev,
      amount: e.target.value,
    }));
  };
  const handelRemarks = (e) => {
    setData((prev) => ({
      ...prev,
      remarks: e.target.value,
    }));
  };
  const AddBalance = async (e) =>
  {
    let isError = false;
    if (data.amount == "") {
      isError = true;
      setError((prev) => ({
        ...prev,
        ammountEmpty: "Amount field is required",
      }));
    }
    if (data.remarks == "") {
      isError = true;
      setError((prev) => ({
        ...prev,
        remarksEmpty: "Remarks field is required",
      }));
    }

    if (data.amount !== "" && data.amount <= 0) {
      isError = true;
      setError((prev) => ({
        ...prev,
        ammountEmpty: "",
        amountValue: "Amount value must be greater than 0",
      }));
    }
console.log(enableSubmit,"submit")
    if (!isError&&enableSubmit==true)
    {
        setEnableSubmit(false);
      const url = process.env.REACT_APP_ADD_BALANCE;
      const request = {
        wallet_id: wallet_id,
        amount: data.amount,
        reason_id: 1008,
        staff_note: data.remarks,
      };

      const response = await axiosPrivate.post(url, request);

      if (response?.data?.status === 200) {
      
        setErrorMessage("");
        setSuccessMessage("Balance added successfully");
        setTimeout(() => {
          setSuccessMessage("");
          setErrorMessage("");
          onBackdropClick();
          setSuccess(!success);
          setEnableSubmit(true);
          setError({})
          setData({
            amount: "",
            remarks: "",
          });
        }, 3000);
      } else {

        setErrorMessage(response?.data?.message);
      }
    }
  };

  return (
    showPopup && (
      <Overlay>
        <div
          class="model_box_child addBalanceP"
          id="addBalanceP"
          style={{ width: "300px" }}
        >
          <div class="ap_heading">
            <h4>
              Add balance
              <span
                class="material-symbols-rounded black close_model"
                onClick={handelClose}
              >
                close
              </span>
            </h4>
          </div>
          <div class="contentSection">
            <section class="assignPromoP dForm">
              <div class="promoText customer">
                <p>Customer name</p>
                <em>{customer_name}</em>
              </div>
              <div class="fieldGroup">
                <label>Bill amount received</label>
                <div class="multiOption">
                  <input
                    type="number"
                    placeholder="Enter bill amount received"
                    name=""
                    onChange={(e) => handelAmmount(e)}
                  />
                  <div class="sepText bg">
                    <span>$</span>
                  </div>
                </div>
                {data.amount !== "" ||
                  (error.ammountEmpty !== "" && (
                    <Error error={error.ammountEmpty} />
                  ))}

                {data.amount !== "" &&
                  data.amount <= "0" &&
                  error.amountValue !== "" && (
                    <Error error={error.amountValue} />
                  )}
              </div>

              <div class="fieldGroup">
                <label>Remarks</label>
                <span>
                  <textarea
                    type="text"
                    onChange={(e) => handelRemarks(e)}
                    placeholder="Enter any remarks"
                    name=""
                  ></textarea>
                </span>
                {data.remarks !== "" ||
                  (error.remarksEmpty !== "" && (
                    <Error error={error.remarksEmpty} />
                  ))}
              </div>
            </section>
            <div class="actionButtons mt-24">
              <span>
                <a
                  href="javascript:void(0);"
                  class="btn prim"
                  onClick={AddBalance}
                >
                  Add wallet balance
                </a>
              </span>
            </div>
            {successMessage ? <Success success={successMessage} /> : <></>}
            {errorMessage ? <Error error={errorMessage} /> : <></>}
          </div>
        </div>
      </Overlay>
    )
  );
};

export default AddBalance;
