import React, { useEffect, useState } from "react";
import {
  Chart as ChartJS,
  CategoryScale,
  LinearScale,
  BarElement,
  Title,
  Tooltip,
  Legend,
} from "chart.js";
import { Bar } from "react-chartjs-2";

ChartJS.register(
  CategoryScale,
  LinearScale,
  BarElement,
  Title,
  Tooltip,
  Legend
);

// export const options = {
//     responsive: true,
//     plugins: {
//         legend: {
//             position: 'top',
//         },
//         title: {
//             display: true,
//             // text: 'Chart.js Bar Chart',
//         },
//     },
// };

// const labels = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];

// export const data = {
//     labels,
//     datasets: [
//         {
//             label: 'Customers',
//             data: [92,56,76,23,50,54,87],
//             barThickness : 11,
//             borderRadius:50,
//             backgroundColor: 'rgba(16, 164, 165, 0.8)',
//         },
//         // {
//         //     label: 'Dataset 2',
//         //     data: [34,45,65,56,67,7,78],
//         //     backgroundColor: 'rgba(53, 162, 235, 0.5)',
//         // },
//     ],
// };
const labels = [
  "Jan",
  "Feb",
  "Mar",
  "Apr",
  "May",
  "Jun",
  "Jul",
  "Aug",
  "Sep",
  "Oct",
  "Nov",
  "Dec",
];

let data = {
  labels,
  datasets: [
    {
      label: "Customers",
      data: [92, 56, 76, 23, 50, 54, 87],
      barThickness: 11,
      borderRadius: 50,
      backgroundColor: "rgba(16, 164, 165, 0.8)",
    },
    // {
    //     label: 'Dataset 2',
    //     data: [34,45,65,56,67,7,78],
    //     backgroundColor: 'rgba(53, 162, 235, 0.5)',
    // },
  ],
};

function BarGraph({ label, customerData, type }) {
  const [datum, setDatum] = useState({
    labels: labels,
    datasets: [
      {
        label: type,
        data: [],
        barThickness: 11,
        borderRadius: 50,
        backgroundColor: "rgba(16, 164, 165, 0.8)",
      },
      // {
      //     label: 'Dataset 2',
      //     data: [34,45,65,56,67,7,78],
      //     backgroundColor: 'rgba(53, 162, 235, 0.5)',
      // },
    ],
  });
  const options = {
    responsive: true,
    plugins: {
      legend: {
        position: "top",
      },
      title: {
        display: true,
        // text: 'Chart.js Bar Chart',
      },
    },
  };
  useEffect(() => {
    if (
      label &&
      customerData &&
      label.length != 0 &&
      customerData.length != 0
    ) {
      setDatum({
        labels: label,
        datasets: [
          {
            label: type,
            data: customerData,
            barThickness: 11,
            borderRadius: 50,
            backgroundColor: "rgba(16, 164, 165, 0.8)",
          },
          // {
          //     label: 'Dataset 2',
          //     data: [34,45,65,56,67,7,78],
          //     backgroundColor: 'rgba(53, 162, 235, 0.5)',
          // },
        ],
      });
    }
  }, [label, customerData, type]);

  // let labels = [];
  // customerData.forEach((item)=>{
  //     labels.push(item.month);
  // })

  return <Bar options={options} data={datum} />;
}

export default BarGraph;
