import React, { useEffect, useState } from "react";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import { unavailable } from "../../configuration/GlobalConfig";
import Error from "../UI/Error";
import DataNotFound from "../UI/DataNotFound";

function BillSummary({ summary }) {
 
  const axiosPrivate = useAxiosIntercept();
  const downloadInvoice = async (e, id) => {
    const invoiceURL = process.env.REACT_APP_DOWNLOAD_INVOICE;
    const invoicerequest = {
      order_id: id,
    };
    const invoiceresponse = await axiosPrivate.post(invoiceURL, invoicerequest);

    if (invoiceresponse?.data?.status === 200) {
      const downloadInvoiceLink = invoiceresponse?.data?.response?.data?.file;
      window.open(downloadInvoiceLink, "_blank");
    }
  };

  return (
    <>
      {summary !== undefined ? (
        Object.keys(summary).length !== 0 ? (
          <>
            <tr className="expanded">
              <td colSpan="5">
                <div className="vehicleBill">
                  <div className="summary">
                    <div className="YRow pt-8 pb-8">
                      <div className="boxT1">
                        <h4>
                          Bill summary
                          <span
                            style={{ cursor: "pointer" }}
                            onClick={(e) =>
                              downloadInvoice(
                                e,
                                summary?.booking_info?.order_id
                              )
                            }
                            className="sds"
                          >
                            <a>
                              <i className="material-symbols-rounded mt-m">
                                download
                              </i>
                              Download invoice
                            </a>
                          </span>
                        </h4>
                        <div className="listRow">
                          <h5>Packages sold</h5>
                          <p>
                            {" "}
                            <span>
                              <b className="success"></b>
                              {summary?.package_info.package_name
                                ? summary?.package_info.package_name
                                : unavailable}
                            </span>{" "}
                            <span>
                              $
                              {summary?.package_info.amount
                                ? summary?.package_info.amount
                                : unavailable}
                            </span>{" "}
                          </p>
                          {/*<p>*/}
                          {/*    {" "}*/}
                          {/*    <span>*/}
                          {/*        <b className="success">20 x</b>MB-EQB-Gold 4 (60-80 kWh)*/}
                          {/*    </span>{" "}*/}
                          {/*    <span>$10,000</span>{" "}*/}
                          {/*</p>*/}
                        </div>
                        <div className="listRow">
                          <h5>Charge</h5>
                          <p>
                            {" "}
                            <span>
                              <b className="success"></b>
                              {summary.booking_info.charging_done
                                ? summary.booking_info.charging_done
                                : unavailable}
                              kWh x $
                              {summary.package_info.charge_rate
                                ? summary.package_info.charge_rate
                                : unavailable}
                            </span>{" "}
                            <span>
                              $
                              {summary.booking_info.charging_cost
                                ? summary.booking_info.charging_cost
                                : unavailable}
                            </span>{" "}
                          </p>
                        </div>
                        {/*<div className="listRow">*/}
                        {/*    <h5>Promos sold</h5>*/}
                        {/*    <p>*/}
                        {/*        {" "}*/}
                        {/*        <span>MB-Christmas Charge&amp;Wash</span> <span>$0</span>{" "}*/}
                        {/*    </p>*/}
                        {/*    <p>*/}
                        {/*        {" "}*/}
                        {/*        <span>Strides 28</span> <span>$0</span>{" "}*/}
                        {/*    </p>*/}
                        {/*</div>*/}
                        <div className="listRow">
                          <h5>
                            Total before GST{" "}
                            <span>
                              $
                              {summary.booking_info.subtotal
                                ? summary.booking_info.subtotal
                                : unavailable}
                            </span>
                          </h5>
                          <p>
                            {" "}
                            <span>GST</span>{" "}
                            <span>
                              $
                              {summary.booking_info.gst_cost
                                ? summary.booking_info.gst_cost
                                : unavailable}
                            </span>{" "}
                          </p>
                        </div>
                        <div className="listRow gTotal pad-0 mar-0">
                          <p>
                            {" "}
                            <span>Total bill</span>{" "}
                            <span>
                              $
                              {summary?.booking_info.total
                                ? summary?.booking_info.total
                                : unavailable}
                            </span>{" "}
                          </p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </td>
            </tr>
          </>
        ) : (
          <DataNotFound/>
        )
      ) : (
        <Error error="No Data Found" />
      )}
    </>
  );
}

export default BillSummary;
