import { useState, useEffect, useRef } from "react";
import { useNavigate, useLocation, Link } from "react-router-dom";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import AccountsDetails from "./AccountsDetails";
import SearchBar from "../UI/SearchBar/SearchBar";
// import CustomerListing from "./CustomerListing";
import Pagination from "../Customer/Pagination";
// import SearchBar from "../UI/SearchBar/SearchBar";
import usePaginate from "../../hooks/usePaginate";
import useHttp from "../../hooks/useHttp";
// import Header from "../Layouts/Header/Header";
// import { Notification } from "../../utils/Notification";
import PartnerListing from "../Customer/Partner/PartnerListing";
import PartnerAccountsListing from "./PartnerAccountsListing";
import NoData from "../UI/NoData";
import Loading from "../UI/Loading";
const PartnerAccountsInfo = ({ searchValue, setSearchValue, inputElement }) => {
  // const [partnersInfo, setPartnersInfo] = useState();
  const navigate = useNavigate();
  const location = useLocation();
  const axiosPrivate = useAxiosIntercept();
  const [error, seterror] = useState("");
  const search_keyword = searchValue;
  const [currentPage, setCurrentPage] = useState(1);
  const [usersPerPage, setUsersPerPage] = useState(5);
  const [total_records, setTotalRecords] = useState(0);
  const [eventInitiated, setEventInitiated] = useState(false);
  const [partnerDetails, setPartnerDetails] = useState("");
  const [pageNumber, setPageNumber] = useState(1);
  const [hasMore, setHasMore] = useState(false);
  const search_by = "partner_name";
  const perPageLimit = 10;

  //const searchUsers = async (keyword, isMounted, controller) => {
  let url = process.env.REACT_APP_GET_PARTNER_LIST_FOR_CUSTOMERS;
  if (searchValue === "") {
    if (eventInitiated) {
      setEventInitiated(false);
      setCurrentPage(1);
    }
    url = url + `&page=${pageNumber}&limit=${perPageLimit}`;
  }

  if (searchValue !== "") {
    if (!eventInitiated) {
      setCurrentPage(1);
      setEventInitiated(true);
    }
    url =
      url +
      `&search_by=${search_by}&search_keyword=${searchValue}&limit=${perPageLimit}&page=${pageNumber}`;
  }

  const { isLoading, sendRequest: getusers } = useHttp();

  const { lastElementRef } = usePaginate(isLoading, hasMore, setPageNumber);

  useEffect(() => {
    const setSearchedusers = (searchedUsers) => {
      const { data } = searchedUsers?.data?.response;

      if (data?.partners) {
        setPartnerDetails((prev) => {
          return [...new Set([...prev, ...data?.partners])];
        });
        setTotalRecords(data?.total);
      } else {
        setPartnerDetails({});
      }
      if (data?.total_records == data?.partners?.length) {
        setHasMore(false);
      } else {
        setHasMore(searchedUsers.data.response.data?.partners.length > 0);
      }
    };
    getusers(
      {
        url,
      },

      setSearchedusers
    );
    // }
  }, [url, pageNumber, getusers]);

  return (
    <>
      <div className="searchPanel mt-24">
        <SearchBar
          setSearchValue={setSearchValue}
          searchValue={searchValue}
          placeholder={"Search partner or corporate name"}
          setData={setPartnerDetails}
          setPageNumber={setPageNumber}
        />
      </div>
      <div className="subContent pt-24">
        <PartnerAccountsListing
          partner={partnerDetails}
          setSearchValue={setSearchValue}
          setPartnerDetails={setPartnerDetails}
          pageNumber={pageNumber}
          setPageNumber={setPageNumber}
          lastElementRef={lastElementRef}
        />
      </div>

      {pageNumber !== 1 && <div>{isLoading && <Loading />}</div>}
      {pageNumber != "1" && pageNumber > Math.ceil(total_records / perPageLimit) && (<NoData />)}
    </>
  );
};

export default PartnerAccountsInfo;
