import React, { useEffect } from "react";
import { Link, useNavigate } from "react-router-dom";
import { Text } from "../UI/Text";
import Card from "../UI/Card";
import { useState } from "react";
import Spinner from "../UI/Spinner";
// import PatnerProfile from "../../../utils/PartnerProfile";
//import PartnerProfile from "../../utils/PartnerProfile";
import { FormatDate } from "../../utils/FormatDate";
import Notification from "../../utils/Notification";
import Image from "../UI/Image";
import { CurrencyFormat } from "../../utils/CurrencyFormat";
import DataNotFound from "../UI/DataNotFound";
const PartnerAccountsListing = ({
  partner,
  page,
  pageNumber,
  setPageNumber,
  setPartnerDetails,
  lastElementRef,
}) => {
  const [partners, setPartners] = useState(partner);
  const [showMessage, setShowMessage] = useState(false);
  const [notifyData, setNotifyData] = useState();
  const [showDropDown, setShowDropDown] = useState(false);
  const [showDeletePopUP, setShowDeletePopUP] = useState(false);
  const [showPopUP, setShowPopUP] = useState(false);
  const navigate = useNavigate();
  const style = {
    mainDivClass: "userInfo",
    subDivClass: "name",
  };

  useEffect(() => {
    setPartners(partner);
  }, [partner]);

  const handleDeletePartner = (e, partner_id, status) => {
    setNotifyData({
      id: partner_id,
      name: "Do You Want to Remove",
      text: "This Package ?",
      buttonNameYes: "Confirm",
      buttonNameNo: "Cancel",
      url: process.env.REACT_APP_UPDATE_PARTNER_STATUS,
      apiRequest: {
        partner_id: partner_id,
        status: "D",
      },
    });
    setShowDeletePopUP(true);
    // setPackageDetails([]);
  };

  const [showSubComponent, setshowSubComponent] = useState({
    viewDetails: false,
    partner_id: "",
  });

  const subContent = (e, partnerId) => {
    setshowSubComponent({ [e.target.id]: true, partner_id: partnerId });
    setShowPopUP(true);
  };

  const handelDropDown = () => {
    setShowDropDown(true);
  };
  const onBackdropClick = (operation_status, partner_id) => {
    if (operation_status === true) {
      deletePartnerFromListing(partner_id);
    }
    setShowPopUP(false);
    setShowDeletePopUP(false);
  };

  const deletePartnerFromListing = (partner_id) => {
    const id = partner_id;
    const currentPartners = [...partner];

    let index = currentPartners.findIndex(function (element) {
      if (element.partner_id === id) {
        return true;
      }
    });

    if (index !== -1) {
      currentPartners.splice(index, 1);
      setPartners(currentPartners);
    }
  };

  return (
    <>
      {" "}
      {partners == "" ? (
        <>
          <Spinner />
        </>
      ) : Object.keys(partner).length !== 0 ? (
        <>
          <>
            <div class="dataTableDynamic ">
              <table>
                <tbody>
                  <tr>
                    <th>Customer details</th>
                    <th>Wallet balance</th>
                    <th>&nbsp;</th>
                  </tr>
                  {partners.map((partnerDetails, i) => {
                    const {
                      partner_name,
                      partner_logo,
                      partner_id,
                      package_info,
                      energy_info,
                      business_info,
                      status,
                      created_at,
                      customer_count,
                      wallet_id,
                      wallet_balance,
                    } = partnerDetails;
                    if (partners.length === i + 1) {
                      return (
                        <tr ref={lastElementRef}>
                          <td class="vName">
                            <img src={partner_logo} />
                            <strong>{partner_name}</strong>
                          </td>
                          <td
                            class={
                              wallet_balance.slice(0, 1) >= 0
                                ? "success"
                                : "error"
                            }
                          >
                            <strong>{CurrencyFormat(wallet_balance)}</strong>
                          </td>
                          <td class="right">
                            <a style={{ cursor: "pointer" }}>
                              <i
                                onClick={() => {
                                  navigate(
                                    `/accounts/accountDetails/${partner_id}`
                                  );
                                }}
                                class="material-symbols-rounded arrowRight mt-l"
                              >
                                expand_more
                              </i>
                            </a>
                          </td>
                        </tr>
                      );
                    } else {
                      return (
                        <tr ref={lastElementRef}>
                          <td class="vName">
                            <img src={partner_logo} />
                            <strong>{partner_name}</strong>
                          </td>
                          <td
                            class={
                              wallet_balance.slice(0, 1) >= 0
                                ? "success"
                                : "error"
                            }
                          >
                            <strong>{CurrencyFormat(wallet_balance)}</strong>
                          </td>
                          <td class="right">
                            <a style={{ cursor: "pointer" }}>
                              <i
                                onClick={() => {
                                  navigate(
                                    `/accounts/accountDetails/${partner_id}`
                                  );
                                }}
                                class="material-symbols-rounded arrowRight mt-l"
                              >
                                expand_more
                              </i>
                            </a>
                          </td>
                        </tr>
                      );
                    }
                  })}
                </tbody>
              </table>
            </div>
          </>
          {/* ); */}
          {showDeletePopUP && (
            <Notification
              notifyData={notifyData}
              onBackdropClick={onBackdropClick}
            />
          )}
        </>
      ) : (
        <>
          <DataNotFound/>
        </>
      )}
    </>
  );
};
export default PartnerAccountsListing;
