import React, { useState, useEffect } from "react";
import { useLocation, useParams, Link } from "react-router-dom";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import { CurrencyFormat } from "../../utils/CurrencyFormat";
import useAuth from "../../hooks/useAuth";
import Image from "../UI/Image";
// import { FormatDate } from "../../utils/FormatDate";
// import Bookings from "./Bookings";
import AccountsData from "./AccountsData";
import AccountsDetails from "./AccountsDetails";
import AddBalance from "./AddBalance";
import DataNotFound from "../UI/DataNotFound";

const PartnerAccountsProfile = () => {
  const params = useParams();
  const { auth } = useAuth();
  const axiosPrivate = useAxiosIntercept();
  const [userDetails, setUserDetails] = useState("");
  const [error, setError] = useState("");
  const [success, setSuccess] = useState(false);
  const [showPopup, setShowPopup] = useState(false);
  const [openPopup, setOpenPopup] = useState({
    addBalance: false,
  });
  const onBackdropClick = () => {
    setShowPopup(false);
    document.body.classList.remove("hidden");
  };
  const handelBalancePopup = (e) => {
 
    setOpenPopup({ [e.target.id]: true });
    setShowPopup(true);
  };

  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    const getUserDetails = async () => {
      const URL = process.env.REACT_APP_GET_PARTNER_LIST_FOR_CUSTOMERS;
      try {
        const response = await axiosPrivate.get(
          URL + `&partner_id=${params.user_id}`,
          {
            signal: controller.signal,
          }
        );
     
        if (response.data.status === 200) {
          isMounted && setUserDetails(response?.data?.response?.data?.partners);
        } else {
          setUserDetails({});
        }
      } catch (err) {}
    };
    if (isMounted) {
      getUserDetails();
    }

    return () => {
      isMounted = false;
      controller.abort();
    };
  }, [success]);

  return (
    <>
    
      {userDetails === "" ? (
        <div>Fetching User Details</div>
      ) : userDetails && Object.keys(userDetails).length !== 0 ? (
        userDetails.map((profileDetails) => {
      
          return (
            profileDetails.partner_id === params.user_id && (
              <>
                {openPopup.addBalance && (
                  <AddBalance
                    wallet_id={profileDetails.wallet_id}
                    onBackdropClick={onBackdropClick}
                    showPopup={showPopup}
                    customer_name={profileDetails.partner_name}
                    setShowPopup={setShowPopup}
                    success={success}
                    setSuccess={setSuccess}
                  />
                )}
               
                <div class="searchPanel vehicleHead">
                  <div class="searchBar">
                    <div class="userInfo">
                      <Image
                        userImage={profileDetails.partner_logo}
                        name={
                          profileDetails.partner_name
                            ? profileDetails.partner_name
                            : "Guest"
                        }
                        className="imgBlock"
                      />

                      <div class="name">
                        {profileDetails.partner_name ? (
                          <h2>{profileDetails.partner_name}</h2>
                        ) : (
                          <h2>Guest</h2>
                        )}
                      </div>
                    </div>
                  </div>
                  <div class="xRow walletBalance">
                    <div class="boxT1">
                      <p>
                        <span>{`Wallet balance`}</span>

                        <span
                          class={
                            profileDetails.wallet_balance.slice(0, 1) >= 0
                              ? "success"
                              : "error"
                          }
                        >
                          {" " + CurrencyFormat(profileDetails.wallet_balance)}
                        </span>
                      </p>
                    </div>
                    {auth.priviliges.includes("write_accounts") &&
                      <a
                        href="javascript:void(0);"
                        class="btn prim ml-16 open_model"
                        data-target="addBalanceP"
                        id="addBalance"
                        onClick={(e) => handelBalancePopup(e)}
                      >
                        Add balance
                      </a>}
                  </div>
                </div>
              
                <AccountsData
                  wallet_id={profileDetails.wallet_id}
                  success={success}
                  setSuccess={setSuccess}
                />
              </>
            )
          );
        })
      ) : (
        <>
          
          <DataNotFound/>
        </>
      )}
    </>
  );
};

export default PartnerAccountsProfile;
