import React, { useEffect, useRef, useState } from "react";
import BarGraph from "./BarGraph";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import useOutsideClick from "../../hooks/useOutsideClick";
import { CurrencyFormat } from "../../../src/utils/CurrencyFormat";
import moment from "moment";
function SalesGraph(props) {
  const axiosPrivate = useAxiosIntercept();
  const effectRef = useRef(true);
  const [averageCharge, setAverageCharge] = useState("");
  const [averagePackagePrice, setAveragePackagePrice] = useState("");
  const [packages, setPackages] = useState([]);
  const [transactionData, setTransactionData] = useState([]);
  const [transactionType, setTransactionType] = useState("debit");
  const [isLoading, setIsLoading] = useState(false);
  const [totalCustomer, setTotalCustomer] = useState(0);
  const [totalSales, setTotalSales] = useState(0);
  const [customerData, setCustomerData] = useState([]);
  const [salesData, setSalesData] = useState([]);
  const [labelData, setLabelData] = useState([]);
  const [salesLabelData, setSalesLabelData] = useState([]);
  const [selected, setSelected] = useState(0);
  const [selectedSale, setSelectedSale] = useState(0);
  const [openSelect, setOpenSelect] = useState(false);
  const [openSelectSale, setOpenSelectSale] = useState(false);
  const [totalMonthlyRevenue, setTotalMonthlyRevenue] = useState("");
  const [percentSalesChange, setPercentSalesChange] = useState(0);
  const [salesInfo, setSalesInfo] = useState("");
  const accountRef = useRef();

  useOutsideClick(accountRef, () => {
    setOpenSelect((pre) => false);
  });
  // const [transactionData, setTransactionData] = useState([]);

  // const getSalesData = async (month = 0) => {
  //   try {
  //     let url = process.env.REACT_APP_GET_SALES_DATA;
  //     let payload = {};
  //     if (month) {
  //       payload.value = month;
  //     }
  //     const response = await axiosPrivate.post(url, payload);
  //     if (response?.data?.response?.data) {
  //       setSalesInfo(response?.data?.response?.data);
  //       return response?.data?.response?.data;
  //     }
  //   } catch (err) {
  //     console.log("something went wrong ", err);
  //   }
  // };

  const getSalesData = async (fromDate, toDate) => {
    try {
      let url = process.env.REACT_APP_GET_TOTAL_REVENUE;
      let payload = {};
      if (fromDate && toDate) {
        payload.from_date = fromDate;
        payload.to_date = toDate;
      }
      setIsLoading(true);
      const response = await axiosPrivate.post(url, payload);
      setIsLoading(false);
      if (response?.data?.response?.data) {
        setSalesInfo(response?.data?.response?.data);
        return response?.data?.response?.data;
      }
    } catch (err) {
      console.log("something went wrong ", err);
    }
  };

  // const getTransactions = async (fromDate, toDate) => {
  //   try {
  //     let url = process.env.REACT_APP_GET_TOTAL_REVENUE;
  //     // url = `${url}&wallet_id=${wallet_id}`;
  //     let payload = {};
  //     // payload.wallet_id = wallet_id;
  //     // payload.transaction_type = transactionType;
  //     // payload.page = 1;
  //     // payload.no_of_entries = 10;
  //     if (fromDate && toDate) {
  //       payload.from_date = fromDate;
  //       payload.to_date = toDate;
  //     }

  //     setIsLoading(true);

  //     let response = await axiosPrivate.post(url, payload);
  //     setIsLoading(false);
  //     if (response?.data?.response?.data) {
  //       return response?.data?.response?.data;
  //     }
  //   } catch (err) {
  //     console.log("something went wrong", err);
  //   }
  // };
  //   const getCustomerData = async (month = 0) => {
  //     try {
  //       let url = process.env.REACT_APP_GET_CUSTOMER_DATA;
  //       let payload = {};
  //       if (month) {
  //         payload.value = month;
  //       }
  //       const response = await axiosPrivate.post(url, payload);
  //       if (response?.data?.response?.data) {
  //         return response?.data?.response?.data;
  //       }
  //     } catch (err) {
  //       console.log("something went wrong ", err);
  //     }
  //   };
  //   const getAvgChargeAndSellingPrice = async () => {
  //     try {
  //       let url = process.env.REACT_APP_GET_CHARGE_PACKAGE;
  //       const response = await axiosPrivate.get(url);
  //       if (response?.data?.response?.data) {
  //         return response?.data?.response?.data;
  //       }
  //     } catch (err) {
  //       console.log("something went wrong", err);
  //     }
  //   };

  //   const getTopSellingPackages = async () => {
  //     try {
  //       let url = process.env.REACT_APP_TOP_SELLING_PACKAGE;
  //       let payload = {};
  //       payload.type = "M";
  //       const response = await axiosPrivate.post(url);
  //       if (response?.data?.response?.data) {
  //         return response?.data?.response?.data;
  //       }
  //     } catch (err) {
  //       console.log("something went wrong", err);
  //     }
  //   };

  useEffect(() => {
    if (effectRef.current) {
      effectRef.current = false;
      getTransactionData(selected);
      //   getAvgChargeAndSellingPrice().then((data) => {
      //     if (data?.average_charge) setAverageCharge(data.average_charge);
      //     if (data?.average_package_price)
      //       setAveragePackagePrice(data.average_package_price);
      //   });
      //   getTopSellingPackages().then((data) => {
      //     if (data?.package_records) setPackages(data.package_records);
      //   });
      //   getCustomerData().then((data) => {
      //     setCustomerData([]);
      //     setLabelData([]);
      //     if (data?.total_customers) {
      //       setTotalCustomer(data.total_customers);
      //     }
      //     if (data?.customer_data) {
      //       data.customer_data.forEach((item) => {
      //         setCustomerData((prevState) => [...prevState, item.customers]);
      //         setLabelData((prevState) => [...prevState, item.month]);
      //       });
      //     }
      //   });
      // getSalesData(fromDate, toDate).then((data) =>
      // {
      //   console.log("sfgdsgagsgagfafdsgfadsfgad");
      //   console.log(data, "aaaaaa");
      //   setSalesData([]);
      //   setSalesLabelData([]);
      //   if (data?.change_in_sales) {
      //     setPercentSalesChange(data?.change_in_sales);
      //   }
      //   if (data?.total_revenue) {
      //     console.log(data.total_revenue);
      //     setTotalSales(data.total_revenue);
      //   }
      //   if (data?.sales_data) {
      //     data.sales_data.forEach((item) => {
      //       setSalesData((prevState) => [...prevState, item.sales_amount]);
      //       setSalesLabelData((prevState) => [...prevState, item.month]);
      //     });
      //   }
      // });
    }
  }, [selected]);
  //   const getDataForCustomer = (month) => {
  //     setCustomerData([]);
  //     setLabelData([]);
  //     getCustomerData(month).then((data) => {
  //       if (data?.total_customers) {
  //         setTotalCustomer(data.total_customers);
  //       }
  //       if (data?.customer_data) {
  //         data.customer_data.forEach((item) => {
  //           setCustomerData((prevState) => [...prevState, item.customers]);
  //           setLabelData((prevState) => [...prevState, item.month]);
  //         });
  //       }
  //     });
  //   };

  const getTransactionData = (data) => {
    let fromDate, toDate;
    const today = new Date();
    toDate = moment(today).subtract(1,'months').endOf('month').format('YYYY-MM-DD') + " 23:59:59";
    if (data == 0) {
      fromDate = moment(today).startOf('month').format('YYYY-MM-DD') + " 00:00:00";
      toDate = moment(today).format('YYYY-MM-DD') + " 23:59:59";
    } else if (data == 3) {
      fromDate = moment(today).subtract(3,'months').startOf('month').format('YYYY-MM-DD') + " 00:00:00";
    } else if (data == 6) {
      fromDate = fromDate = moment(today).subtract(6,'months').startOf('month').format('YYYY-MM-DD') + " 00:00:00";
    } else if (data == 12) {
      fromDate = fromDate = moment(today).subtract(12,'months').startOf('month').format('YYYY-MM-DD') + " 00:00:00";
    }

    getDataForSales(fromDate, toDate);
    // console.log(data, "dfgh");
    // if (data?.revenue_data != null) setTransactionData(data.revenue_data);
  };
  // useEffect(() => {
  //   getTransactions().then((data) => {
  //     if (data?.transactions != null) setTransactionData(data.transactions);
  //   });
  // }, [transactionType]);

  const getDataForSales = (fromDate, toDate) => {
    setSalesData([]);
    setSalesLabelData([]);
    getSalesData(fromDate, toDate).then((data) => {
      if (data?.total_revenue) {
        setTotalSales(data.total_revenue);
      }
      if (data?.monthly_revenue) {
        setTotalMonthlyRevenue(data.monthly_revenue);
      }

      if (data?.revenue_data) {
        data.revenue_data.forEach((item) => {
          setSalesData((prevState) => [...prevState, item.total_revenue]);
          setSalesLabelData((prevState) => [...prevState, item.month]);
        });
      }
    });
  };
  return (
    <>
      <div className="column revenueGraph">
        <div className="boxT1">
          <h4>
            Revenue this month
            <div className="multiOption">
              <div
                ref={accountRef}
                className={openSelect ? "selectBox open" : "selectBox"}
                onClick={() => setOpenSelect((pre) => !pre)}
              >
                {selected == 0 ? (
                  <p>
                    This month {""}
                    <i className="material-symbols-rounded grey">expand_more</i>
                  </p>
                ) : (
                  <p>
                    Last {selected} month {""}
                    <i className="material-symbols-rounded grey">expand_more</i>
                  </p>
                )}
                <div className="selectDrop">
                  <ul className="dropMenu">
                    {/* <li class="selected">
                                                <a href="javascript:void(0);">Item Name One
                                                <i class="material-symbols-rounded">done</i></a>
                                            </li> */}
                    <li
                      className={selected == 0 ? "selected" : ""}
                      onClick={() => {
                        setSelected(0);
                        getTransactionData(0);
                      }}
                    >
                      <a href="javascript:void(0);">This month</a>
                    </li>
                    <li
                      className={selected == 3 ? "selected" : ""}
                      onClick={() => {
                        setSelected(3);
                        getTransactionData(3);
                      }}
                    >
                      <a href="javascript:void(0);">Last 3 months</a>
                    </li>
                    <li
                      className={selected == 6 ? "selected" : ""}
                      onClick={() => {
                        setSelected(6);
                        getTransactionData(6);
                      }}
                    >
                      <a href="javascript:void(0);">Last 6 months</a>
                    </li>
                    <li
                      className={selected == 12 ? "selected" : ""}
                      onClick={() => {
                        setSelected(12);
                        getTransactionData(12);
                      }}
                    >
                      <a href="javascript:void(0);">Last 12 months</a>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </h4>

          <div className="recordCount">
            <span>${totalSales}</span>
            {selectedSale == 0 && (
              <em>
                {" "}
                {CurrencyFormat(totalMonthlyRevenue)} from{" "}
                {selected === 0 ? "this" : selected} month
              </em>
            )}
          </div>

          <div className="boxT1">
            <h4>Sales</h4>

            <div className="graph mt-24">
              <BarGraph
                label={salesLabelData}
                customerData={salesData}
                type="Sales"
              />
            </div>
          </div>
        </div>
      </div>
    </>
  );
}

export default SalesGraph;
