import React, { useEffect, useRef, useState } from "react";
import useAuth from "../../hooks/useAuth";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import BillSummary from "./BillSummary";
import { useParams } from "react-router-dom";
import { unavailable } from "../../configuration/GlobalConfig";
import useOutsideClick from "../../hooks/useOutsideClick";
import { FormatDate } from "../../utils/FormatDate";
import { CurrencyFormat } from "../../utils/CurrencyFormat";
import Error from "../UI/Error";
import moment from "moment";
function TransactionList({ wallet_id, success, setSuccess }) {
  const [expanded, setExpanded] = useState(-1);
  const { auth } = useAuth();
  const params = useParams();
  const axiosPrivate = useAxiosIntercept();
  const [transactionData, setTransactionData] = useState([]);
  const [transactionType, setTransactionType] = useState("debit");
  const [isLoading, setIsLoading] = useState(false);
  const [summaryData, setSummaryData] = useState([]);
  const [selected, setSelected] = useState(-1);
  const [durationSelected, setDurationSelected] = useState(-1);
  const [openSelect, setOpenSelect] = useState(false);
  const accountRef = useRef();

  const [openDurationDropdown, setOpenDurationDropDown] = useState(false);
  const [fromdate, setfromdate] = useState("");
  const [todate, settodate] = useState("");
  const [error, setErrors] = useState("")
  const getBookingDetails = async (order_id) => {
    setSummaryData([]);
    try {
      const url = process.env.REACT_APP_GET_ORDER_DETAILS_BY_ORDER_ID;
      let payload = {};
      if (order_id) payload.order_id = order_id;
      const response = await axiosPrivate.post(url, payload);
      if (response?.data?.response?.data) {
        if (response?.data?.response?.data?.booking_records != null) {
          setSummaryData(response?.data?.response?.data?.booking_records[0]);
        }
      }
    } catch (err) {
      console.log("something went wrong ", err);
    }
  };
  useOutsideClick(accountRef, () => {
    setOpenSelect((pre) => false);
  });

  const getTransactions = async (fromDate, toDate, firstDayOfMonth, today, data) => {

    try {
      let url = process.env.REACT_APP_GET_BILLING_TRANSACTION;
      url = `${url}&wallet_id=${wallet_id}`;

      let payload = {};
      payload.wallet_id = wallet_id;
      payload.transaction_type = transactionType;
      payload.page = 1;
      payload.no_of_entries = 10;
      if (data == 0) {
        payload.from_date = moment(firstDayOfMonth).format("YYYY-MM-DD");
        payload.to_date = moment(today).format("YYYY-MM-DD");
      }
      if (fromDate && toDate) {
        payload.from_date = moment(fromDate).format("YYYY-MM-DD");
        payload.to_date = moment(toDate).format("YYYY-MM-DD");
      }
      // else {
      //   payload.from_date = moment(firstDayOfMonth).format("YYYY-MM-DD");
      //   payload.to_date = moment(today).format("YYYY-MM-DD")
      // }

      setIsLoading(true);

      let response = await axiosPrivate.post(url, payload);
      setIsLoading(false);
      if (response?.data?.response?.data) {
        //setSuccess(!success);
        return response?.data?.response?.data;
      }
    } catch (err) {
      console.log("something went wrong", err);
    }
  };

  useEffect(() => {
    getTransactions().then((data) => {
      if (data?.transactions != null) setTransactionData(data.transactions);
    });
  }, [transactionType, success]);
  const downloadReport = async (fromDate, toDate, firstDayOfMonth, today) => {

    setErrors("");
    try {
      let url = process.env.REACT_APP_DOWNLOAD_REPORT;
      url = `${url}&wallet_id=${wallet_id}`;

      let payload = {};
      payload.wallet_id = wallet_id;
      payload.transaction_type = transactionType;
      payload.report_type = "accounts";
      payload.page = 1;
      payload.no_of_entries = 10;
      if (fromDate && toDate) {
        payload.from_date = moment(fromDate).format("YYYY-MM-DD");
        payload.to_date = moment(toDate).format("YYYY-MM-DD");
      }
      else {
        payload.from_date = moment(firstDayOfMonth).format("YYYY-MM-DD");
        payload.to_date = moment(today).format("YYYY-MM-DD")
      }

      // setIsLoading(true);
      let response = await axiosPrivate.post(url, payload);

      // setIsLoading(false);
      if (response?.data?.status == "200") {
        window.open(
          response?.data?.response?.data?.url,
          "_self",
          "noreferrer"
        );
      }
      else {
        setErrors(response?.data?.response?.errors[0]?.message)

      }
    } catch (err) {
      console.log("something went wrong", err);
    }
  };
  const getReportData = (data) => {
    let fromDate, toDate;
    const today = new Date();
    const firstDayOfMonth = new Date(today.getFullYear(), today.getMonth(), 1);
    //console.log("firstday", firstDayOfMonth)
    const lastDayOfPreviousMonth = new Date(firstDayOfMonth - 1);
    // console.log(lastDayOfPreviousMonth, "lastDay")

    const year = lastDayOfPreviousMonth.getFullYear();
    const month = String(lastDayOfPreviousMonth.getMonth() + 1).padStart(
      2,
      "0"
    );
    const day = String(lastDayOfPreviousMonth.getDate()).padStart(2, "0");
    const formattedDate = `${year}-${month}-${day}`;
    toDate = formattedDate;
    settodate(toDate);

    // const firstDayOfPreviousMonth = new Date(firstDayOfMonth - 1);
    const firstDayOfPreviousMonth = new Date(today.getFullYear(), today.getMonth() - 1, 1)


    const firstDayOfThirdMonthBefore = new Date(firstDayOfPreviousMonth);

    if (data == 0) {
      fromDate = 0;
      setfromdate(fromDate);
    } else if (data == 3) {
      firstDayOfThirdMonthBefore.setMonth(
        firstDayOfThirdMonthBefore.getMonth() - 2
      );

      fromDate = firstDayOfThirdMonthBefore;
      //firstDayOfThirdMonthBefore.setDate(1);

      // fromDate = firstDayOfThirdMonthBefore.toISOString().slice(0, 10);

      setfromdate(fromDate);
    } else if (data == 6) {
      firstDayOfThirdMonthBefore.setMonth(
        firstDayOfThirdMonthBefore.getMonth() - 5
      );
      fromDate = firstDayOfThirdMonthBefore;
      // firstDayOfThirdMonthBefore.setDate(1);
      // fromDate = firstDayOfThirdMonthBefore.toISOString().slice(0, 10);
      setfromdate(fromDate);
    } else if (data == 12) {
      firstDayOfThirdMonthBefore.setMonth(
        firstDayOfThirdMonthBefore.getMonth() - 11
      );
      fromDate = firstDayOfThirdMonthBefore
      // firstDayOfThirdMonthBefore.setDate(1);
      // fromDate = firstDayOfThirdMonthBefore.toISOString().slice(0, 10);
      setfromdate(fromDate);
    }
    // getTransactions(fromDate, toDate).then((data) => {
    //   if (data?.transactions != null) setTransactionData(data.transactions);
    // });
    downloadReport(fromDate, toDate, firstDayOfMonth, today);
  };

  const getTransactionData = (data) => {
    let fromDate, toDate;
    const today = new Date();
    const firstDayOfMonth = new Date(today.getFullYear(), today.getMonth(), 1);
    const lastDayOfPreviousMonth = new Date(firstDayOfMonth - 1);

    const year = lastDayOfPreviousMonth.getFullYear();
    const month = String(lastDayOfPreviousMonth.getMonth() + 1).padStart(
      2,
      "0"
    );
    const day = String(lastDayOfPreviousMonth.getDate()).padStart(2, "0");
    const formattedDate = `${year}-${month}-${day}`;
    toDate = formattedDate;

    //const firstDayOfPreviousMonth = new Date(firstDayOfMonth - 1);
    const firstDayOfPreviousMonth = new Date(today.getFullYear(), today.getMonth() - 1, 1)
    const firstDayOfThirdMonthBefore = new Date(firstDayOfPreviousMonth);
    if (data == 0) {
      fromDate = 0;
    } else if (data == 3) {
      firstDayOfThirdMonthBefore.setMonth(
        firstDayOfThirdMonthBefore.getMonth() - 2
      );
      fromDate = firstDayOfThirdMonthBefore;
      // firstDayOfThirdMonthBefore.setDate(1);
      // fromDate = firstDayOfThirdMonthBefore.toISOString().slice(0, 10);
    } else if (data == 6) {
      firstDayOfThirdMonthBefore.setMonth(
        firstDayOfThirdMonthBefore.getMonth() - 5
      );
      fromDate = firstDayOfThirdMonthBefore;
      //firstDayOfThirdMonthBefore.setDate(1);
      //fromDate = firstDayOfThirdMonthBefore.toISOString().slice(0, 10);
    } else if (data == 12) {
      firstDayOfThirdMonthBefore.setMonth(
        firstDayOfThirdMonthBefore.getMonth() - 11
      );
      fromDate = firstDayOfThirdMonthBefore;
      // firstDayOfThirdMonthBefore.setDate(1);
      // fromDate = firstDayOfThirdMonthBefore.toISOString().slice(0, 10);
    }
    getTransactions(fromDate, toDate, firstDayOfMonth, today, data).then((data) => {
      if (data?.transactions != null) setTransactionData(data.transactions);
    });
  };

  return (
    <>

      <div className="navTabs mt-24 mb-24">
        <ul className="level1">
          <li
            style={{ cursor: "pointer" }}
            className={transactionType == "debit" ? "selected" : ""}
            onClick={(e) => {
              e.preventDefault();
              setTransactionType("debit");
            }}
          >
            <a>Unpaid</a>
          </li>
          <li
            style={{ cursor: "pointer" }}
            className={transactionType == "credit" ? "selected" : ""}
            onClick={(e) => {
              e.preventDefault();
              setTransactionType("credit");
            }}
          >
            <a>Paid</a>
          </li>
        </ul>
      </div>
      <div className="subContent">
        <div className="filterBlock dForm mb-16 account">
          <div className="multiOption">
            <h5 className="mb-8">Filter by</h5>
            <div
              ref={accountRef}
              className={openSelect ? "selectBox open" : "selectBox"}
              onClick={() => setOpenSelect((pre) => !pre)}
            >
              {selected == "-1" ? (<> <p>
                Select duration {""}
                <i className="material-symbols-rounded grey">expand_more</i>
              </p></>) : selected == 0 ? (
                <p>
                  This month {""}
                  <i className="material-symbols-rounded grey">expand_more</i>
                </p>
              ) : (
                <p>
                  Last {selected} month {""}
                  <i className="material-symbols-rounded grey">expand_more</i>
                </p>
              )}
              <div className="selectDrop">
                <ul className="dropMenu">

                  <li
                    className={selected == 0 ? "selected" : ""}
                    onClick={() => {
                      setSelected(0);
                      getTransactionData(0);
                    }}
                  >
                    <a>This month</a>
                  </li>
                  <li
                    className={selected == 3 ? "selected" : ""}
                    onClick={() => {
                      setSelected(3);
                      getTransactionData(3);
                    }}
                  >
                    <a>Last 3 months</a>
                  </li>
                  <li
                    className={selected == 6 ? "selected" : ""}
                    onClick={() => {
                      setSelected(6);
                      getTransactionData(6);
                    }}
                  >
                    <a>Last 6 months</a>
                  </li>
                  <li
                    className={selected == 12 ? "selected" : ""}
                    onClick={() => {
                      setSelected(12);
                      getTransactionData(12);
                    }}
                  >
                    <a>Last 12 months</a>
                  </li>
                </ul>
              </div>
            </div>
          </div>
          <div class="multiOption">
            <h5 class="mb-8">
              Download report
            </h5>
            <div className={openDurationDropdown ? "selectBox open" : "selectBox"} onClick={() => setOpenDurationDropDown((pre) => !pre)}>
              {durationSelected == "-1" ? (
                <p>
                  Select duration {""}
                  <i className="material-symbols-rounded grey">expand_more</i>
                </p>
              ) :
                durationSelected == "0" ? (<>
                  <p>
                    This month {""}
                    <i className="material-symbols-rounded grey">expand_more</i>
                  </p>

                </>) :
                  (
                    <p>
                      Last {durationSelected} month {""}
                      <i className="material-symbols-rounded grey">expand_more</i>
                    </p>
                  )}
              <div class="selectDrop">
                <ul class="dropMenu">
                  <li
                    className={durationSelected == 0 ? "selected" : ""}
                    onClick={() => {
                      setDurationSelected(0);
                      getReportData(0);
                      setErrors("");
                    }}
                  >
                    <a>This month</a>
                  </li>
                  <li
                    className={durationSelected == 3 ? "selected" : ""}
                    onClick={() => {
                      setDurationSelected(3);
                      getReportData(3);
                      setErrors("");
                    }}
                  >
                    <a>Last 3 months</a>
                  </li>
                  <li
                    className={durationSelected == 6 ? "selected" : ""}
                    onClick={() => {
                      setDurationSelected(6);
                      getReportData(6);
                      setErrors("");
                    }}
                  >
                    <a>Last 6 months</a>
                  </li>
                  <li
                    className={durationSelected == 12 ? "selected" : ""}
                    onClick={() => {
                      setDurationSelected(12);
                      getReportData(12);
                      setErrors("");
                    }}
                  >
                    <a>Last 12 months</a>
                  </li>
                </ul>
              </div>
            </div>
            <Error error={error} />
          </div>
        </div>
        {transactionData.length > 0 ? (
          <>
            <div className="dataTableDynamic ">
              <table>
                <tbody>
                  <tr>
                    <th>Date</th>
                    <th>Invoice ID</th>
                    <th>Amount</th>
                    {transactionType=="debit"&&<th>&nbsp;</th>}
                    
                  </tr>
                  {isLoading ? (
                    <p>Loading...</p>
                  ) : transactionData.length != 0 ? (
                    transactionData.map((item) => {
                      return (
                        <>
                          <tr
                            className={
                              expanded == item.transaction_id ? "active" : ""
                            }
                          >
                            <td className="vName">
                              {FormatDate(item.transaction_date)}
                            </td>
                            <td>
                              {item.invoice_no ? item.invoice_no : unavailable}
                            </td>
                            {transactionType == "debit" ? (
                              <td className="error">
                                {CurrencyFormat(item.debit_amount)}
                              </td>
                            ) : (
                              <td className="success">
                                {CurrencyFormat(item.credit_amount)}
                              </td>
                            )}
                            {
                              transactionType == "debit" &&
                              <td
                              style={{ cursor: "pointer" }}
                              className="right"
                              onClick={() => { if (expanded == item.transaction_id) { setExpanded(-1) } else getBookingDetails(item.entity_id).then((data) => { setExpanded(item.transaction_id); }); }}
                            >
                              
                              <i
                              className={
                                expanded == item.transaction_id
                                  ? "material-symbols-rounded arrowTop mt-l"
                                  : "material-symbols-rounded arrowBottom mt-l"
                              }
                            >
                              expand_more
                            </i>
                              
                              
                            </td> 
                            }
                           
                          </tr>
                          {expanded == item.transaction_id &&transactionType=="debit"&& (
                            <BillSummary summary={summaryData} />
                          )}
                        </>
                      );
                    })
                  ) : (
                    <p>No data found</p>
                  )}
                  { }
                </tbody>
              </table>
            </div>
          </>
        ) : (
          <>No data found</>
        )}
      </div>
    </>
  );
}

export default TransactionList;
