import React from "react";
import { useEffect, useState } from "react";
import Overlay from "../../utils/Overlay";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import { unavailable } from "../../configuration/GlobalConfig";
import Success from "../UI/Success";
import Error from "../UI/Error";

const AttendantInActive = ({
  onBackdropClick,
  showPopUP,
  firstname,
  lastname,
  age,
  gender,
  registration_no,
  success,
  setSuccess,
  user_id,
  status,
  attendentInfo,
  setAttendentInfo,
  index,
  attendantStatusValue,
}) => {
  const [cancellationReasons, setCancellationReasons] = useState([]);
  const [reasonId, setReasonId] = useState("");
  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, seterrorMessage] = useState("");
  const axiosPrivate = useAxiosIntercept();
  const handelCancellationReasons = (e) => {
    setReasonId(e.target.id);
  };

  let name = "";
  const fullName = () => {
    const fname = name + firstname ? firstname.firstname : "";
    name = lastname ? fname + " " + lastname.lastname : fname;

    return name;
  };
  const HandelInActive = async () => {
    if (reasonId) {
      const inActiveReques = {
        user_id: user_id.user_id,
        user_data: {
          status: "D",
          reason_id: reasonId,
        },
      };

      const inActiveUrl = process.env.REACT_APP_UPDATE_ATTENDANT_STATUS;
      const inActiveResponse = await axiosPrivate.post(
        inActiveUrl,
        inActiveReques
      );

      if (inActiveResponse?.data?.status === 200) {
        seterrorMessage("");
        setSuccessMessage(inActiveResponse?.data?.message);

        const temp = [...attendentInfo];
        temp[index.i]["status"] = "D";

        setAttendentInfo(temp);
        setTimeout(() => {
          onBackdropClick();
        }, 3000);
      }
    } else if (reasonId == "" && status.status == "D") {
      const inActiveReques = {
        user_id: user_id.user_id,
        user_data: {
          status: "A",
        },
      };

      const inActiveUrl = process.env.REACT_APP_UPDATE_ATTENDANT_STATUS;
      const inActiveResponse = await axiosPrivate.post(
        inActiveUrl,
        inActiveReques
      );

      if (inActiveResponse?.data?.status === 200) {
        seterrorMessage("");
        setSuccessMessage(inActiveResponse?.data?.message);
        const temp = [...attendentInfo];
        temp[index.i]["status"] = "A";
        temp[index.i]["driver_status"] = "A";
        setAttendentInfo(temp);
        setTimeout(() => {
          onBackdropClick(attendantStatusValue == "D" ? true : "");
        }, 3000);
      }
    } else if (reasonId === "" && status.status !== "D") {
      seterrorMessage("Please select reason");
    }
  };
  const closeInActiveForm = () => {
    onBackdropClick();
  };

  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();

    const getCancellationReasons = async () => {
      let URL = process.env.REACT_APP_GET_CANCELLATION_REASONS_FOR_ATTENDANT;
      try {
        if (status.status !== "D") {
          const response = await axiosPrivate.get(URL, {
            signal: controller.signal,
          });
          isMounted &&
            setCancellationReasons(
              response?.data?.response?.data?.cancellation_reasons
            );
        }
      } catch (err) {
        // seterror(err);
      }
    };

    getCancellationReasons();
    // }

    return () => {
      isMounted = false;
      controller.abort();
      // effectRun.current = true; // update the value of effectRun to true
    };
  }, []);

  return showPopUP ? (
    <>
      <Overlay>
        <div
          class="model_box_child assignInactive"
          id="assignInactive"
          style={{ width: "300px" }}
        >
          <div class="ap_heading">
            <h4>
              Mark vehicle as inactive{" "}
              <span
                style={{ marginLeft: "auto" }}
                onClick={closeInActiveForm}
                class="material-symbols-rounded black close_model"
              >
                close
              </span>
            </h4>
          </div>
          <div class="contentSection" style={{ paddingTop: "24px" }}>
            <section class="assignPromoP dForm">
              <div class="promoText customer">
                <h4>{fullName()}</h4>
                <p>
                  {`${
                    registration_no == undefined
                      ? registration_no.registration_no
                      : ""
                  }${age == undefined ? age.age + " yrs," : ""} ${
                    gender
                      ? gender.gender === "M"
                        ? "male"
                        : "female"
                      : unavailable
                  }`}
                </p>
              </div>
              {status.status !== "D" && (
                <div class="fieldGroup">
                  <label>Select reason to mark inactive</label>
                  <ul class="yType">
                    {cancellationReasons ? (
                      <>
                        {cancellationReasons.map((reasons) => {
                          return (
                            <li>
                              <input
                                type="radio"
                                id={`${reasons?.reason_id}`}
                                name="cancellationReasons"
                                value={`${reasons?.reason}`}
                                onClick={(e) => handelCancellationReasons(e)}
                              />
                              <label for={`${reasons?.reason_id}`}>
                                {reasons?.reason}
                              </label>
                            </li>
                          );
                        })}
                      </>
                    ) : (
                      <></>
                    )}
                  </ul>
                </div>
              )}
            </section>
            <div class="actionButtons mt-24">
              <span>
                {status.status !== "D" ? (
                  <a onClick={HandelInActive} class="btn prim btnError fullW">
                    Mark inactive
                  </a>
                ) : (
                  <a onClick={HandelInActive} class="btn prim btnSuccess fullW">
                    Mark active
                  </a>
                )}
                {/* <a onClick={HandelInActive} class="btn prim btnError fullW">
                    Mark inactive
                  </a> */}
              </span>
              {successMessage ? <Success success={successMessage} /> : <></>}
              {reasonId === "" && errorMessage ? (
                <Error error={errorMessage} />
              ) : (
                <></>
              )}
            </div>
          </div>
        </div>
      </Overlay>
    </>
  ) : (
    <></>
  );
};

export default AttendantInActive;
