import React, { useState, useEffect } from "react";
import { useLocation, useParams, Link, useNavigate } from "react-router-dom";
import { FormatDate } from "../../utils/FormatDate";
import BookingCard from "../UI/BookingCard";
import { HourMapping } from "../../configuration/createPackageFormConfigs";
import { unavailable } from "../../configuration/GlobalConfig";
import { Time } from "../../utils/Time";
import Spinner from "../UI/Spinner";
import DataNotFound from "../UI/DataNotFound";
import useAuth from "../../hooks/useAuth";
import NoPriviliges from "../UI/NoPriviliges";

const AttendantPastBooking = ({ pastBookingData, lastElementRef }) => {
  const [toggle, setToggle] = useState({});
  const { auth } = useAuth();
  const handleExpand = (e) => {
    setToggle({ [e.currentTarget.id]: !toggle[e.currentTarget.id] });
  };
  var addOns = "";
  return pastBookingData == "" ? (
    <Spinner />
  ) : Object.keys(pastBookingData).length !== 0 ? (
    auth.priviliges.includes("read_bookings") ? (
      <div className="dataTableDynamic">
        <table>
          <thead>
            <tr>
              <th>Car details</th>
              <th>Booking date</th>
              <th>Booking slot</th>
              <th>Booked by</th>
              <th>Address</th>
              <th>Add-ons</th>
              <th>Puppy</th>
              <th>Total bill</th>
              <th>&nbsp;</th>
            </tr>
          </thead>
          <tbody>
            {pastBookingData.length != 0 ? (
              <>
                {pastBookingData.map((bookingsData, i) => {
                  addOns = "";
                  const planInfo = () => {
                    var packageTypeId =
                      bookingsData?.package_info?.package_type_id;
                    var info = "";
                    const packageName =
                      bookingsData?.package_info?.package_name;
                    const packagePrice = "";
                    const packageDuration =
                      bookingsData.package_info.package_duration;
                    const packageDurationUnit =
                      bookingsData?.package_info?.package_duration_unit;
                    info = packageName ? info + packageName : info;
                    info =
                      parseInt(packagePrice) != 0
                        ? info + " @$" + packagePrice
                        : info;
                    info =
                      packageTypeId != 1 && packageDuration != 0
                        ? info + " (" + packageDuration
                        : info;
                    info =
                      packageTypeId != 1 &&
                      packageDuration != 0 &&
                      packageDurationUnit
                        ? info + HourMapping?.[packageDurationUnit] + ")"
                        : info;
                    return info;
                  };
                  if (pastBookingData.length == i + 1) {
                    return (
                      <React.Fragment key={i}>
                        <tr
                          ref={lastElementRef}
                          onClick={(e) => handleExpand(e)}
                          id={i}
                          style={{ cursor: "pointer" }}
                        >
                          <td className="vName">
                            <span>
                              {bookingsData?.vehicle_info?.brand_name
                                ? bookingsData?.vehicle_info?.brand_name
                                : unavailable}
                            </span>
                            <span>
                              {bookingsData?.vehicle_info?.registration_no
                                ? bookingsData?.vehicle_info?.registration_no
                                : unavailable}
                            </span>
                          </td>
                          <td>
                            {FormatDate(
                              bookingsData.booking_info.booking_created_on
                            )}
                          </td>
                          <td>
                            {FormatDate(bookingsData.booking_info.booking_slot)}
                          </td>
                          {bookingsData?.user_profile_data ? (
                            <>
                              <td>{`${
                                bookingsData?.user_profile_data?.firstname
                                  ? bookingsData?.user_profile_data?.firstname +
                                    " " +
                                    bookingsData?.user_profile_data?.lastname
                                  : unavailable
                              }`}</td>
                              <td>
                                {bookingsData?.user_profile_data?.address
                                  ? bookingsData?.user_profile_data?.address
                                  : unavailable}
                              </td>
                            </>
                          ) : (
                            <>
                              <td>{unavailable}</td>
                              <td>{unavailable}</td>
                            </>
                          )}

                          {bookingsData?.booking_add_ons ? (
                            bookingsData?.booking_add_ons.map(
                              (bookingAddOnsData, index) => {
                                bookingAddOnsData?.service_name &&
                                bookingAddOnsData.service_status !== "6" ? (
                                  <>
                                    {
                                      (addOns =
                                        addOns +
                                        bookingAddOnsData?.service_name +
                                        ",")
                                    }
                                  </>
                                ) : (
                                  <>{unavailable}</>
                                );
                              }
                            )
                          ) : (
                            <></>
                          )}

                          <td>
                            {addOns
                              ? addOns.substring(0, addOns.length - 1)
                              : unavailable}
                          </td>

                          {bookingsData?.puppy_info ? (
                            <td>
                              <a>
                                {bookingsData?.puppy_info?.registration_no
                                  ? bookingsData?.puppy_info?.registration_no
                                  : unavailable}
                              </a>
                            </td>
                          ) : (
                            <td>
                              <a>{unavailable}</a>
                            </td>
                          )}
                          <td>{`$${bookingsData?.booking_info?.total}`}</td>
                          {toggle[i] ? (
                            <td className="right">
                              <i
                                id={i}
                                className="material-symbols-rounded arrowTop mt-l"
                              >
                                expand_more
                              </i>
                            </td>
                          ) : (
                            <td className="right">
                              <i
                                id={i}
                                className="material-symbols-rounded arrowBottom mt-l"
                              >
                                expand_more
                              </i>
                            </td>
                          )}
                        </tr>
                        {toggle[i] ? (
                          <>
                            <tr className="expanded">
                              <td colspan="8">
                                <div className="vehicleBill">
                                  <div className="time">
                                    <div className="YRow pt-8 pb-8">
                                      <BookingCard
                                        className="boxT1"
                                        heading="Plan"
                                        headingValue={
                                          bookingsData?.package_info
                                            ?.package_type_id !== "1"
                                            ? planInfo()
                                              ? planInfo()
                                              : unavailable
                                            : "Pay-As-You-Go"
                                        }
                                        subValue=""
                                      />
                                      <BookingCard
                                        className="boxT1"
                                        heading="Driver Time"
                                        headingValue={""}
                                        subValue={
                                          bookingsData?.booking_info
                                            ?.driver_assigned_on
                                            ? `${Time(
                                                bookingsData?.booking_info
                                                  ?.driver_assigned_on
                                              )} - ${Time(
                                                bookingsData?.booking_info
                                                  ?.driver_reached_on
                                              )}`
                                            : "N/A"
                                        }
                                      />
                                      <BookingCard
                                        className="boxT1"
                                        heading="Job Time"
                                        headingValue={""}
                                        subValue={
                                          bookingsData?.booking_info
                                            ?.job_started
                                            ? `
                                    ${Time(
                                      bookingsData?.booking_info?.job_started
                                    )} - ${Time(
                                                bookingsData?.booking_info
                                                  ?.job_done
                                              )}`
                                            : "N/A"
                                        }
                                      />

                                      {bookingsData.charging_data ? (
                                        <>
                                          <BookingCard
                                            className="boxT1"
                                            heading="Charge done"
                                            headingValue={`${bookingsData?.charging_data?.charging_done} kWH`}
                                            subValue={`@$${bookingsData?.charging_data.service_charge}`}
                                          />
                                        </>
                                      ) : (
                                        <>
                                          <BookingCard
                                            className="boxT1"
                                            heading="Charge done"
                                            headingValue={unavailable}
                                            subValue={unavailable}
                                          />
                                        </>
                                      )}
                                    </div>
                                  </div>
                                  <div className="summary">
                                    <div className="YRow pt-8 pb-8 ml-24">
                                      <div className="boxT1">
                                        <h4>Bill summary</h4>
                                        <div className="listRow">
                                          <p>
                                            <span>Total charge</span>

                                            <span>
                                              {bookingsData?.charging_data
                                                ?.charging_cost ? (
                                                bookingsData?.charging_data?.charging_cost.slice(
                                                  0,
                                                  1
                                                ) != "0" ? (
                                                  "$" +
                                                  bookingsData?.charging_data
                                                    ?.charging_cost
                                                ) : (
                                                  "Free"
                                                )
                                              ) : (
                                                <>{unavailable}</>
                                              )}
                                            </span>
                                          </p>
                                        </div>
                                        <div className="listRow">
                                          <h5>Add-ons</h5>

                                          {bookingsData?.booking_add_ons ? (
                                            bookingsData?.booking_add_ons.map(
                                              (bookingAddOnsData) => {
                                                const {
                                                  service_charge,
                                                  service_name,
                                                  service_status,
                                                } = bookingAddOnsData;
                                                return (
                                                  service_status !== "6" && (
                                                    <p>
                                                      <span>
                                                        {service_name !== null
                                                          ? service_name
                                                          : unavailable}
                                                      </span>
                                                      <span>
                                                        {service_charge !==
                                                        null ? (
                                                          service_charge !=
                                                          "0.00" ? (
                                                            "$" + service_charge
                                                          ) : (
                                                            "Free"
                                                          )
                                                        ) : (
                                                          <>{unavailable}</>
                                                        )}
                                                      </span>
                                                    </p>
                                                  )
                                                );
                                              }
                                            )
                                          ) : (
                                            <>{unavailable}</>
                                          )}
                                        </div>
                                        <div className="listRow">
                                          <h5>Surcharge</h5>
                                          <p>
                                            <span>Service charge</span>

                                            <span>
                                              {bookingsData?.booking_info
                                                ?.service_cost != "0.00"
                                                ? "$" +
                                                  bookingsData?.booking_info
                                                    ?.service_cost
                                                : "Free"}
                                            </span>
                                          </p>
                                          <p>
                                            <span>Parking charge</span>
                                            <span>
                                              {bookingsData?.booking_info
                                                ?.parking_fee != "0.00"
                                                ? "$" +
                                                  bookingsData?.booking_info
                                                    ?.parking_fee
                                                : "Free"}
                                            </span>
                                          </p>
                                        </div>
                                        <div className="listRow">
                                          <h5>Expense</h5>
                                          <p>
                                            <span>Parking paid by driver</span>
                                            <span>
                                              {bookingsData?.booking_info
                                                ?.parking_paid_by_driver !==
                                                undefined &&
                                              parseInt(
                                                bookingsData?.booking_info
                                                  ?.parking_paid_by_driver
                                              ) > 0
                                                ? "$" +
                                                  bookingsData?.booking_info
                                                    ?.parking_paid_by_driver
                                                : "Free"}
                                            </span>
                                          </p>
                                        </div>
                                        <div className="listRow">
                                          <p>
                                            <span>
                                              <b>GST</b>
                                            </span>
                                            <span>
                                              <a>
                                                {"$" +
                                                  bookingsData?.booking_info
                                                    ?.gst_cost}
                                              </a>
                                            </span>
                                          </p>
                                        </div>
                                        <div className="listRow">
                                          <p>
                                            <span>
                                              <b>Credits used</b>
                                            </span>
                                            <span>
                                              <a>
                                                {"$" +
                                                  bookingsData?.booking_info
                                                    ?.cb_used}
                                              </a>
                                            </span>
                                          </p>
                                        </div>
                                        <div className="listRow gTotal pad-0 mar-0">
                                          <p>
                                            <span>Total bill paid</span>
                                            <span>
                                              {"$" +
                                                bookingsData?.booking_info
                                                  ?.total}
                                            </span>
                                          </p>
                                        </div>
                                        <div class="insentive mt-16">
                                          <p>
                                            Total upsell incentive{" "}
                                            <span>
                                              {bookingsData?.booking_info
                                                ?.driver_upsell
                                                ? "$" +
                                                  bookingsData?.booking_info
                                                    ?.driver_upsell
                                                : "$0"}
                                            </span>
                                          </p>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </td>
                            </tr>
                          </>
                        ) : (
                          <></>
                        )}
                      </React.Fragment>
                    );
                  } else {
                    return (
                      <React.Fragment key={i}>
                        <tr
                          onClick={(e) => handleExpand(e)}
                          id={i}
                          style={{ cursor: "pointer" }}
                        >
                          <td className="vName">
                            <span>
                              {bookingsData?.vehicle_info?.brand_name
                                ? bookingsData?.vehicle_info?.brand_name
                                : unavailable}
                            </span>
                            <span>
                              {bookingsData?.vehicle_info?.registration_no
                                ? bookingsData?.vehicle_info?.registration_no
                                : unavailable}
                            </span>
                          </td>
                          <td>
                            {FormatDate(
                              bookingsData.booking_info.booking_created_on
                            )}
                          </td>
                          <td>
                            {FormatDate(bookingsData.booking_info.booking_slot)}
                          </td>
                          {bookingsData?.user_profile_data ? (
                            <>
                              <td>{`${
                                bookingsData?.user_profile_data?.firstname
                                  ? bookingsData?.user_profile_data?.firstname +
                                    " " +
                                    bookingsData?.user_profile_data?.lastname
                                  : unavailable
                              }`}</td>
                              <td>
                                {bookingsData?.user_profile_data?.address
                                  ? bookingsData?.user_profile_data?.address
                                  : unavailable}
                              </td>
                            </>
                          ) : (
                            <>
                              <td>{unavailable}</td>
                              <td>{unavailable}</td>
                            </>
                          )}

                          {bookingsData?.booking_add_ons ? (
                            bookingsData?.booking_add_ons.map(
                              (bookingAddOnsData, index) => {
                                bookingAddOnsData?.service_name &&
                                bookingAddOnsData.service_status !== "6" ? (
                                  <>
                                    {
                                      (addOns =
                                        addOns +
                                        bookingAddOnsData?.service_name +
                                        ",")
                                    }
                                  </>
                                ) : (
                                  <>{unavailable}</>
                                );
                              }
                            )
                          ) : (
                            <></>
                          )}

                          <td>
                            {addOns
                              ? addOns.substring(0, addOns.length - 1)
                              : unavailable}
                          </td>

                          {bookingsData?.puppy_info ? (
                            <td>
                              <a>
                                {bookingsData?.puppy_info?.registration_no
                                  ? bookingsData?.puppy_info?.registration_no
                                  : unavailable}
                              </a>
                            </td>
                          ) : (
                            <td>
                              <a>{unavailable}</a>
                            </td>
                          )}
                          <td>{`$${bookingsData?.booking_info?.total}`}</td>
                          {toggle[i] ? (
                            <td className="right">
                              <i
                                id={i}
                                className="material-symbols-rounded arrowTop mt-l"
                              >
                                expand_more
                              </i>
                            </td>
                          ) : (
                            <td className="right">
                              <i
                                id={i}
                                className="material-symbols-rounded arrowBottom mt-l"
                              >
                                expand_more
                              </i>
                            </td>
                          )}
                        </tr>
                        {toggle[i] ? (
                          <>
                            <tr className="expanded">
                              <td colspan="8">
                                <div className="vehicleBill">
                                  <div className="time">
                                    <div className="YRow pt-8 pb-8">
                                      <BookingCard
                                        className="boxT1"
                                        heading="Plan"
                                        headingValue={
                                          bookingsData?.package_info
                                            ?.package_type_id !== "1"
                                            ? planInfo()
                                              ? planInfo()
                                              : unavailable
                                            : "Pay-As-You-Go"
                                        }
                                        subValue=""
                                      />
                                      <BookingCard
                                        className="boxT1"
                                        heading="Driver Time"
                                        headingValue={""}
                                        subValue={
                                          bookingsData?.booking_info
                                            ?.driver_assigned_on
                                            ? `${Time(
                                                bookingsData?.booking_info
                                                  ?.driver_assigned_on
                                              )} - ${Time(
                                                bookingsData?.booking_info
                                                  ?.driver_reached_on
                                              )}`
                                            : "N/A"
                                        }
                                      />
                                      <BookingCard
                                        className="boxT1"
                                        heading="Job Time"
                                        headingValue={""}
                                        subValue={
                                          bookingsData?.booking_info
                                            ?.job_started
                                            ? `
                                    ${Time(
                                      bookingsData?.booking_info?.job_started
                                    )} - ${Time(
                                                bookingsData?.booking_info
                                                  ?.job_done
                                              )}`
                                            : "N/A"
                                        }
                                      />

                                      {bookingsData.charging_data ? (
                                        <>
                                          <BookingCard
                                            className="boxT1"
                                            heading="Charge done"
                                            headingValue={`${bookingsData?.charging_data?.charging_done} kWH`}
                                            subValue={`@$${bookingsData?.charging_data.service_charge}`}
                                          />
                                        </>
                                      ) : (
                                        <>
                                          <BookingCard
                                            className="boxT1"
                                            heading="Charge done"
                                            headingValue={unavailable}
                                            subValue={unavailable}
                                          />
                                        </>
                                      )}
                                    </div>
                                  </div>
                                  <div className="summary">
                                    <div className="YRow pt-8 pb-8 ml-24">
                                      <div className="boxT1">
                                        <h4>Bill summary</h4>
                                        <div className="listRow">
                                          <p>
                                            <span>Total charge</span>

                                            <span>
                                              {bookingsData?.charging_data
                                                ?.charging_cost ? (
                                                bookingsData?.charging_data?.charging_cost.slice(
                                                  0,
                                                  1
                                                ) != "0" ? (
                                                  "$" +
                                                  bookingsData?.charging_data
                                                    ?.charging_cost
                                                ) : (
                                                  "Free"
                                                )
                                              ) : (
                                                <>{unavailable}</>
                                              )}
                                            </span>
                                          </p>
                                        </div>
                                        <div className="listRow">
                                          <h5>Add-ons</h5>

                                          {bookingsData?.booking_add_ons ? (
                                            bookingsData?.booking_add_ons.map(
                                              (bookingAddOnsData) => {
                                                const {
                                                  service_charge,
                                                  service_name,
                                                  service_status,
                                                } = bookingAddOnsData;
                                                return (
                                                  service_status !== "6" && (
                                                    <p>
                                                      <span>
                                                        {service_name !== null
                                                          ? service_name
                                                          : unavailable}
                                                      </span>
                                                      <span>
                                                        {service_charge !==
                                                        null ? (
                                                          service_charge !=
                                                          "0.00" ? (
                                                            "$" + service_charge
                                                          ) : (
                                                            "Free"
                                                          )
                                                        ) : (
                                                          <>{unavailable}</>
                                                        )}
                                                      </span>
                                                    </p>
                                                  )
                                                );
                                              }
                                            )
                                          ) : (
                                            <>{unavailable}</>
                                          )}
                                        </div>
                                        <div className="listRow">
                                          <h5>Surcharge</h5>
                                          <p>
                                            <span>Service charge</span>

                                            <span>
                                              {bookingsData?.booking_info
                                                ?.service_cost != "0.00"
                                                ? "$" +
                                                  bookingsData?.booking_info
                                                    ?.service_cost
                                                : "Free"}
                                            </span>
                                          </p>
                                          <p>
                                            <span>Parking charge</span>
                                            <span>
                                              {bookingsData?.booking_info
                                                ?.parking_fee != "0.00"
                                                ? "$" +
                                                  bookingsData?.booking_info
                                                    ?.parking_fee
                                                : "Free"}
                                            </span>
                                          </p>
                                        </div>
                                        <div className="listRow">
                                          <h5>Expense</h5>
                                          <p>
                                            <span>Parking paid by driver</span>
                                            <span>
                                              {bookingsData?.booking_info
                                                ?.parking_paid_by_driver !==
                                                undefined &&
                                              parseInt(
                                                bookingsData?.booking_info
                                                  ?.parking_paid_by_driver
                                              ) > 0
                                                ? "$" +
                                                  bookingsData?.booking_info
                                                    ?.parking_paid_by_driver
                                                : "Free"}
                                            </span>
                                          </p>
                                        </div>
                                        <div className="listRow">
                                          <p>
                                            <span>
                                              <b>GST</b>
                                            </span>
                                            <span>
                                              <a>
                                                {"$" +
                                                  bookingsData?.booking_info
                                                    ?.gst_cost}
                                              </a>
                                            </span>
                                          </p>
                                        </div>
                                        <div className="listRow">
                                          <p>
                                            <span>
                                              <b>Credits used</b>
                                            </span>
                                            <span>
                                              <a>
                                                {"$" +
                                                  bookingsData?.booking_info
                                                    ?.cb_used}
                                              </a>
                                            </span>
                                          </p>
                                        </div>
                                        <div className="listRow gTotal pad-0 mar-0">
                                          <p>
                                            <span>Total bill paid</span>
                                            <span>
                                              {"$" +
                                                bookingsData?.booking_info
                                                  ?.total}
                                            </span>
                                          </p>
                                        </div>
                                        <div class="insentive mt-16">
                                          <p>
                                            Total upsell incentive{" "}
                                            <span>
                                              {bookingsData?.booking_info
                                                ?.driver_upsell
                                                ? "$" +
                                                  bookingsData?.booking_info
                                                    ?.driver_upsell
                                                : "$0"}
                                            </span>
                                          </p>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </td>
                            </tr>
                          </>
                        ) : (
                          <></>
                        )}
                      </React.Fragment>
                    );
                  }
                })}
              </>
            ) : (
              <></>
            )}
          </tbody>
        </table>
      </div>
    ) : (
      <NoPriviliges message="no priviliges" />
    )
  ) : (
    <DataNotFound />
  );
};

export default AttendantPastBooking;
