import React, { useState, useEffect } from "react";
import { useLocation, useParams, Link } from "react-router-dom";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
// import UpComingBookings from "./UpComingBookings";
// import PastBookings from "./PastBookings";
// import VehicleDetails from "./VehicleDetails";
// import PersonalDetails from "./PersonalDetails";
import AttendantsBookings from "./AttendantsBookings";
import moment from "moment";
import Image from "../UI/Image";
import { FormatDate } from "../../utils/FormatDate";
import { unavailable } from "../../configuration/GlobalConfig";
import Spinner from "../UI/Spinner";
import DataNotFound from "../UI/DataNotFound";
//import Bookings from "./Bookings";

const AttendantProfile = () => {
  const params = useParams();
  const { state } = useLocation();
  const [userDetails, setUserDetails] = useState("");
  const axiosPrivate = useAxiosIntercept();
  const [error, setError] = useState("");
  const [jobDone, setJobDone] = useState("");
  const [showSubComponent, setshowSubComponent] = useState({
    upComingBookings: true,
  });

  const handler = (e) => {
    setshowSubComponent({ [e.target.id]: true });
  };
  useEffect(() => {
    if(state!==null)
    {
      setUserDetails(state);
    }
    let isMounted = true;
    const controller = new AbortController();
    const getUserDetails = async () => {
      const URL =
        process.env.REACT_APP_GET_SINGLE_USER + "&user_type=D";
      try {
        if(state==null)
        {
          const response = await axiosPrivate.get(
            URL + `&user_id=${params.user_id}`,
            {
              signal: controller.signal,
            }
          );
  
          if (response.data.status === 200) {
            isMounted &&
              setUserDetails(response?.data?.response?.data?.user_info);
          } else {
            setUserDetails({});
          }
        }
        

        // console.log(`response here:`,response);

        // isMounted && setUserDetails(response?.data?.response?.data?.user_info);
      } catch (err) {
        //console.error(err);
      }
    };
    if (isMounted) {
      getUserDetails();
    }

    return () => {
      isMounted = false;
      controller.abort();
    };
  }, []);

  const {
    user_image,
    firstname,
    lastname,
    created_at,
    commission_info,
    email,
    gender,
    phone,
    puppy_info,
    age,
  } = userDetails;

  const fullName = () => {
    const name = "";
    name = firstname ? firstname : name;
    // name = lastname ? name + " " + lastname : name;

    return name;
  };

  return (
    <>
      {userDetails =="" ? (
        <div><Spinner/></div>
      ) : Object.keys(userDetails).length !== 0 ? (
        <div
          className={
            showSubComponent.upComingBookings
              ? "customersDetails"
              : "boxType1 bgBox2 customersDetails"
          }
        >
          {
            <>
              <div class="userInfo big mr-0">
                <Image
                  userImage={user_image ? user_image : ""}
                  name={firstname}
                  className={"imgBlock"}
                />
                {/* <div class="imgBlock">
                  <div>
                    <img
                      src="images/AdobeStock_200902415_Preview.jpeg"
                      alt=""
                    />
                  </div>
                </div> */}
                <div class="name">
                  {firstname ? (
                    <span>{firstname + " " + lastname}</span>
                  ) : (
                    <span>Guest</span>
                  )}
                  <span>
                    {puppy_info
                      ? puppy_info.puppy_status_description
                        ? puppy_info.puppy_status_description
                        : unavailable
                      : unavailable}
                  </span>
                </div>
                {/* <a href="javascript:void(0);" class="btn seco">
                  Edit details
                </a> */}
              </div>
              <div class="mt-24 attendantInfo">
                <div class="dataTable pl-0 pr-0">
                  <div>
                    <p>
                      <span>Added on</span>
                      <span>{FormatDate(created_at)}</span>
                    </p>
                    <p>
                      <span>Mobile number</span>
                      <span>{phone ? phone : unavailable}</span>
                    </p>
                    <p>
                      <span>Email</span>
                      <span>{email ? email : unavailable}</span>
                    </p>
                    <p>
                      <span>Age</span>
                      <span>{`${age ? age + " " + "yrs" : unavailable}`}</span>
                    </p>
                    <p>
                      <span>Gender</span>
                      <span>{gender ? gender : unavailable}</span>
                    </p>
                    <p>
                      <span>Assigned puppy</span>
                      <span>
                        {puppy_info?.registration_no
                          ? puppy_info?.registration_no
                          : unavailable}
                      </span>
                    </p>
                  </div>
                </div>
              </div>
              <div class="xRow pt-24 pb-12 dashboard">
                <div class="boxT1">
                  <p>Total jobs done</p>
                  <span>{jobDone}</span>
                </div>
                <div class="boxT1">
                  <p>Total incentive</p>
                  <span>
                    $
                    {commission_info?.upsell_commission
                      ? commission_info?.upsell_commission
                      : "0"}
                  </span>
                </div>
              </div>

              <div className="navTabs mt-24 mb-24">
                <ul className="level1">
                  <li
                    className={
                      showSubComponent.upComingBookings ? "selected" : ""
                    }
                  >
                    <a
                      style={{ cursor: "pointer" }}
                      id="upComingBookings"
                      onClick={handler}
                    >
                      Upcoming bookings
                    </a>
                  </li>
                  <li
                    className={showSubComponent.pastBookings ? "selected" : ""}
                  >
                    <a
                      style={{ cursor: "pointer" }}
                      id="pastBookings"
                      onClick={handler}
                    >
                      Past bookings
                    </a>
                  </li>
                  {/* <li
                    className={
                      showSubComponent.vehicleDetails ? "selected" : ""
                    }
                  >
                    <Link id="vehicleDetails" onClick={handler}>
                      Vehicle details
                    </Link>
                  </li> */}
                  {/* <li
                    className={
                      showSubComponent.personalDetails ? "selected" : ""
                    }
                  >
                    <Link id="personalDetails" onClick={handler}>
                      Personal details
                    </Link>
                  </li> */}
                </ul>
              </div>
              {/* {console.log(showSubComponent)} */}
              {showSubComponent.upComingBookings && (
                <AttendantsBookings
                  firstname={firstname}
                  lastname={lastname}
                  userImage={user_image ? user_image : ""}
                  Bookingtype="upComingBookings"
                  jobDone={jobDone}
                  setJobDone={setJobDone}
                />
              )}
              {showSubComponent.pastBookings && (
                <AttendantsBookings
                  Bookingtype="pastBookings"
                  jobDone={jobDone}
                  setJobDone={setJobDone}
                />
              )}
              {/* {showSubComponent.vehicleDetails && <VehicleDetails />}
              {showSubComponent.personalDetails && <PersonalDetails />} */}
            </>
          }
        </div>
      ) : (
        <>
          <DataNotFound/>
        </>
      )}
    </>
  );
};

export default AttendantProfile;
