import React, { useState, useEffect } from "react";
import { useLocation, useParams, Link } from "react-router-dom";

import useAxiosIntercept from "../../hooks/useAxiosIntercept";
// import UpComingBookings from "./UpComingBookings";
// import PastBookings from "./PastBookings";
import { DatePicker } from "antd";
import AttendantPastBooking from "./AttendantPastBooking";
import AttendantsUpComingBooking from "./AttendantUpComingBooking";
import moment from "moment";
import Error from "../UI/Error";
import useHttp from "../../hooks/useHttp";
import usePaginate from "../../hooks/usePaginate";
import NoData from "../UI/NoData";
import Loading from "../UI/Loading";
import useAuth from "../../hooks/useAuth";
const AttendantsBookings = ({
  Bookingtype,
  firstname,
  lastname,
  userImage,
  setJobDone,
  jobDone,
}) => {
  const { RangePicker } = DatePicker;
  const params = useParams();
  const axiosPrivate = useAxiosIntercept();
  const [fromDate, setFromDate] = useState("");
  const [toDate, setToDate] = useState("");
  const [dates, setDates] = useState([]);
  const [total_records, setTotalRecords] = useState(0);
  const [reportDate, setReportDate] = useState([]);
  const [isActiveBooking, setisActiveBooking] = useState(1);
  const [error, setErrors] = useState("");
  const [openDurationDropdown, setOpenDurationDropDown] = useState(false);
  const [fromdate, setfromdate] = useState("");
  const [todate, settodate] = useState("");
  const [durationSelected, setDurationSelected] = useState(-1);
  const [pageNumber, setPageNumber] = useState(1);
  const [hasMore, setHasMore] = useState(false);
  const [BookingsDetails, setBookingsDetails] = useState("");
  const [isCancelled, setisCancelled] = useState(false);
  const perPageLimit = 10;
  const { auth } = useAuth()

  var pastBookingrequest = {};
  var upComingBookingrequest = {};

  const url =
    process.env.REACT_APP_GET_DRIVER_JOB_DONE +
    `&show_puppy_info=1&show_package_info=1&show_job_done=1&page=${pageNumber}&limit=${perPageLimit}`;

  if (dates[0] != "" && dates[1] != "" && Bookingtype === "pastBookings") {
    pastBookingrequest = {
      driver_id: params.user_id,
      is_active: 0,
      from_date: dates[0],
      to_date: dates[1],
    };
  } else {
    pastBookingrequest = {
      driver_id: params.user_id,
      is_active: 0,
    };
  }
  if (
    dates.length != "" &&
    dates[0] != "" &&
    dates[1] != "" &&
    Bookingtype !== "pastBookings"
  ) {
    upComingBookingrequest = {
      driver_id: params.user_id,
      is_active: 1,
      from_date: dates[0],
      to_date: dates[1],
    };
  } else {
    upComingBookingrequest = {
      driver_id: params.user_id,
      is_active: 1,
    };
  }
  const request_body =
    Bookingtype === "pastBookings"
      ? pastBookingrequest
      : upComingBookingrequest;

  const { isLoading, sendRequest: getbookings } = useHttp();

  const { lastElementRef } = usePaginate(isLoading, hasMore, setPageNumber);

  const request_method = "post";

  useEffect(() => {
    const setBookings = (booking) => {
      const { data } = booking?.data?.response;


      if (data?.job_details?.booking_records) {
        setBookingsDetails((prev) => {
          return [...new Set([...prev, ...data?.job_details?.booking_records])];
        });
        setTotalRecords(data?.job_details?.total);
        setJobDone(data?.job_done ? data?.job_done : "0");
      } else {
        setBookingsDetails({});
      }

      if (
        data?.job_details.total == data?.job_details?.booking_records?.length
      ) {
        setHasMore(false);
      } else {
        setHasMore(data?.job_details?.booking_records?.length > 0);
      }
    };

    if (
      pageNumber == 1 ||
      Math.ceil(total_records / perPageLimit) >= pageNumber
    ) {
      getbookings(
        {
          url,
          request_method,
          request_body,
        },
        setBookings
      );
    }
  }, [url, getbookings, pageNumber, isCancelled]);

  const downloadReport = async (fromDate, toDate, firstDayOfMonth, today) => {
    let url = process.env.REACT_APP_DOWNLOAD_REPORT;

    let request = {};
    if (fromDate && toDate) {
      request = {
        report_type: "attendants",
        driver_id: params.user_id,
        show_puppy_info: "1",
        show_package_info: "1",
        show_job_done: Bookingtype == "pastBookings" ? "1" : "0",
        is_active: Bookingtype == "pastBookings" ? "0" : "1",
        from_date: moment(fromDate).format("YYYY-MM-DD"),
        to_date: toDate,
        no_of_entries: 10,
      };
    } else {
      request = {
        report_type: "attendants",
        driver_id: params.user_id,
        show_puppy_info: "1",
        show_package_info: "1",
        show_job_done: Bookingtype == "pastBookings" ? "1" : "0",
        is_active: Bookingtype == "pastBookings" ? "0" : "1",
        to_date: moment().clone().endOf("month").format("YYYY-MM-DD"),
        from_date: moment(firstDayOfMonth).format("YYYY-MM-DD"),
        no_of_entries: 10,
      };
    }

    const response = await axiosPrivate.post(url, request);

    if (response?.data?.status == "200") {
      window.open(response?.data?.response?.data?.url, "_self", "noreferrer");
    } else {
      setErrors(response?.data?.response?.errors[0]?.message);
    }
  };
  const getReportData = (data) => {
    let fromDate, toDate;
    const today = new Date();
    const firstDayOfMonth = new Date(today.getFullYear(), today.getMonth(), 1);

    const lastDayOfPreviousMonth = new Date(firstDayOfMonth - 1);

    const year = lastDayOfPreviousMonth.getFullYear();
    const month = String(lastDayOfPreviousMonth.getMonth() + 1).padStart(
      2,
      "0"
    );
    const day = String(lastDayOfPreviousMonth.getDate()).padStart(2, "0");
    const formattedDate = `${year}-${month}-${day}`;
    toDate = formattedDate;
    settodate(toDate);

    // const firstDayOfPreviousMonth = new Date(firstDayOfMonth - 1);
    const firstDayOfPreviousMonth = new Date(
      today.getFullYear(),
      today.getMonth() - 1,
      1
    );

    const firstDayOfThirdMonthBefore = new Date(firstDayOfPreviousMonth);

    if (data == 0) {
      fromDate = 0;
      setfromdate(fromDate);
    } else if (data == 3) {
      firstDayOfThirdMonthBefore.setMonth(
        firstDayOfThirdMonthBefore.getMonth() - 2
      );

      fromDate = firstDayOfThirdMonthBefore;
      //firstDayOfThirdMonthBefore.setDate(1);

      // fromDate = firstDayOfThirdMonthBefore.toISOString().slice(0, 10);

      setfromdate(fromDate);
    } else if (data == 6) {
      firstDayOfThirdMonthBefore.setMonth(
        firstDayOfThirdMonthBefore.getMonth() - 5
      );
      fromDate = firstDayOfThirdMonthBefore;
      // firstDayOfThirdMonthBefore.setDate(1);
      // fromDate = firstDayOfThirdMonthBefore.toISOString().slice(0, 10);
      setfromdate(fromDate);
    } else if (data == 12) {
      firstDayOfThirdMonthBefore.setMonth(
        firstDayOfThirdMonthBefore.getMonth() - 11
      );
      fromDate = firstDayOfThirdMonthBefore;
      // firstDayOfThirdMonthBefore.setDate(1);
      // fromDate = firstDayOfThirdMonthBefore.toISOString().slice(0, 10);
      setfromdate(fromDate);
    }
    // getTransactions(fromDate, toDate).then((data) => {
    //   if (data?.transactions != null) setTransactionData(data.transactions);
    // });
    downloadReport(fromDate, toDate, firstDayOfMonth, today);
  };

  return (
    <>
      {auth.priviliges.includes("read_bookings") || auth.priviliges.includes("read_bookings") &&
        <div class="searchPanel mb-24">
          <div class="multiOption yRow">
            <h5 class="mb-8">Filter by</h5>
            <div class="selectBox">
              <p class="selected">
                {/* Select date <i class="material-symbols-rounded grey">expand_more</i> */}
                Select date{" "}
                {/* <input type="date" required onChange={onChangeFromDate} /> */}
                <RangePicker
                  onChange={(dateValues, dateData) => setDates(dateData)}
                />
              </p>

              {/* <div class="selectDrop">
            <ul class="dropMenu">
              <li class="selected">
                <a href="javascript:void(0);">
                  Select date
                  <i class="material-symbols-rounded">done</i>
                </a>
              </li>
              <li>
                <a href="javascript:void(0);">Select date 1</a>
              </li>
              <li>
                <a href="javascript:void(0);">Select date 2</a>
              </li>
              <li>
                <a href="javascript:void(0);">Select date 3</a>
              </li>
            </ul>
          </div> */}
            </div>
          </div>
          {/* <div class="multiOption">
          <h5 class="mb-8">Download report</h5>
          <div class="selectBox">
            <p class="selected">
              Select duration{" "}
          <i class="material-symbols-rounded grey">expand_more</i>
          Select date <input type="date" onChange={onChangeToDate} />
          </p>
          <div class="selectDrop">
            <ul class="dropMenu">
              <li class="selected">
                <a href="javascript:void(0);">
                  Select duration
                  <i class="material-symbols-rounded">done</i>
                </a>
              </li>
              <li>
                <a href="javascript:void(0);">Select duration 1</a>
              </li>
              <li>
                <a href="javascript:void(0);">Select duration 2</a>
              </li>
              <li>
                <a href="javascript:void(0);">Select duration 3</a>
              </li>
            </ul>
          </div>
          </div>
        </div> */}
          {Bookingtype == "pastBookings" && (
            <div class="multiOption yRow">
              <h5 class="mb-8">Download report</h5>
              {/* <div class="selectBox">
            <p class="selected">
              Select date <i class="material-symbols-rounded grey">expand_more</i>
              Select date{" "}
              <input type="date" required onChange={onChangeFromDate} />
              <RangePicker
                onChange={(dateValues, dateData) => { setReportDate(dateData); setErrors("") }}
              />
            </p>

            <div class="selectDrop">
            <ul class="dropMenu">
              <li class="selected">
                <a href="javascript:void(0);">
                  Select date
                  <i class="material-symbols-rounded">done</i>
                </a>
              </li>
              <li>
                <a href="javascript:void(0);">Select date 1</a>
              </li>
              <li>
                <a href="javascript:void(0);">Select date 2</a>
              </li>
              <li>
                <a href="javascript:void(0);">Select date 3</a>
              </li>
            </ul>
          </div>

          </div> */}
              <div
                className={openDurationDropdown ? "selectBox open" : "selectBox"}
                onClick={() => setOpenDurationDropDown((pre) => !pre)}
              >
                {durationSelected == "-1" ? (
                  <p>
                    Select duration {""}
                    <i className="material-symbols-rounded grey">expand_more</i>
                  </p>
                ) : durationSelected == "0" ? (
                  <>
                    <p>
                      This month {""}
                      <i className="material-symbols-rounded grey">expand_more</i>
                    </p>
                  </>
                ) : (
                  <p>
                    Last {durationSelected} month {""}
                    <i className="material-symbols-rounded grey">expand_more</i>
                  </p>
                )}
                <div class="selectDrop">
                  <ul class="dropMenu">
                    <li
                      className={durationSelected == 0 ? "selected" : ""}
                      onClick={() => {
                        setDurationSelected(0);
                        getReportData(0);
                        setErrors("");
                      }}
                    >
                      <a>This month</a>
                    </li>
                    <li
                      className={durationSelected == 3 ? "selected" : ""}
                      onClick={() => {
                        setDurationSelected(3);
                        getReportData(3);
                        setErrors("");
                      }}
                    >
                      <a>Last 3 months</a>
                    </li>
                    <li
                      className={durationSelected == 6 ? "selected" : ""}
                      onClick={() => {
                        setDurationSelected(6);
                        getReportData(6);
                        setErrors("");
                      }}
                    >
                      <a>Last 6 months</a>
                    </li>
                    <li
                      className={durationSelected == 12 ? "selected" : ""}
                      onClick={() => {
                        setDurationSelected(12);
                        getReportData(12);
                        setErrors("");
                      }}
                    >
                      <a>Last 12 months</a>
                    </li>
                  </ul>
                </div>
              </div>
              <Error error={error} />
            </div>
          )}
        </div>}

      {Bookingtype === "pastBookings" ? (
        <AttendantPastBooking
          pastBookingData={BookingsDetails}
          lastElementRef={lastElementRef}
        />
      ) : (
        <AttendantsUpComingBooking
          upComingBookingData={BookingsDetails}
          setupcomingBookings={setBookingsDetails}
          userImage={userImage}
          total_records={total_records}
          lastElementRef={lastElementRef}
          isCancelled={isCancelled}
          setisCancelled={setisCancelled}
        />
      )}
      <div>{isLoading && pageNumber != 1 && <Loading />}</div>
      {pageNumber != "1" && pageNumber > Math.ceil(total_records / perPageLimit) && (<NoData />)}
    </>
  );
};

export default AttendantsBookings;
