import { useState, useEffect, useRef } from "react";
import { unavailable } from "../../configuration/GlobalConfig";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
const AttendantsDetails = (success, setSuccess) => {
  const axiosPrivate = useAxiosIntercept();
  const [attendantsDetails, setAttendantsDetails] = useState({});
  const search_by = "firstname";
  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    const getDrivers = async () => {
      let attendetDetailsUrl = process.env.REACT_APP_GET_ATTENDANTS_DETAILS;
      try {
        const attendentDetailsResponse = await axiosPrivate.get(
          attendetDetailsUrl,
          {
            signal: controller.signal,
          }
        );

        setAttendantsDetails(attendentDetailsResponse?.data?.response?.data);
      } catch (err) {
        console.log(err);
      }
    };
    getDrivers();
    // }

    return () => {
      isMounted = false;
      controller.abort();
    };
  }, [success]);
  const {
    total_count,
    free_count,
    inactive_count,
    assigned_count,
    top_commission_driver,
  } = attendantsDetails;
  return (
    <>
      <div className="xRow fullWidth lookUpDataDashboard mb-24">
        <div className="boxT1 totalAttendants">
          <i className="material-symbols-rounded grey fill">assignment_ind</i>
          <p>Total attendants</p>
          <span>{total_count}</span>
          <div className="numberBrif">
            <p>
              <span>Assigned</span>
              <span>{assigned_count}</span>
            </p>
            <p>
              <span>Free</span>
              <span>{free_count}</span>
            </p>
            <p>
              <span>Inactive</span>
              <span>{inactive_count === null ? "0" : inactive_count}</span>
            </p>
          </div>
        </div>
        <div className="boxT1 earnings">
          <i className="material-symbols-rounded grey fill">monetization_on</i>
          <p>Top incentive earner</p>
          {attendantsDetails?.top_commission_driver ? (
            <>
              <em>{attendantsDetails?.top_commission_driver?.driver_name}</em>
              <span>
                $
                {
                  attendantsDetails?.top_commission_driver
                    ?.driver_commission_amount
                }
              </span>
            </>
          ) : (
            unavailable
          )}
        </div>
      </div>
    </>
  );
};

export default AttendantsDetails;
