import { useState, useEffect, useRef } from "react";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import AttendantsListing from "./AttendentsListing";
import usePaginate from "../../hooks/usePaginate";
import useHttp from "../../hooks/useHttp";
import useOutsideClick from "../../hooks/useOutsideClick";
import responseHandler from "../../services/responseHandler";
import { messages } from "../../configuration/GlobalConfig";
import NoData from "../UI/NoData";
import Loading from "../UI/Loading";
const AttendantInfo = ({
  searchValue,
  setSearchValue,
  success,
  setSuccess,
  attendentInfo,
  setAttendentInfo,
  pageNumber,
  setPageNumber,
}) => {
  const axiosPrivate = useAxiosIntercept();

  const search_keyword = searchValue;
  const [currentPage, setCurrentPage] = useState(1);
  const [usersPerPage, setUsersPerPage] = useState(5);
  const [total_records, setTotalRecords] = useState(0);
  const [openAddPuppyForm, setOpenAddPuppyForm] = useState(false);
  const [attendantStatusValue, setAttendantStatusValue] = useState("");
  const [error, setError] = useState("");
  const [hasMore, setHasMore] = useState(false);
  const attendantRef = useRef();
  
  const search_by = "firstname";
  const [showFilter, setShowFilter] = useState({
    attendantStatus: false,
  });
  useOutsideClick(attendantRef, () => {
    setShowFilter({
      attendantStatus: !showFilter,
    });
  });
  const perPageLimit = 10;
  let isMounted = true;
  const controller = new AbortController();
  let response = {};
  // const getDrivers = async () => {
  let url = process.env.REACT_APP_DRIVERS_INFO_URL + "&show_all=true";

  if (searchValue != "") {
    url =
      url +
      `&search_by=${search_by}&search_keyword=${searchValue}&limit=${perPageLimit}&page=${pageNumber}`;
  }
  if (searchValue == "") {
    url = url + `&limit=${perPageLimit}&page=${pageNumber}`;
  }
  if (attendantStatusValue != "" && attendantStatusValue != "D") {
    url = url + `&driver_status=${attendantStatusValue}`;
  }
  if (attendantStatusValue != "" && attendantStatusValue == "D") {
    url = url + `&status=${attendantStatusValue}`;
  }

  const { isLoading, sendRequest: getusers } = useHttp();

  const { lastElementRef } = usePaginate(isLoading, hasMore, setPageNumber);
  useEffect(() => {
    const setSearchedusers = (searchedUsers) => {
      const { data } = searchedUsers?.data?.response;

      if (data?.user_info.length != 0) {
        setAttendentInfo((prev) => {
          return [...new Set([...prev, ...data?.user_info])];
        });

        setTotalRecords(data?.total_records);
      } else {
        setAttendentInfo({});
      }
      //setPuppySummary(data?.puppy_summary);

      if (data?.total_records == data?.user_info?.length) {
        setHasMore(false);
      } else {
        setHasMore(searchedUsers.data.response.data?.user_info.length > 0);
      }
    };
    if (
      pageNumber == 1 ||
      Math.ceil(parseInt(total_records) / perPageLimit) >= pageNumber
    ) {
      getusers(
        {
          url,
        },

        setSearchedusers
      );
    }
  }, [attendantStatusValue, url, pageNumber, getusers, success]);

  const handelFilter = (e) => {
    setShowFilter({
      [e.currentTarget.id]: !showFilter[e.currentTarget.id],
    });
  };
  const handelAttendantStatusValue = (e) => {
    setPageNumber(1);
    { e.currentTarget.id != attendantStatusValue && setAttendentInfo([]) };
    
    setAttendantStatusValue(e.currentTarget.id);
    setShowFilter((prev) => ({
      ...prev,
      attendantStatus: false,
    }));
  };

  const renderAttendantListing = () => {
    // if (error === "" && attendentInfo)
    // {
    return (
      <>
        <div className="searchPanel mb-24">
          <div className="multiOption columType">
            <h5 className="mb-8">Filter By</h5>
            <div
              ref={attendantRef}
              onClick={handelFilter}
              id="attendantStatus"
              className={
                showFilter.attendantStatus ? "selectBox open" : "selectBox"
              }
            >
              <p className="selected">
                {attendantStatusValue
                  ? attendantStatusValue === "A"
                    ? "Booking assigned"
                    : "" || attendantStatusValue === "F"
                      ? "Free"
                      : "" || attendantStatusValue === "D"
                        ? "Inactive"
                        : ""
                  : "Attendant status"}
                <i className="material-symbols-rounded grey">expand_more</i>
              </p>
              <div className="selectDrop customScroll hFix">
                <ul className="dropMenu">
                  <li className={attendantStatusValue === "" ? "selected" : ""}>
                    <a onClick={handelAttendantStatusValue} id="">
                      All
                      {attendantStatusValue === "" ? (
                        <i className="material-symbols-rounded">done</i>
                      ) : (
                        <></>
                      )}
                    </a>
                  </li>
                  <li
                    className={attendantStatusValue === "A" ? "selected" : ""}
                  >
                    <a onClick={handelAttendantStatusValue} id="A">
                      Booking assigned
                      {attendantStatusValue === "A" ? (
                        <i className="material-symbols-rounded">done</i>
                      ) : (
                        <></>
                      )}
                    </a>
                  </li>
                  <li
                    className={attendantStatusValue === "F" ? "selected" : ""}
                  >
                    <a onClick={handelAttendantStatusValue} id="F">
                      Free
                      {attendantStatusValue === "F" ? (
                        <i className="material-symbols-rounded">done</i>
                      ) : (
                        <></>
                      )}
                    </a>
                  </li>
                  <li
                    className={attendantStatusValue === "D" ? "selected" : ""}
                  >
                    <a id="D" onClick={(e) => handelAttendantStatusValue(e)}>
                      Inactive
                      {attendantStatusValue === "D" ? (
                        <i className="material-symbols-rounded">done</i>
                      ) : (
                        <></>
                      )}
                    </a>
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </div>

        <AttendantsListing
          attendentInfo={attendentInfo}
          setAttendentInfo={setAttendentInfo}
          setSearchValue={setSearchValue}
          searchValue={searchValue}
          success={success}
          setSuccess={setSuccess}
          lastElementRef={lastElementRef}
          attendantStatusValue={attendantStatusValue}
        />
        <div>{isLoading && pageNumber != 1 && <Loading />}</div>
        {pageNumber != "1" && pageNumber > Math.ceil(total_records / perPageLimit) && (<NoData />)}
      </>
    );
  };

  return renderAttendantListing();
};

export default AttendantInfo;
