import React from "react";
import { useNavigate, Link } from "react-router-dom";
import { useState, useEffect } from "react";
import Image from "../UI/Image";
import { FormatDate } from "../../utils/FormatDate";
import { unavailable } from "../../configuration/GlobalConfig";
import VehicleInActive from "../Puppy/VehicleInActive";
import Spinner from "../UI/Spinner";
import Logo from "../../assets/images/spinner.gif";
import AttendantInActive from "./AttendantInActive";
import DataNotFound from "../UI/DataNotFound";
import useAuth from "../../hooks/useAuth";

const AttendentsListing = ({
  openAddPuppyForm,
  setOpenAddPuppyForm,

  searchValue,
  success,
  status,
  setSuccess,
  lastElementRef,
  attendentInfo,
  setAttendentInfo,
  attendantStatusValue,
}) => {
  const [showPopUP, setShowPopUP] = useState(false);
  const { auth } = useAuth();
  const [showSubComponent, setshowSubComponent] = useState({
    inActive: false,
    firstname: "",
    lastname: "",
    age: "",
    gender: "",
    registration_no: "",
    user_id: "",
    status: "",
  });

  const userId = showSubComponent.user_id;
  const subContent = (
    e,
    firstname,
    lastname,
    age,
    gender,
    registration_no,
    user_id,
    status,
    i
  ) => {
    setshowSubComponent({
      [e.target.id]: true,
      firstname: { firstname },
      lastname: { lastname },
      age: { age },
      gender: { gender },
      registration_no: { registration_no },
      user_id: { user_id },
      status: { status },
      index: { i },
    });

    setShowPopUP(true);
  };

  const onBackdropClick = (operation_status) => {
    if (operation_status == true) {
      deletePuppyFromListing(userId);
    }
    document.body.classList.remove("hidden");
    setShowPopUP(false);
    setOpenAddPuppyForm(false);

    //setShowDeletePopUP(false);
  };

  const deletePuppyFromListing = (userId) => {
    const currentAttendants = [...attendentInfo];

    let index = currentAttendants.findIndex(function (element) {
      if (element.user_id === userId.user_id) {
        return true;
      }
    });

    if (index !== -1) {
      currentAttendants.splice(index, 1);
      setAttendentInfo(currentAttendants);
    }
  };

  const navigate = useNavigate();

  return attendentInfo == "" ? (
    <Spinner />
  ) : Object.keys(attendentInfo).length !== 0 ? (
    <div className="dataTableDynamic">
      <table>
        <tbody>
          <tr>
              <th>Attendant name</th>
              <th>Type</th>
            <th>Added on</th>
            <th>Assigned puppy</th>
            <th>Total incentive</th>
            <th>Status</th>
            <th>&nbsp;</th>
          </tr>

          {attendentInfo.map((driver, i) => {
            const {
              user_id,
              firstname,
              lastname,
              gender,
              puppy_info,
              age,
              driver_status,
              driver_status_description,
              deactivate_reason_description,
              status,
              role
            } = driver;
            if (attendentInfo.length == i + 1) {
              return (
                <tr key={user_id} ref={lastElementRef}>
                  <td className="vName">
                    <span>{firstname + " " + lastname}</span>
                    <em>
                      {`${age ? age + " yrs," : ""} ${
                        gender
                          ? gender === "M"
                            ? "male"
                            : "female"
                          : unavailable
                      }`}
                    </em>
                  </td>
                  <td>{role&&role}</td>

                  <td>{FormatDate(driver?.created_at)}</td>
                  <td>
                    {driver?.puppy_info?.registration_no
                      ? driver?.puppy_info?.registration_no
                      : "Not Assigned"}
                  </td>

                  <td>${driver?.commission_info?.upsell_commission}</td>
                  {
                    
                     status !== "D" ? (
                    <td className={driver_status === "A" ? "status" : ""}>
                      {driver_status_description
                        ? driver_status_description
                        : unavailable}
                    </td>
                  ) : (
                    <td className="inactive">
                      Inactive
                      <br />
                      <em>
                        {deactivate_reason_description &&
                          deactivate_reason_description}
                      </em>
                    </td>
                  )}

                  
                   
                 
                  <td className="right">
                    <div className="actionNav">
                      <i className="material-symbols-rounded mt-m grey">
                        more_vert
                      </i>
                       <div className="dropMenuWrap">
                        <ul className="dropMenu">
                          
                          {auth.priviliges.includes("read_attendant") &&
                            <li>
                              <a
                                onClick={() => {
                                  navigate(
                                    `/attendants/attendantsProfile/${driver?.user_id}`,
                                    { state: driver }
                                  );
                                }}
                                // onClick={subContent}
                                to=""
                              >
                                View details
                              </a>
                            </li>}
                          {auth.priviliges.includes("write_attendant") && (
                            status === "D" ? (
                              <>
                                <li>
                                  <Link
                                    id="inActive"
                                    className="success open_model"
                                    data-target="assignInactive"
                                    onClick={(e) =>
                                      subContent(
                                        e,
                                        firstname,
                                        lastname,
                                        age,
                                        gender,
                                        puppy_info.registration_no,
                                        user_id,
                                        status,
                                        i
                                      )
                                    }
                                  >
                                    Mark as active
                                  </Link>
                                </li>
                              </>
                            ) : (
                              <>
                                <li>
                                  <Link
                                    id="inActive"
                                    className="error open_model"
                                    data-target="assignInactive"
                                    onClick={(e) =>
                                      subContent(
                                        e,
                                        firstname,
                                        lastname,
                                        age,
                                        gender,
                                        puppy_info.registration_no,
                                        user_id,
                                        status,
                                        i
                                      )
                                    }
                                  >
                                    Mark as inactive
                                  </Link>
                                </li>
                              </>
                            ))}
                        </ul>
                      </div>
                    </div>
                  </td>
                </tr>
              );
            } else {
              return (
                <tr key={user_id}>
                  <td className="vName">
                    <span>{firstname + " " + lastname}</span>
                    <em>
                      {`${age ? age + " yrs," : ""} ${
                        gender
                          ? gender === "M"
                            ? "male"
                            : "female"
                          : unavailable
                      }`}
                    </em>
                  </td>
<td>{role&&role}</td>
                  <td>{FormatDate(driver?.created_at)}</td>
                  <td>
                    {driver?.puppy_info?.registration_no
                      ? driver?.puppy_info?.registration_no
                      : "Not Assigned"}
                  </td>

                  <td>${driver?.commission_info?.upsell_commission}</td>
                                    {
                     status !== "D" ? (
                    <td className={driver_status === "A" ? "status" : ""}>
                      {driver_status_description
                        ? driver_status_description
                        : unavailable}
                    </td>
                  ) : (
                    <td className="inactive">
                      Inactive
                      <br />
                      <em>
                        {deactivate_reason_description &&
                          deactivate_reason_description}
                      </em>
                    </td>
                  )}

                  <td className="right">
                    <div className="actionNav">
                      <i className="material-symbols-rounded mt-m grey">
                        more_vert
                      </i>
                    
                      <div className="dropMenuWrap">
                        <ul className="dropMenu">
                          
                          {auth.priviliges.includes("read_attendant") &&
                            <li>
                              <a
                                onClick={() => {
                                  navigate(
                                    `/attendants/attendantsProfile/${driver?.user_id}`,
                                    { state: driver }
                                  );
                                }}
                                // onClick={subContent}
                                to=""
                              >
                                View details
                              </a>
                            </li>}
                          {auth.priviliges.includes("write_attendant") && (
                            status === "D" ? (
                              <>
                                <li>
                                  <Link
                                    id="inActive"
                                    className="success open_model"
                                    data-target="assignInactive"
                                    onClick={(e) =>
                                      subContent(
                                        e,
                                        firstname,
                                        lastname,
                                        age,
                                        gender,
                                        puppy_info.registration_no,
                                        user_id,
                                        status,
                                        i
                                      )
                                    }
                                  >
                                    Mark as active
                                  </Link>
                                </li>
                              </>
                            ) : (
                              <>
                                <li>
                                  <Link
                                    id="inActive"
                                    className="error open_model"
                                    data-target="assignInactive"
                                    onClick={(e) =>
                                      subContent(
                                        e,
                                        firstname,
                                        lastname,
                                        age,
                                        gender,
                                        puppy_info.registration_no,
                                        user_id,
                                        status,
                                        i
                                      )
                                    }
                                  >
                                    Mark as inactive
                                  </Link>
                                </li>
                              </>
                            ))}
                        </ul>
                      </div>
                    </div>
                  </td>
                </tr>
              );
            }
          })}

          {showSubComponent.inActive && showPopUP && (
            <AttendantInActive
              onBackdropClick={onBackdropClick}
              showPopUP={showPopUP}
              firstname={showSubComponent.firstname}
              lastname={showSubComponent.lastname}
              age={showSubComponent.age}
              gender={showSubComponent.gender}
              registration_no={showSubComponent.registration_no}
              user_id={showSubComponent.user_id}
              success={success}
              setSuccess={setSuccess}
              status={showSubComponent.status}
              attendentInfo={attendentInfo}
              setAttendentInfo={setAttendentInfo}
              index={showSubComponent.index}
              attendantStatusValue={attendantStatusValue}
            />
          )}
        </tbody>
      </table>
    </div>
  ) : (
    <DataNotFound/>
  );
};
export default AttendentsListing;
