import React from "react";
import { useState, useEffect } from "react";
import Error from "../../UI/Error";
//import VehicleBrandDetails from "./VehicleBrandDetails";
import { useFormInputValidation } from "react-form-input-validation";
import { Link } from "react-router-dom";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import Message from "../../../utils/Message";
import { CalculateAge } from "../../../utils/CalculateAge";

const CreateNewAttendant = ({
  formDataValue,
  setformDataValue,
  page,
  setPage,
  getDetails,
}) => {
  const axiosPrivate = useAxiosIntercept();
  const [phone, setPhone] = useState("");
  const [totalRecords, setTotalRecords] = useState("");
  const [successMsg, setSuccessMsg] = useState("");
  const [isSuccess, setIsSuccess] = useState(false);
  const [otpErrorMsg, setOtpErrorMsg] = useState("");
  const [otpSuccessMsg, setOtpSuccessMsg] = useState("");
  const [error, setError] = useState("");
  const [image, setImage] = useState({});
  const [thumbnail, setThumbnail] = useState("");
  const [verified, setVerified] = useState(false);
  const [attendantDetails, setAttendantDetails] = useState({});
  const [counter, setCounter] = useState(0);
  const [showMessage, setShowMessage] = useState(false);
  const [message, setMessage] = useState({});
  const [checkOtp, setcheckOtp] = useState(true);
  const [otp, setOtp] = useState("");
  const [RoleList, setRoleList] = useState([]);
  const [dobError, setDobError] = useState("");
  const controller = new AbortController();
  const [roleId,setRoleId]=useState("3")
  useEffect(() => {
   

    if (counter > 0) {
      setTimeout(() => {
        setCounter((prev) => prev - 1);
      }, 1000);
    } else {
      setcheckOtp(true);
    }
  
  }, [counter]);

  useEffect(() => {
     const getRoleList = async () => {
      const getRoleListUrl = process.env.REACT_APP_GET_USER_ROLES_LIST + "&user_type=D"
      const getRoleListResponse = await axiosPrivate.get(getRoleListUrl);
    
      if (getRoleListResponse.status == 200) {
        setRoleList(getRoleListResponse?.data?.response?.data)
      }
     }
    getRoleList();
  },[])

  
  
  const sendOtp = () => {
    if (fields.phone && checkOtp) {
      // Object.keys(errors).forEach((i) => (errors[i] = null));
      setcheckOtp(false);
      setError("");
      setOtpErrorMsg("");
      setOtpSuccessMsg("");
      setSuccessMsg("");

      let userListSearchUrl =
        process.env.REACT_APP_GET_USER_LIST_SEARCH_BY_PHONE_FOR_TYPE_D;
      try {
        const checkUser = async () => {
          const response = await axiosPrivate.get(
            userListSearchUrl + `&search_keyword=${fields.phone}`,
            {
              signal: controller.signal,
            }
          );
          if (response?.data.status === 200) {
            const records = response?.data?.response?.data?.total_records;

            const sendOtpRequest = {
              comm_value: `${fields.phone}`,
              object_type: "add_driver",
            };
            if (records == 0 && checkOtp) {
              //checkOtp
              //setcheckOtp(false);

              let sendOtpUrl = process.env.REACT_APP_SEND_OTP;
              const sendOtpResponse = await axiosPrivate.post(
                sendOtpUrl,
                sendOtpRequest
              );
              if (sendOtpResponse?.data?.status === 200) {
                setCounter(30);
                setSuccessMsg(sendOtpResponse?.data?.message);
              } else {
                setError(sendOtpResponse?.data?.message);
                setcheckOtp(true);
              }
            } else {
              setError("user already exists");
              setcheckOtp(true);
            }
          } else {
            setError("Please fill valid phone number");
            setcheckOtp(true);
          }
        };

        checkUser();
      } catch (err) {
        console.log(err);
        setcheckOtp(true);
      }
    } else if (!fields.phone) {
      setError("Please enter Phone number");
    }
    let userListSearchUrl =
      process.env.REACT_APP_GET_USER_LIST_SEARCH_BY_PHONE_FOR_TYPE_P;
  };
  const [fields, errors, form] = useFormInputValidation(
    {
      name: "",
     
      phone: "",
      email: "",
      dob: "",
      gender: "",
      address: "",
      otp: "",
    },
    {
      name: "required|string",
     
      email: "email",
      phone: "required|numeric|digits_between:8,10",
      dob: "required|date",
      gender: "required",
      otp: "required|numeric|digits:4",
      address: "string",
    }
  );
  let messages = form.getMessages("en");
  // console.log(messages);

  messages.phone = "Phone no must be either of 8 digits or 10 digits";

  form.setMessages("en", messages);

  const handelPage = async (e) => {
    Object.keys(errors).forEach((i) => (errors[i] = null));
    setError("");
    const isValid = await form.validate(e);

    if (isValid) {
      Object.keys(errors).forEach((i) => (errors[i] = null));
      const verifyOtpRequest = {
        comm_value: `${fields.phone}`,
        object_type: "add_driver",
        otp: `${fields.otp}`,
      };
      if (fields.otp) {
        setOtpErrorMsg("");
        let verifyOty = process.env.REACT_APP_VERIFY_OTP;
        const verifyOtpResponse = await axiosPrivate.post(
          verifyOty,
          verifyOtpRequest
        );

        if (verifyOtpResponse?.data?.status === 200) {
          setOtpSuccessMsg(verifyOtpResponse?.data?.message);

          if (fields.dob) {
            const age = CalculateAge(fields.dob);
            if (age >= 18) {
              const createAttendantRequest = {
                name: fields.name,
                role_id:roleId,
                phone: fields.phone,
                email: fields.email,
                user_type: "D",
                dob: fields.dob.replaceAll("-", "/"),
                gender: fields.gender,
                address: fields.address,
              };
              let createAttendant = process.env.REACT_APP_ADD_NEW_CUSTOMER;
              let createAttendantResponse = await axiosPrivate.post(
                createAttendant,
                createAttendantRequest
              );
              if (createAttendantResponse?.data?.status === 200) {
                setIsSuccess(true);
                setShowMessage(true);
                setOtpErrorMsg("");
                setError("");
                setMessage({
                  id: 1,
                  text: createAttendantResponse?.data?.message,
                });
              } else {
                setIsSuccess(false);
                setShowMessage(true);
                Object.keys(fields).forEach((i) => (fields[i] = null));
                setMessage({
                  id: 2,
                  text: createAttendantResponse?.data?.message,
                });
              }
              fields("");
            } else {
              setDobError(
                "Please enter valid date of birth (age must atleast 18)"
              );
            }
          }
        } else {
          setOtpErrorMsg(verifyOtpResponse?.data?.message);
        }
      } else {
        setOtpErrorMsg("Please click on send otp");
      }
    }
  };
  const handleAttendantType = (role) => {
    
    setRoleId(role.role_id);
    
  }
  const onBackdropClick = () => {
    setShowMessage(false);
  };

  return (
    <>
      {showMessage && (
        <Message
          message={message}
          onBackdropClick={onBackdropClick}
          errorLink="/CreateNewAttendant"
          successLink="/attendants"
          errorValue="Try again"
          successValue="Go Back To Attendants"
          isSuccess={isSuccess}
        />
      )}
      <form onSubmit={handelPage}>
        <div className="border radius formSection">
          <div className="subContent pad-24">
            <div className="pacakgeDetails mt-16 mb-24"></div>
            <div className="dForm w300">
              <div className="fieldGroup mt-0">
                <label>Attendant name</label>
                <span className={errors.name ? "pt-8 error" : "pt-8"}>
                  <input
                    type="text"
                    placeholder="Enter name"
                    name="name"
                    onChange={form.handleChangeEvent}
                    autoComplete="off"
                  // value={fields.name}
                  />
                </span>
                {errors.name && <Error error={errors.name} />}
              </div>
              <div class="fieldGroup">
                <label>Attendant type</label>
               
                <ul class="xType">
                  { RoleList.map((role) => {
                    return (
                       <li>
                       <input type="radio" id="yTypeRadio41" name="role_id"
                     
                      checked={role.role_id==roleId?"checked":""} />
                       <label onClick={()=>handleAttendantType(role)}  for="yTypeRadio41">{ role.role}</label>
                  </li>
                    )
                  })}
                  
                  
                </ul>
              </div>

              <div className="fieldGroup mobileVerfiy">
                <label>Mobile number</label>
                <span className={errors.phone ? "mb-12 error" : "mb-12"}>
                  <input
                    type="text"
                    placeholder="Enter mobile number"
                    name="phone"
                    onChange={form.handleChangeEvent}
                    value={fields.phone}
                    autoComplete="off"
                    maxLength="10"
                  />
                  <em>
                    <Link
                      onClick={sendOtp}
                      style={{ pointerEvents: fields.phone ? "" : "none" }}
                    >
                      {successMsg
                        ? counter === 0
                          ? "Resend OTP"
                          : `Resend OTP in ${counter}`
                        : "Send OTP"}
                    </Link>
                  </em>
                </span>
                {errors.phone && <Error error={errors.phone} />}

                {successMsg !== "" ? (
                  <span className="success" style={{ color: "green" }}>
                    <span className="material-symbols-rounded success mt-xs fill">
                      check_circle
                    </span>
                    {successMsg}
                  </span>
                ) : (
                  <>
                    {error !== "" ? (
                      <span className="error">
                        <span className="material-symbols-rounded error mt-xs fill">
                          info
                        </span>
                        {error}
                      </span>
                    ) : (
                      <></>
                    )}
                  </>
                )}

                {successMsg ? (
                  <>
                    <br />
                    <span className={errors.otp ? "mb-12 error" : "mb-12"}>
                      <input
                        type="text"
                        placeholder="Enter OTP"
                        name="otp"
                        onChange={form.handleChangeEvent}
                        value={fields.otp}
                        autoComplete="off"
                        maxLength="4"
                      />
                    </span>
                    {errors.otp && <Error error={errors.otp} />}
                  </>
                ) : (
                  <></>
                )}
                <div className="">
                  {otpErrorMsg !== "" ? (
                    <span className="error">
                      <span className="material-symbols-rounded error mt-xs fill">
                        info
                      </span>

                      {otpErrorMsg}
                    </span>
                  ) : (
                    <>
                      {otpSuccessMsg != "" ? (
                        <span className="success" style={{ color: "green" }}>
                          {" "}
                          <span className="material-symbols-rounded success mt-xs fill">
                            check_circle
                          </span>
                          {otpSuccessMsg}
                        </span>
                      ) : (
                        <></>
                      )}
                    </>
                  )}
                </div>
              </div>
              <div className="fieldGroup">
                <label>Email ID</label>
                <span className={errors.email ? "error" : ""}>
                  <input
                    type="text"
                    placeholder="Enter email ID"
                    name="email"
                    onChange={form.handleChangeEvent}
                    value={fields.email}
                    autoComplete="off"
                  />
                </span>
                {errors.email && <Error error={errors.email} />}
              </div>
              <div className="fieldGroup">
                <label>Date of birth</label>
                <span className={errors.dob ? "absIcon error" : "absIcon"}>
                  <input
                    type="date"
                    placeholder="DD/MM/YYYY"
                    name="dob"
                    onChange={form.handleChangeEvent}
                    value={fields.dob}
                    autoComplete="off"
                  />
                  {/* <i className="material-symbols-rounded grey arrowBottom mt-m">
                calendar_month
              </i> */}
                </span>

                {errors.dob && <Error error={errors.dob} />}
                {dobError && <Error error={dobError} />}
              </div>

              <div className="fieldGroup">
                <label>Gender</label>
                <ul className="xType">
                  <li>
                    <input
                      type="radio"
                      id="yTypeRadio4"
                      name="gender"
                      //checked="checked"
                      onChange={form.handleChangeEvent}
                      value="M"
                      autoComplete="off"
                    />
                    <label for="yTypeRadio4">Male</label>
                  </li>
                  <li>
                    <input
                      type="radio"
                      id="yTypeRadio5"
                      name="gender"
                      onChange={form.handleChangeEvent}
                      value="F"
                      autoComplete="off"
                    />
                    <label for="yTypeRadio5">Female</label>
                  </li>
                </ul>
                {errors.gender && <Error error={errors.gender} />}
              </div>
              <div className="fieldGroup">
                <label>Home address</label>
                <span className="">
                  <textarea
                    placeholder="Enter full address"
                    name="address"
                    value={fields.address}
                    onChange={form.handleChangeEvent}
                  ></textarea>
                </span>
              </div>
            </div>

            <div className="actionButtons mt-24">
              <span className="">
                <button type="submit" className="btn prim">
                  {page === 1 ? "Next" : "Add new attendant"}
                </button>
              </span>
            </div>
          </div>
        </div>
      </form>
    </>
  );
};

export default CreateNewAttendant;
