import { useEffect, useState, useRef } from "react";
import useAuth from "../../hooks/useAuth";
import useRefreshToken from "../../hooks/useRefreshToken";
import { Outlet, Navigate, useLocation } from "react-router-dom";

import Loader from "../UI/Loader";

const PersistLogin = () => {
  const [isLoading, setIsloading] = useState(true);
  const { auth } = useAuth();
  const refresh = useRefreshToken();
  const location = useLocation();
  const handleUseEffectExecution = useRef(false);

  useEffect(() => {
    const verifyRefreshToken = async () => {
      try {
        await refresh();
      } catch (err) {
        console.error(err);
      } finally {
        setIsloading(false);
      }
    };
    if (!handleUseEffectExecution.current) {
      !auth?.accessToken ? verifyRefreshToken() : setIsloading(false);
    }

    return () => {
      handleUseEffectExecution.current = true;
    };
  }, [isLoading]);

  return (
    <>
      {auth?.accessToken ? (
        <Outlet />
      ) : isLoading ? (
        <Loader />
      ) : (
        <Navigate to="/" state={{ from: location }} replace />
      )}
    </>
  );
};

export default PersistLogin;
