import { useState, useRef } from "react";
import UserAuth from "../../services/UserAuth";
import { useLocation } from "react-router-dom";
import useAuth from "../../hooks/useAuth";
import "./../../index.css";
import { Link } from "react-router-dom";

function Signin({ setPage }) {
  const { auth, setAuth } = useAuth();
  const [userPhone, setUserPhone] = useState("");
  const [error, setError] = useState("");
  let isvalidPhone = true;
  const [isRequested, setIsRequested] = useState(true);
  const sendOTP = async (e) => {
    e.preventDefault();
    const request = {
      phone: userPhone,
    };
    let pattern = /^[0-9]{8,10}$/;
    const value = userPhone;
    if (!pattern.test(value)) {
      setError("Invalid Phone Number");
      isvalidPhone = false;
    } else {
      setError("");
      isvalidPhone = true;
    }
    if (isvalidPhone === true && userPhone != "" && isRequested) {
      setIsRequested(false);
      const res = await UserAuth(request);
      if (res?.error) {
        // console.log(`Network Error Response is this: ${JSON.stringify(res)}`);
        setError("Something Went Wrong");
        setUserPhone("");
        setIsRequested(true);
      } else if (res?.response?.errors) {
        // console.log(`Error API Response is this: ${JSON.stringify(res)}`);
        // console.log(`${JSON.stringify(res?.response?.errors[0]?.message)}`)
        setError(res?.response?.errors[0]?.message);
        setUserPhone("");
        setIsRequested(true);
        Array.from(document.querySelectorAll("input")).forEach(
          (input) => (input.value = "")
        );
      } else {
        if (res?.response?.data?.otp_required) {
          setAuth((prev) => {
            return {
              ...prev,
              phone: userPhone,
              otpRequired: res?.response?.data?.otp_required,
              userId: res?.response?.data?.user_id,
            };
          });
          setUserPhone("");
          setPage(1);

        } else {
          // console.log(res?.error?.message);
          setError(res?.error?.message);
          setUserPhone("");
        }
      }
    }
  };

  return (
    <>
      <h5>Enter Phone Number</h5>

      <div className="form mt-24">
        <span className={error ? "error" : ""}>
          <input
            required
            onChange={(e) => {
              setUserPhone(e.target.value);
              setError("")
            }}
            type="text"
            minLength={10}
            maxLength={10}
            placeholder="Enter Phone Number"
            name=""
          />
        </span>
        {error && (
          <div class="alertTxt">
            <span class="error">
              <i class="material-symbols-rounded fill mt-s error mr-4">error</i>
              {error}
            </span>
          </div>
        )}
        <div className="actionButtons mt-16">
          <span className="">
            <Link to="" onClick={sendOTP} className="btn prim fullW">
              Send OTP
            </Link>
          </span>
        </div>
      </div>
    </>
  );
}

export default Signin;
