import { useNavigate } from "react-router-dom";

import Header from "../Layouts/Header/Header";
import MainContainer from "../UI/MainContainer";
import SubMainContainer from "../UI/SubMainContainer";
import SideBar from "../Layouts/SideBar/SideBar";

import Button from "../UI/Button";
import NotFound from "../../assets/images/404.png";

const Unauthorized = () => {
  const navigate = useNavigate();

  const goBack = () => navigate(-1);
  const style = {
    display: "flex",
    textAlign: "center",
    justifyContent: "center",
    flexDirection: "column",
  };
  return (
    <>
      <MainContainer>
        <Header name="aditi" />
        <SubMainContainer>
          <SideBar />
          <div className="rightCol">
            <div className="contentContainer">
              <section style={style}>
                <img src={NotFound} alt="This Page Is Under Maintenance" />
                <br />
                <div className="flexGrow">
                  <Button value="Go Back" click={goBack} />
                </div>
              </section>
            </div>
          </div>
        </SubMainContainer>
      </MainContainer>
    </>
  );
};

export default Unauthorized;
