import { useState, useEffect, useRef } from "react";
import UserOtpVerify from "../../services/UserOtpVerify";
import { useNavigate, useLocation } from "react-router-dom";
import useAuth from "../../hooks/useAuth";
import { Link } from "react-router-dom";
function UserVerifyOtp({ setPage }) {
  const { auth, setAuth } = useAuth();
  const [userOtp, setUserOtp] = useState("");
  const [error, setError] = useState("");
  const navigate = useNavigate();
  const location = useLocation();
  const from = location.state?.from?.pathname || "/";
  const userRef = useRef();
  let isvalidOTP = true;
  const [isRequested, setIsRequested] = useState(true);
  const onSubmit = async (e) => {
    const request = {
      phone: auth?.phone,
      otp: userOtp,
    };
    let pattern = /^\d{4}$/;
    const value = userOtp;
    if (!pattern.test(value)) {
      setError("Invalid OTP");
      isvalidOTP = false;
    } else {
      setError("");
      isvalidOTP = true;
    }
    if (isvalidOTP === true && userOtp != "" && isRequested) {
      setIsRequested(false);
      const res = await UserOtpVerify(request);
      if (res?.error) {

        setError("Something Went Wrong");
        setUserOtp("");
        setIsRequested(true);
      } else if (res?.response?.errors) {

        setError("Invalid OTP");
        setUserOtp("");
        setIsRequested(true);
      } else {
        if (res?.response?.data?.login) {

          setAuth((prev) => {
            return {
              ...prev,
              accessToken: res?.response?.data?.access_token,
              otpRequired: false,
              userId: res?.response?.data?.user_id,
              isLoggedIn: true,
              userName: res?.response?.data?.name,
              userEmail: res?.response?.data?.email,
              userImage: res?.response?.data?.user_image,
            };
          });
          setUserOtp("");
          navigate(from, { replace: true });
        } else {
          setError(res?.response?.error?.message);
          setUserOtp("");
        }
      }
    }
  };
  return (
    <>
      <h5>
        <span
          className="material-symbols-rounded mt-s grey mt-4 mr-16 fill"
          onClick={() => {
            setPage(0);
          }}
        >
          arrow_back_ios
        </span>
        Enter 4 digit OTP Sent to {auth?.phone}
      </h5>
      <div className="form mt-24">
        <span className={error ? "error" : ""}>
          <input
            required
            onChange={(e) => {
              setUserOtp(e.target.value);
              setError("");
            }}
            type="text"
            placeholder="Enter 4 digit OTP"
            maxLength={4}
            minLength={4}
          />
        </span>

        {error && (
          // <h3
          //   style={{ color: "red", textAlign: "center" }}
          //   className="login__error"
          // >
          //
          // </h3>

          <div class="alertTxt">
            <span class="error">
              <i class="material-symbols-rounded fill mt-s error mr-4">error</i>
              {error}
            </span>
          </div>
        )}
        <div className="actionButtons mt-16">
          <span className="">
            <Link to="" onClick={onSubmit} className="btn prim fullW">
              Login
            </Link>
          </span>
        </div>
      </div>
    </>
  );
}

export default UserVerifyOtp;
