import React from 'react';
import Overlay from '../../utils/Overlay';
import { useState } from 'react';
import Error from "../UI/Error";
import Success from "../UI/Success";
import moment from 'moment';
import useAxiosIntercept from '../../hooks/useAxiosIntercept';
import { copyToClipboard } from '../../utils/CopyToClipBoard';
import Spinner from '../UI/Spinner';

const AddJobNote = ({ setshowAddJobNote, attendantList, puppyList, slotInfo, slot_date, isSuccess, jobNoteOnSuccessCallback }) => { 
  const axiosPrivate=useAxiosIntercept();
  const slotdate=moment(slot_date).format("YYYY-MM-DD");
  var serviceStr="";
    const [labels, setLabels] = useState({
        attenadantLabel:"",
        puppyLabel:""

    });
  const [isLoading, setIsLoading] = useState(false);
    const [showList, setshowList] = useState({
        attendantList:false,
        puppyList:false
           
    });
    const [data,setData]=useState({
      attendant_id:"",
      puppy_id:"",
      driver_note:slotInfo?.job_note !==undefined ? slotInfo?.job_note : ""

  });
  const [driverNoteSuccess,setDriverNoteSuccess]=useState("");
  const [driverNoteError,setDriverNoteError]=useState("");
  const [successMessage,setSuccessMessage]=useState("");
  const [errorMessage,setErrorMessage]=useState("");
  const [err,setErr]=useState("")
    const attendantInfo=(firstname,lastname,userid)=>{
      setDriverNoteError("");
      setErrorMessage("");
      setErr("");
        setLabels({
           ...labels, attenadantLabel:firstname+" "+lastname
        })
        setData({
          ...data,attendant_id:userid
        })

    }
   
    const puppyInfo=(registration_no,vehicle_id)=>{
      setDriverNoteError("");
      setErrorMessage("");
      setErr("");
        setLabels({
        ...labels,  puppyLabel:registration_no
        })
        setData({
          ...data,puppy_id:vehicle_id
        })

    }
   
  const submit = async () => {
    setIsLoading(true);
      let is_success = false;
      let slotInfoEdited = {...slotInfo}  
      if(data.attendant_id==""&&data.puppy_id==""&& data.driver_note==""){
      
        setErr("Kindly select field to be edited")
        setIsLoading(false);

      }
      else{
        if(data.driver_note!=""){
          slotInfoEdited['job_note'] = data.driver_note;
          const req2={
            booking_id:slotInfo.booking_id,
            data_key:"job_note",
            data_value:data.driver_note

          }
          const url=process.env.REACT_APP_ADD_DRIVER_NOTE;
          
          const response = await axiosPrivate.post(url, req2);
          
          if (response?.data?.status == "200") {
            setIsLoading(false);
            setDriverNoteSuccess("Driver note added successfully");
            is_success = true;
          }
          else{
            setDriverNoteError(response?.data?.message)
            setIsLoading(false);
          }
        }
        const req1={
          booking_id:slotInfo.booking_id,
          slot_date:slotdate,
          start_time: slotInfo.slot,
          puppy_vehicle_id: slotInfo.puppy_vehicle_id,
          driver_user_id: slotInfo.attendant_user_id,
        }
        const update_fields = {}
        if(data.puppy_id!=""){
          update_fields.puppy_vehicle_id=data.puppy_id
          req1.update_fields=update_fields
        } else {
          update_fields.puppy_vehicle_id=slotInfo.puppy_vehicle_id
          req1.update_fields=update_fields
        }
        if(data.attendant_id!=""){
          update_fields.driver_user_id=data.attendant_id;
          req1.update_fields=update_fields
        } else {
          update_fields.driver_user_id=slotInfo.attendant_user_id
          req1.update_fields=update_fields
        }
        if(data.attendant_id!=""||data.puppy_id!=""){
            const url=process.env.REACT_APP_CHANGE_ATTENDANT_AND_PUPPY;
            const response=await axiosPrivate.post(url,req1);
            if(response?.data?.response?.errors?.length == "0"){
              slotInfoEdited['puppy']=labels.puppyLabel!=="" ? labels.puppyLabel : slotInfo.puppy;
              slotInfoEdited['puppy_vehicle_id']=data.puppy_id !=="" ? data.puppy_id: slotInfo.puppy_vehicle_id;
              slotInfoEdited['attendant_user_id']=data.attendant_id !=="" ? data.attendant_id: slotInfo.attendant_user_id;
              slotInfoEdited['attendant']=labels.attenadantLabel!== "" ? labels.attenadantLabel : slotInfo.attendant;
              
              setSuccessMessage("Mapping Updated successfully");
              is_success = true;

            }
            else {
              setIsLoading(false);
              setErrorMessage(response?.data?.response?.errors);
            }
        }
        if(is_success) {
            setTimeout(() => {
                  jobNoteOnSuccessCallback(slotInfoEdited,slotInfo);
              }, 3000);
        }
      }

    }
    return(<>
      <Overlay>
        {isLoading==true&&<Spinner/>}
    <div class="model_box_child" id="manageJobBookingSlot" style={{width:"500px"}}>
      <div class="ap_heading">
        <h4> Manage job <span class="material-symbols-rounded black close_model" onClick={()=>{setshowAddJobNote(false);document.body.classList.remove("hidden");}}> close </span>
        </h4>
      </div>
      <div class="contentSection">
        <section class="assignPromoP">
          <div class="bookedSlotPopup">
            <span class="name">{slotInfo.attendant?slotInfo.attendant:"N/A"}</span>
            <div> {slotInfo.customer?slotInfo.customer:"NA"}<i class="dot"></i> {slotInfo.customer_car_plate?slotInfo.customer_car_plate:"N/A"} <i class="dot"></i>
            {slotInfo.customer_phone&&(<>
              <div class="copyPhone">
                <i class="material-symbols-rounded brand sm">phone_in_talk</i>
                <div class="copyphoneTooltip"> {slotInfo.customer_phone}<i class="material-symbols-rounded brand sm" onClick={()=>{copyToClipboard(slotInfo.customer_phone)}}>content_copy</i>
                </div>
              </div>
            </>)}
              
            </div>
            
            {slotInfo.service.length > 0 &&
                                                 
                                                 <>
                                                 {slotInfo.service.map((serviceName) => {
                                                   
                                                   serviceStr = serviceStr + serviceName + "+";
                                                 })}
                                                 <span class="sm">{serviceStr}</span>
                                               </>
                                               }
                                              
            <span class="lclr sm"> {slotInfo.brand_name&&slotInfo.brand_name+" "}{slotInfo.variant_name&&slotInfo.variant_name+" "}{slotInfo.model_name&&slotInfo.model_name} {slotInfo.battery_capacity&&"("+slotInfo.battery_capacity+"kWh"+")"} </span>
            <span class="sm">{slotInfo.address&&slotInfo.address}</span>
          </div>
          <div class="dForm w300">
            <div class="xType alignBottom">
              <div class="fieldGroup">
                <label>Select attendant</label>
                <div class="multiOption" onClick={() => { setshowList({attendantList:!showList.attendantList}) }} >
                  <div class={showList.attendantList ? "selectBox fullWidth open" : "selectBox fullWidth"}>
                    <p class="selected" >{labels.attenadantLabel? labels.attenadantLabel :slotInfo?.attendant} <i class="material-symbols-rounded grey">expand_more</i>
                    </p>
                    <div class="selectDrop customScroll hFix" >
                      <ul class="dropMenu">
                        {attendantList&&attendantList?.length>"0"&&attendantList.map((attendant)=>{
                            
                            return(<>
                            <li >
                          <a onClick={()=>{attendantInfo(attendant.firstname,attendant.lastname,attendant.user_id)}}>{attendant.firstname+" "+attendant.lastname} 
                          </a>
                        </li>
                            </>)

                        })}
                      </ul>
                    </div>
                  </div>
                </div>
              </div>
              <div class="fieldGroup">
                <label>Select puppy</label>
                <div class="multiOption" onClick={() => { setshowList({puppyList:!showList.puppyList}) }} >
                <div class={showList.puppyList ? "selectBox fullWidth open" : "selectBox fullWidth"}>
                    <p class="selected">{labels.puppyLabel? labels.puppyLabel : slotInfo?.puppy}  <i class="material-symbols-rounded grey">expand_more</i>
                    </p>
                    <div class="selectDrop customScroll hFix">
                      <ul class="dropMenu">
                      {puppyList&&puppyList?.length>"0"&&puppyList.map((puppy)=>{
                        return(<>
                          <li onClick={()=>{puppyInfo(puppy.registration_no,puppy.vehicle_id)}}>
                          <a>{puppy.registration_no}</a>
                        </li>
                        </>)

                      })}
                      </ul>
                    </div>
                    
                  </div>
                </div>
              </div>
            </div>
            {successMessage&&<Success success={successMessage}/>}

            {errorMessage&&errorMessage?.length>"0"&&errorMessage.map((err)=>{
                return (<>
                  <Error error={err.error.message} />
                </>)

            })}
            <div class="xType alignBottom">
              <div class="fieldGroup">
                <label>Add note for driver</label>
                                    <textarea name="" placeholder="Add note" value={data.driver_note} onChange={(e) => { setData({ ...data, driver_note: e.target.value }); setErrorMessage(""); setDriverNoteError("");setErr("")}}></textarea>
              </div>
              <div class="fieldGroup">
                <label>&nbsp;</label>
              </div>
            </div>
          </div>
          {driverNoteError&&<Error error={driverNoteError}/>}
          {driverNoteSuccess&&<Success success={driverNoteSuccess}/>}
        </section>
        <div class="actionButtons mt-24">
          <span>
            <a class="btn prim" onClick={submit}> Update </a>
          </span>
        </div>
        {err&&<Error error={err}/>}
      </div>
    </div>




    </Overlay>

    </>)

}
export default AddJobNote;
