import React, { useEffect } from "react";
import { useState } from "react";
import Calendar from "react-calendar";
import DisplayCalendar from "./DisplayCalendar";
import UploadSlots from "./UploadSlots";
import moment from "moment";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import { FormatDate } from "../../utils/FormatDate";
import BookingSlots from "./BookingSlots";
import SlotDateSummary from "./SlotDateSummary";
import SlotWiseData from "./SlotWiseData";
export default function BookingCalendar({
  uploadSlotsPopup,
  setuploadSlotsPopUP,
  onBackdropClick,
}) {
  const axiosPrivate = useAxiosIntercept();
  const [date, setDate] = useState(new Date());
  const [slots, setSlots] = useState("");
  const [isSuccess, setisSuccess] = useState(false);
  const [slotDetails, setSlotDetails] = useState("");
  const [toggleValue, setToggleValue] = useState("puppy");

  const [slotSummary, setSlotSummary] = useState("");

  const onDateChange = (newDate) => {
    setDate(newDate);
  };
  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();

    const getBookingSlots = async () => {
      setSlotDetails("");
      let URL = process.env.REACT_APP_GET_PUPPY_SLOT_LIST;
      let slot_summary_url =
        process.env.REACT_APP_GET_SLOT_SUMMARY +
        `&slot_month=${moment(date).format("YYYY-MM-DD")}`;

      let slot_details_url =
        process.env.REACT_APP_GET_SHFT_WISE_SLOT_DATA+`&slot_date=${moment(date).format("YYYY-MM-DD")}`;
      try {
        URL = URL + `&slot_date=${moment(date).format("YYYY-MM-DD")}`;
        const data = await axiosPrivate.get(URL, {
          signal: controller.signal,
        });
        const slot_summary_response = await axiosPrivate.get(slot_summary_url, {
          signal: controller.signal,
        });

        const slot_details = await axiosPrivate.get(slot_details_url, {
          signal: controller.signal,
        });

        if (data?.data?.status === 200) {
          setSlots(data?.data?.response?.data?.calendar_data);
        } else {
          setSlots("");
        }
        if (slot_summary_response?.data?.status == "200") {
          setSlotSummary(
            slot_summary_response?.data?.response?.data?.slot_summary
          );
        }

        if (slot_details?.data?.status == "200") {
          setSlotDetails(slot_details?.data?.response?.data);
        }
      } catch (err) {
        console.log(err);
      }
    };

    isMounted && getBookingSlots();

    return () => {
      isMounted = false;
      controller.abort();
    };
  }, [date, isSuccess, toggleValue]);

  return (
    <>
      {uploadSlotsPopup && <UploadSlots onBackdropClick={onBackdropClick} />}
      <div class="subContent bookingSlots pt-24">
        <div class="box">
          <section class="calendar">
            <h2>Select date &amp; time</h2>
            <div>
              <div class="react-calendar__viewContainer">
                <DisplayCalendar
                  onDateChange={onDateChange}
                  date={date}
                  slotSummary={slotSummary}
                />
              </div>
            </div>
          </section>
          <BookingSlots
            slots={slots}
            date={date}
            setSlots={setSlots}
            setisSuccess={setisSuccess}
            isSuccess={isSuccess}
          />
        </div>
      </div>
      <SlotWiseData
        isSuccess={isSuccess}
        setisSuccess={setisSuccess}
        date={date}
        data={slotDetails}
        toggleValue={toggleValue}
        setToggleValue={setToggleValue}
        
      />
    </>
  );
}
