import React from "react";
import { useState } from "react";
import moment from "moment";
import ManageSlots from "./ManageSlots";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import loader from "../../assets/images/spinner.gif";

import Spinner from "../UI/Spinner";
import DataNotFound from "../UI/DataNotFound";
export default function BookingSlots({
  slots,
  date,
  setSlots,
  setisSuccess,
  isSuccess,
}) {
  const axiosPrivate = useAxiosIntercept();
  const [showManageSlotsWindow, setshowManageSlotWindow] = useState(false);
  const [selectedTimeSlot, setSelectedTimeSlot] = useState("");
  const [selectedTime, setSelectedTime] = useState("");
  const [slotData, setslotData] = useState("");
  const [puppyList, setpuppyList] = useState("");
  const [attendantList, setAttendantList] = useState("");
  const [slotIndex, setslotIndex] = useState("");
  const [slotstatus, setslotStatus] = useState("");
  const [slotDescription, setslotDescription] = useState("");
  const [slotEdited, setslotEdited] = useState(false);
  const managePuppyAttendentListing = async (slotTime) => {
    const puppySlotDateTime = slotTime && slotTime;
    const puppySlotDateTimeArray = puppySlotDateTime.split(" ");
    const puppy_list_response = await axiosPrivate.get(
      process.env.REACT_APP_GET_PUPPY_LIST +
      `&slot_data=1&slot_date=${puppySlotDateTimeArray[0]}&start_time=${puppySlotDateTimeArray[1]}&limit=1000`
    );
    if (puppy_list_response?.data?.status == "200") {
      setpuppyList(puppy_list_response?.data?.response?.data?.puppy_vehicles);
    }

    const attendants_list_response = await axiosPrivate.get(
      process.env.REACT_APP_GET_ATTENDANTS_LIST +
      `&slot_data=1&slot_date=${puppySlotDateTimeArray[0]}&start_time=${puppySlotDateTimeArray[1]}&limit=1000`
    );
    if (attendants_list_response?.data?.status == "200") {
      setAttendantList(
        attendants_list_response?.data?.response?.data?.user_info
      );
    }
  };
  const manageSlots = async (
    status,
    time,
    slotindex,
    slot_status_description,
    slotTime
  ) => {
    setslotIndex(slotindex);
    setslotStatus(status);
    setslotDescription(slot_status_description);

    setslotData("");
    setAttendantList("");
    setpuppyList("");

    if (slot_status_description != "Not added") {
      const puppy_slots_response = await axiosPrivate.get(
        process.env.REACT_APP_PUPPY_SLOT_MAPPING_LIST +
        `&slot_date=${moment(date).format("YYYY-MM-DD")}&start_time=${moment(
          time,
          "h:mm A"
        ).format("HH:mm:ss")}&slot_type=C`
      );
      if (puppy_slots_response?.data?.status == "200") {
        setslotData(puppy_slots_response?.data?.response?.data?.slot_data);
      }
    }

    if (moment(slotTime) >= moment(Date())) {
      managePuppyAttendentListing(slotTime);
    }

    setshowManageSlotWindow(true);
    setSelectedTimeSlot(time);
    setSelectedTime(slotTime);
    //}
    //else {

    // }
  };

  return (
    <>
      {showManageSlotsWindow && (
        <ManageSlots
          setshowManageSlotWindow={setshowManageSlotWindow}
          date={date}
          selectedTimeSlot={selectedTimeSlot}
          slotData={slotData}
          puppyList={puppyList}
          attendantList={attendantList}
          setslotData={setslotData}
          slotIndex={slotIndex}
          status={slotstatus}
          slotDescription={slotDescription}
          slots={slots}
          setSlots={setSlots}
          setisSuccess={setisSuccess}
          isSuccess={isSuccess}
          selectedTime={selectedTime}
          setpuppyList={setpuppyList}
          slotEdited={slotEdited}
          setslotEdited={setslotEdited}
          managePuppyAttendentListing={managePuppyAttendentListing}
        />
      )}
      {slots === "" ? (
        <Spinner />
      ) : Object.keys(slots).length !== 0 ? (
        <>
          <section class="times">
            <div class="exampTutorial">
              <ul>
                <li>
                  <i class="activeS"></i>
                  <span>Active slots</span>
                </li>
                <li>
                  <i class="emptyS"></i>
                  <span>Empty slots</span>
                </li>
                <li>
                  <i class="bookedS"></i>
                  <span>Booked slots</span>
                </li>
              </ul>
            </div>
            <h3 class="mb-24">{moment(date).format("dddd, DD MMMM")}</h3>
            <div class="timesSlotsList">
              <ul>
                {slots.map((slot, index) => {
                  return (
                    <>
                      <li
                        key={index}
                        class={
                          slot.slot_status == "A"
                            ? "activeS open_model"
                            : slot.slot_status == "B"
                              ? "bookedS"
                              : ""
                        }
                        data-target="manageSlotsP"
                        onClick={() => {
                          manageSlots(
                            slot.slot_status,
                            slot.slot_time,
                            index,
                            slot.slot_status_description,
                            slot.slot_date_time
                          );
                        }}
                      >
                        <span>{slot.slot_time}</span>
                        <em>
                          {slot.slot_status == "A"
                            ? slot.available_slots + " available"
                            : slot.slot_status_description}
                        </em>
                      </li>
                    </>
                  );
                })}
              </ul>
            </div>
          </section>
        </>
      ) : (
        <>
          <DataNotFound />
        </>
      )}
    </>
  );
}
