import React from 'react'
import Calendar from 'react-calendar'
import moment from 'moment'
export default function DisplayCalendar({ onDateChange, date, slotSummary }) {
    let bookedSlots = [];
    return (
        <>
            {slotSummary && slotSummary.map((slot) => {
                if (slot.slot_status == "B") {
                    bookedSlots.push(slot.date)
                }

            })}
            <Calendar onChange={onDateChange} value={date} tileClassName={({ date, view }) => {
                if (bookedSlots.find(x => x === moment(date).format("YYYY-MM-DD"))) {
                    return 'react-calendar__booked'
                }
            }} />




        </>
    )
}
