import Overlay from '../../utils/Overlay';
import useAxiosIntercept from '../../hooks/useAxiosIntercept';
import React, { useEffect, useState ,useRef} from 'react'
import { Time } from '../../utils/Time';
import moment from 'moment';
import Error from "../UI/Error"
import Success from "../UI/Success"
import Spinner from '../UI/Spinner';
const ManageJob = ({ setShowPopUp, selectedSlotData ,setselectedSlotData,isSuccess,setisSuccess,manageJobOnSuccessCallback,editSlot,editSlotSuccessCallback,deleteSlotSuccessCallback}) => {
    
  
  
    const [enableSubmit, setEnableSubmit] = useState(true);
    const [isLoading, setIsLoading] = useState(false);
    const taskListRef = useRef();
  const attendantListRef = useRef();
  const timeRef = useRef();
   
    const axiosPrivate = useAxiosIntercept();
    const [list, setList] = useState({
        taskList: [],
        attendantList: []
    });
    const [apiError, setApiError] = useState({});
    const [errors, setErrors] = useState({
        taskidError: "",
        attendantidError: "",


    })
     const [taskInfo, setTaskInfo] = useState({
        id: selectedSlotData.job_id?selectedSlotData.job_id:"",
        name: ""
     })
     const [attendantInfo, setAttendantInfo] = useState({
        id: selectedSlotData.attendant_id?selectedSlotData.attendant_id:"",
        name: ""
    })
    const [note,setNote]=useState(selectedSlotData.note?selectedSlotData.note:"");
    const [openDropDown, setOpenDropDown] = useState({
        tasks: false,
        attendants: false,
        fromTime: false,
        toTime: false
    })
    const [time, setTime] = useState({
        fromTime: "",
        fromTimeAmPm: "",
        toTime: "",
        toTimeAmPm: ""
    })
    const [editError,setEditError]=useState("")

const [apiSuccess,setApiSuccess]=useState("")
    const [addAttendant, setAddAttendant] = useState();
    useEffect(() => {
        if(selectedSlotData.attendant_id&&selectedSlotData.attendant_id!="0"){
            setAddAttendant(true);
        }
        const getList = async () => {
            setIsLoading(true);
            let slotTasListkUrl = process.env.REACT_APP_GET_SLOT_TASK;
            let attendantsListUrl = process.env.REACT_APP_DRIVERS_INFO_URL+"&limit=1000"

            try {
                
                const slotTaskListResponse = await axiosPrivate.get(slotTasListkUrl);
                const attendantListResponse = await axiosPrivate.get(attendantsListUrl);
               setIsLoading(false);
                setList({
                    ...list, taskList: slotTaskListResponse?.data?.response?.data,
                    attendantList: attendantListResponse?.data?.response?.data?.user_info
                })

            } catch (err) {
                console.log(err);

            }
        };
        getList();

    }, [])
   
    const closepopup = () => {
        setShowPopUp(false);
        document.body.classList.remove("hidden");
    }
   
    const selectTask = (task) => {
        setTaskInfo({ id: task.id, name: task.name })
        setErrors({...errors,taskidError:""})
        setEditError("")
    }
    const selectAttendant = (attendant) => {
        setAttendantInfo({ id: attendant?.user_id, name: attendant.firstname+" "+attendant.lastname })
        setErrors({...errors,attendantidError:""})
        setEditError("");
    }
    const showAttendant = () => {
        setEditError("");
        if(addAttendant === true) {
            setAttendantInfo({
                id: "",
                name: ""
            });
        }
        setAddAttendant(!addAttendant);
        setselectedSlotData({
            ...selectedSlotData,attendant_id:0,attendant:""
        })
        
    }
    const taskList = (e) => {
         if (e.currentTarget.id !== undefined) {
      setOpenDropDown({
            [e.currentTarget.id]: !openDropDown[e.currentTarget.id],
      });
            
    } else {
      setOpenDropDown({ tasks: false });
      setOpenDropDown({ attendants: false });
      setOpenDropDown({ toTime: false });
    }
        
        
    }
    
    const manageTime = (time) => {

        setTime({
            fromTime: selectedSlotData?.time,
            fromTimeAmPm: Time(selectedSlotData?.time).split(" ")[1].toLowerCase(),
            toTime: time, toTimeAmPm:Time(time).split(" ")[1].toLowerCase()
        })
    }

    const validations = () => {
        let isError = false;
     
        if (taskInfo.id == "") {
            isError = true;
            setErrors((prev) => {
                return {
                    ...prev, taskidError: "Kindly select task"
                }
            })
            setIsLoading(false);
           
        }
        else {
          
            setErrors((prev) => {
                return {
                    ...prev, taskidError: ""
                }
            })
            
        }
        if (addAttendant==true&& (attendantInfo.id == ""||attendantInfo.id==0)) {
            isError = true;
            
            setErrors((prev) => {
                return {
                    ...prev, attendantidError: "Kindly select attendant"
                }
            })
            setIsLoading(false);
        }
        else {
           
            
            setErrors((prev) => {
                return {
                    ...prev, attendantidError: ""
                }
            })
        }
        return isError;
    }
     useEffect(() => {
    const handleClickOutside = (event) => {
        if (
           taskListRef.current==undefined ||
        taskListRef.current &&
        !taskListRef.current.contains(event.target) &&
        (attendantListRef.current === undefined ||
          (attendantListRef.current &&
            !attendantListRef.current.contains(event.target) &&
            (timeRef.current == undefined ||
              (timeRef.current &&
                !timeRef.current.contains(event.target)))))
      ) {
        taskList(event);
      }
    };
    document.addEventListener("click", handleClickOutside, true);
    return () => {
      document.removeEventListener("click", handleClickOutside, true);
    };
  }, []);
   
    const start = new Date();
    start.setHours(moment(time.fromTime, "HH:mm:ss").get('hours'), moment(time.fromTime, "HH:mm:ss").get('minutes'), moment(time.fromTime, "HH:mm:ss").get('seconds')); //8 AM
    const end = new Date();
    end.setHours(moment(time.toTime, "HH:mm:ss").get('hours'), moment(time.toTime, "HH:mm:ss").get('minutes'), moment(time.toTime, "HH:mm:ss").get('seconds'))
    const arr = [];
    while (start <= end) {
        arr.push(start.toLocaleString('en-US', { hour: '2-digit', minute: '2-digit' }))

        start.setMinutes(start.getMinutes() + 30);
    }
    const editSelectedSlot = async () => {
      
        const isError = validations();
   
        setIsLoading(true);
        let slotInfoEdited = {} 
        const URL = process.env.REACT_APP_EDIT_SLOT;
        const body = {
          slot_data: [
            {
              slot_date: moment(selectedSlotData.date).format("YYYY-MM-DD"),
              start_time:selectedSlotData.time,
              slot_mapping_id: selectedSlotData.slotid,
             driver_user_id: attendantInfo.id?attendantInfo.id:selectedSlotData.attendant_id,
              slot_task_id:taskInfo.id?taskInfo.id:selectedSlotData.job_id,
              slot_type: "O",
              puppy_vehicle_id: selectedSlotData?.slotDetails?.puppy_vehicle_id,
              note:note

            },
          ]
        };
        
        if((attendantInfo.id!==""||taskInfo.id!==""||selectedSlotData.attendant_id=="0"||selectedSlotData.note!=note)&&isError==false){
          
             
            if(enableSubmit==true){
                
                const response = await axiosPrivate.post(URL, body);
               
                if (response?.data?.response?.errors.length == "0") {
                    setIsLoading(false);
                    slotInfoEdited['task_name']=taskInfo.name?taskInfo.name:selectedSlotData.internaljob;
                    slotInfoEdited['task_id']=taskInfo.id?taskInfo.id:selectedSlotData.job_id;
                    slotInfoEdited['attendant_user_id']=attendantInfo.id?attendantInfo.id:selectedSlotData.attendant_id;
                    slotInfoEdited['attendant']=attendantInfo.name?attendantInfo.name:selectedSlotData.attendant;
                    slotInfoEdited['note']=note;
                    
               
               
                    setApiSuccess("Mapping updated successfully");
                      editSlotSuccessCallback(slotInfoEdited,selectedSlotData)
                 setTimeout(() => {
                  
                   setShowPopUp(false);
                   document.body.classList.remove("hidden");
                   setEnableSubmit(true);
                   
                 }, 3000);
                } else {
                    setIsLoading(false);
               setEditError(response?.data?.response?.errors[0]?.error?.message);
               setEnableSubmit(true);
               }
   

            }
        
        }
        else {
            setIsLoading(false);
            // setEditError("Kindly select field to be edited")
          
        }
     
      };
     
  
    const submit = async () => {
        setIsLoading(true);
        setApiError({})
        const isError = validations();
       
       
      
        const body = 
            arr.length > 0 ? arr.map((slots) => {
                   
                    return (

                        {
                            
                            "driver_user_id": attendantInfo.id,
                            "puppy_vehicle_id": selectedSlotData?.slotDetails?.puppy_vehicle_id,
                            "slot_date": moment(selectedSlotData?.date).format("YYYY-MM-DD"),
                            "start_time": moment(slots, ["h:mm A"]).format("HH:mm:ss"),
                            "slot_type": "O",
                            "slot_task_id": taskInfo.id,
                            "note":note
                        }
                    )
                })
                :
                [
                     {
                        "driver_user_id": attendantInfo.id,
                        "puppy_vehicle_id": selectedSlotData?.slotDetails?.puppy_vehicle_id,
                        "slot_date": moment(selectedSlotData?.date).format("YYYY-MM-DD"),
                        "start_time": selectedSlotData.time,
                        "slot_type": "O",
                        "slot_task_id": taskInfo.id,
                        "note":note
                    }    
                    ]
                   


        const finalRequest = { "slot_data": body }

    
     
        if (isError == false&&enableSubmit==true)
        {
           
            setEnableSubmit(false);
            const slotMappingUrl = process.env.REACT_APP_ADD_NEW_SLOT;
            const slotMappingResponse = await axiosPrivate.post(slotMappingUrl, finalRequest);
            setIsLoading(false);
            if (slotMappingResponse?.data?.response?.errors.length != 0)
            {
                setIsLoading(false);
                setEnableSubmit(true);
               slotMappingResponse?.data?.response?.errors.map((errorData) => {
                  
                   setApiError((prev) => {
                       const errTime=errorData.start_time
                       return {
                           
                           ...prev,
                           [errTime]:errorData?.error?.message
                           
                       }
                   })
                   
                })
                
            }
            
            if (slotMappingResponse?.data?.response?.data?.success.length > 0)
            {
                setIsLoading(false);
               
                let finalRequestArr = slotMappingResponse?.data?.response?.data?.success;
                finalRequestArr.map((slotObj,index) => {
                    finalRequestArr[index]['slot']=slotObj['start_time'];
                    finalRequestArr[index]['attendant_user_id']=slotObj['driver_user_id'];
                    finalRequestArr[index]['puppy']=selectedSlotData?.puppy;
                    finalRequestArr[index]['task_name']=taskInfo.name;
                    finalRequestArr[index]['attendant']=attendantInfo?.name;
                    finalRequestArr[index]['slot_id']=slotObj['slot_mapping_id'];
                    finalRequestArr[index]['task_id']=taskInfo.id;
                    finalRequestArr[index]['slot_note']=note;
                });
                setApiSuccess("Mapping updated successfully");
                 manageJobOnSuccessCallback(finalRequestArr,selectedSlotData?.shift);
                setTimeout(() => {
                    setEnableSubmit(true);
               
                //closepopup();

                }, 3000);
               
            }
           
        }

    }
    const deleteMapping = async () => {
        setIsLoading(true);
        const body = {
            slot_mapping_id: selectedSlotData.slotid,
           
          };
          if(enableSubmit==true){
            setEnableSubmit(false);
            const response = await axiosPrivate.post(
                process.env.REACT_APP_DELETE_SLOT,
                body
              );
    
              if (response?.data?.status == "200") {
                  setIsLoading(false);
                  setApiSuccess("Mapping deleted successfully");
                   deleteSlotSuccessCallback(selectedSlotData);
                setTimeout(() => {
                   
                    setShowPopUp(false);
                    document.body.classList.remove("hidden");
                    setEnableSubmit(true)
                    
                }, 3000);
              }

          }
         

    }
  
    return (
        <Overlay>
            {isLoading==true&&<Spinner/>}
            <div class="model_box_child" id="manageJobBookingTime" style={{ width: "500px" }}>
                <div class="ap_heading">
                    <h4> Manage job <span class="material-symbols-rounded black close_model" onClick={ closepopup}> close </span>
                    </h4>
                </div>
                <div class="contentSection">
                    <section class="assignPromoP">
                        <div class="bookedSlotPopup">
                           
                            <span class="name">{Time(selectedSlotData.time)}</span>
                            <div> {selectedSlotData.puppy}</div>
                            {selectedSlotData?.slotDetails.puppy_charger_capacity != null &&
                                <span class="sm lclr">
                                    <i class="material-symbols-rounded grey sm">ev_charger</i>{selectedSlotData?.slotDetails.puppy_charger_capacity+"kWh"}</span>}
                        </div>
                        <div class="dForm w300">
                            <div class="rType alignBottom mb-24">
                                <div class="fieldGroup">
                                    <label>Select internal job purpose</label>
                                    <div class="multiOption mb-16" id="tasks" onClick={(e) => taskList(e)}>
                                        <div ref={taskListRef} class={openDropDown.tasks == true ? "selectBox fullWidth open" : "selectBox fullWidth"}>
                                        <p className='selected'>{taskInfo.name?taskInfo.name:selectedSlotData.internaljob?selectedSlotData.internaljob:"Select internal job"}
                                            {/* <p class="selected">{taskInfo.name == "" ? "Select internal job " : taskInfo.name} */}
                                                <i class="material-symbols-rounded grey">expand_more</i>
                                            </p>
                                            <div class="selectDrop customScroll hFix">
                                                <ul class="dropMenu">
                                                    {

                                                        list.taskList.map((task) => {
                                                            return (
                                                                <li class={task.id == taskInfo.id && "selected"}>
                                                                    <a onClick={() => selectTask(task)}>{task?.name}
                                                                        {task.id == taskInfo.id &&
                                                                            <i class="material-symbols-rounded">done</i>}
                                                                    </a>
                                                                </li>
                                                            )
                                                        })
                                                    }


                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                 
                                    {errors.taskidError && <Error error={ errors.taskidError } />}


                                    </div>

                                    <div class="fieldGroup mt-0 mb-16">
                <label>Instructions</label>
                <textarea   name="" value={note}   placeholder="Add instructions/notes" onChange={(e)=>{setNote(e.target.value);setEditError("")}}></textarea>
              </div>

                                    <div class="fieldGroup mt-0">

                                    {(<div >
                                        <input type="checkbox" id="addattendent" onClick={showAttendant} checked={addAttendant} />
                                        <label for="addattendent">Add Attendent</label>
                                    </div>)}
                                    
                                   
                                    {
                                        
                                       (addAttendant == true)&&
                                       
                                    
                                        <div class="multiOption mt-8" id="attendants" onClick={(e) => taskList(e)}>
                                            <div ref={attendantListRef} class={openDropDown.attendants == true ? "selectBox fullWidth open" : "selectBox fullWidth"}>
                                                <p class="selected">
                                                {attendantInfo.name?attendantInfo.name:selectedSlotData.attendant?selectedSlotData.attendant:"Select attendants"}
                                                    {/* {attendantInfo.name == "" ? " Select attendants" : attendantInfo.name} */}
                                                    <i class="material-symbols-rounded grey">expand_more</i>
                                                </p>
                                                <div class="selectDrop customScroll hFix">
                                                    <ul class="dropMenu">
                                                        {list.attendantList && list.attendantList.map((attendant) => {
                                                            return (
                                                                attendant.firstname != "" &&
                                                                <li class={attendant.user_id == attendantInfo.id && "selected"} >
                                                                    <a onClick={() => selectAttendant(attendant)}>{attendant.firstname+" "+attendant.lastname}
                           
                                                                        {attendant.user_id == attendantInfo.id &&
                                                                            <i class="material-symbols-rounded">done</i>}
                                                                    </a>
                                                                </li>
                                                            )
                                                        })}
                                                    </ul>
                                                </div>
                                                {errors.attendantidError && <Error error={errors.attendantidError} />}
                                            </div>
                                        </div>}

                                </div>
                             
                                {/* <div class="fieldGroup">
                                    <label>&nbsp;</label>
                                </div> */}
                            </div>
                            {editSlot==false&&(<>
                                <div class="xType alignBottom">
                                <div class="fieldGroup mt-0">
                                    <label>Select time</label>
                                    <div class="multiOption">
                                        <div class="selectBox">
                                            <p class="selected"> {Time(selectedSlotData.time).split(' ')[0]}
                                                <i class="material-symbols-rounded grey"> expand_more </i>
                                            </p>

                                        </div>

                                        <div class="sepText">
                                            <span class={Time(selectedSlotData.time).split(' ')[1].toLowerCase() == "am" && "active"}> am </span>
                                            <span class={Time(selectedSlotData.time).split(' ')[1].toLowerCase() == "pm" && "active"}> pm </span>
                                        </div>
                                    </div>
                                   
                                </div>

                                <div class="fieldGroup mt-0 mr-0 fullWidth">
                  <em class="smallLabel">
                                    </em>
                                     <div class="multiOption" id="toTime" onClick={(e) => taskList(e)}>
                                        <div ref={ timeRef}class={openDropDown.toTime == true ? "selectBox open" : "selectBox"}>
                                            <p class="selected"> {time.toTime == "" ? "Select time" : Time(time.toTime).split(" ")[0]}<i class="material-symbols-rounded grey"> expand_more </i>
                                            </p>
                                            <div class="selectDrop customScroll hFix">
                                                <ul class="dropMenu">
                                                    {selectedSlotData.timeArr.map((times) => {
                                                       
                                                      
                                                        return (
                                                            <li class={times == time.toTime ? "selected" : ""}>

                                                                {times > selectedSlotData.time && (<>

                                                                    <a onClick={() => manageTime(times)}> {Time(times).split(" ")[0]}

                                                                        {times == time.toTime && <i class="material-symbols-rounded"> done </i>}
                                                                    </a>


                                                                </>)}

                                                            </li>
                                                        )
                                                    })}

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="sepText">
                                            <span class={time.toTimeAmPm == "am" && "active"}> am </span>
                                            <span class={time.toTimeAmPm == "pm" && "active"}> pm </span>
                                        </div>
                                    </div>
                                    </div>
                                <div class="fieldGroup">
                                    <label>&nbsp;</label>
                                </div>
                            </div>
                            
                            </>)}
                            
                        </div>
                    </section>
                    
                    {
                       Object.entries(apiError).map((errorData) => {
                         
                            return (
                                <>
                                    {errorData[0] != undefined && <Error error={errorData[0] + ": " + errorData[1]} />}
                                    <br />
                                    </>
                            )
                        })
                    }
                    {
                        apiSuccess && <Success success={ apiSuccess} />
                    }
                     {editError&&<Error error={editError}/>}
                   
                    <div class="actionButtons mt-24">
                        <span>
                        <a class="btn prim mr-16" onClick={editSlot?editSelectedSlot:submit}> Update </a>
                        </span>
                        
                            
                            {editSlot&& <span><a class="btn seco error" onClick={deleteMapping} > Delete job </a></span>}
                           
                
                    </div>
                </div>
            </div>
        </Overlay>
    )
}

export default ManageJob