import moment from "moment";
import { useState } from "react";
import React from "react";
import Overlay from "../../utils/Overlay";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import { useEffect } from "react";
import useOutsideClick from "../../hooks/useOutsideClick";
import { Link, resolvePath } from "react-router-dom";
import Error from "../UI/Error";
import Success from "../UI/Success";
import NoPriviliges from "../UI/NoPriviliges";
import useAuth from "../../hooks/useAuth";
export default function ManageSlots({
  setshowManageSlotWindow,
  selectedTimeSlot,
  date,
  slotData,
  puppyList,
  attendantList,
  setslotData,
  slotIndex,
  status,
  setisSuccess,
  isSuccess,
  selectedTime,
  setpuppyList,
  slotEdited,
  setslotEdited,
  managePuppyAttendentListing,
}) {
  const { auth } = useAuth();
  const [attendantsError, setattendantsError] = useState([]);
  const [puppyErrors, setpuppyErrors] = useState([]);
  const currentDate = new Date();
  const selectedDate = new Date(date);
  const currTime = moment(currentDate).format("HH:mm:ss");
  const slottime = moment(selectedTime).format("HH:mm:ss");
  const axiosPrivate = useAxiosIntercept();
  const [fields, setFields] = useState([
    {
      key: Date.now(),
      puppy_vehicle_id: "",
      driver_user_id: "",
      slot_date: moment(date).format("YYYY-MM-DD"),
      start_time: moment(selectedTimeSlot, "h:mm A").format("HH:mm:ss"),
    },
  ]);
  const [showAttendantsList, setshowAttendantsList] = useState(false);
  const [showPuppyList, setshowPuppyList] = useState(false);
  const [attendantLabel, setAttendantLabel] = useState([]);
  const [puppyLabel, setPuppyLabel] = useState([]);
  const [attendantId, setAttendantId] = useState("");
  const [puppyVehicleId, setPuppyVehicleId] = useState("");
  const [isEdit, setisEdit] = useState(false);
  const [slotEdit, setslotEdit] = useState(false);
  const [editPuppyId, seteditPuppyId] = useState("");
  const [editdriverId, seteditDriverId] = useState("");
  const [editRegistrationno, seteditregistrationno] = useState("");
  const [editdrivername, seteditdrivername] = useState("");
  const [slotmappingId, setslotmappingId] = useState("");
  const [editError, seteditError] = useState(false);
  const [successMessage, setSuccessMessage] = useState(false);
  const [deleteError, setdeleteError] = useState("");
  let ispuppyError = 0;
  let isdriverError = 0;
  const [errors, setErrors] = useState("");
  let slot_data = [];

  const validations = (fields) => {
    const data = [...fields];

    for (let index = 0; index < data.length; index++) {
      if (data[index].puppy_vehicle_id == "") {
        data[index].puppyvehicleError = "Puppy is required";
      } else {
        ispuppyError++;
        data[index].puppyvehicleError = "";
      }

      if (data[index].driver_user_id == "") {
        data[index].driveridError = "Driver id is required";
      } else {
        data[index].driveridError = "";
        isdriverError++;
      }
    }

    setFields(data);
  };
  const onBackdropClick = () => {
    document.body.classList.remove("hidden");
    setshowManageSlotWindow(false);
  };
  const attendantInfo = (name, driverid, index, event, lastname) => {
    if (slotEdit) {
      seteditDriverId(driverid);
      seteditdrivername(name);
      seteditError(false);
    } else {
      setErrors("");
      var errors = [...attendantsError];
      errors[index] = "";
      setattendantsError(errors);
      //setattendantsError("");
      const labels = [...attendantLabel];
      labels[index] = name + " " + lastname;
      setAttendantLabel(labels);
      //setAttendantLabel({ [index]: name });
      setAttendantId(driverid);
      const values = [...fields];
      values[index]["driver_user_id"] = driverid;
      setFields(values);
    }
  };
  const puppyInfo = (name, vehicleId, index, event) => {
    if (slotEdit) {
      seteditError(false);
      seteditPuppyId(vehicleId);
      seteditregistrationno(name);
    } else {
      setErrors("");
      //setpuppyErrors("");
      var errors = [...puppyErrors];
      errors[index] = "";
      setpuppyErrors(errors);

      const labels = [...puppyLabel];
      labels[index] = name;
      setPuppyLabel(labels);
      setPuppyVehicleId(vehicleId);
      const values = [...fields];
      values[index]["puppy_vehicle_id"] = vehicleId;
      setFields(values);
    }
  };
  const addAnotherSlot = () => {
    const prev_fields = [...fields];

    setFields([
      ...fields,
      {
        key: Date.now(),
        puppy_vehicle_id: "",
        driver_user_id: "",
        slot_date: moment(date).format("YYYY-MM-DD"),
        start_time: moment(selectedTimeSlot, "h:mm A").format("HH:mm:ss"),
      },
    ]);

    const prev_fields1 = [...fields];
  };
  const handleremove = (id, index) => {
    const filtered = fields.filter((obj) => {
      return obj.key !== id;
    });

    setFields(filtered);

    const attendantlabels = [...attendantLabel];
    attendantlabels.splice(index, 1);
    setAttendantLabel(attendantlabels);
    const puppylabels = [...puppyLabel];
    puppylabels.splice(index, 1);
    setPuppyLabel(puppylabels);

    const puppyerrors = [...puppyErrors];
    puppyerrors.splice(index, 1);
    setpuppyErrors(puppyerrors);

    const attendantserrors = [...attendantsError];
    attendantserrors.splice(index, 1);
    setattendantsError(attendantserrors);
  };
  const createNewSlot = async () => {
    const body = {
      slot_data: fields,
    };
    for (var i = 0; i < fields.length; i++) {
      if (fields[i].driver_user_id == "") {
        let attendant_err = [...attendantsError];
        attendant_err[i] = "Select Attendant";
        setattendantsError(attendant_err);
      }

      if (fields[i].puppy_vehicle_id == "") {
        let puppy_err = [...puppyErrors];
        puppy_err[i] = "Select Puppy";
        setpuppyErrors(puppy_err);
      }
    }
    validations(fields);

    if (ispuppyError == fields.length && isdriverError == fields.length) {
      const response = await axiosPrivate.post(
        process.env.REACT_APP_ADD_NEW_SLOT,
        body
      );
      if (response?.data?.response?.errors?.length == "0") {
        setshowManageSlotWindow(false);
        document.body.classList.remove("hidden");
        setisSuccess(!isSuccess);
      } else {
        setErrors(response?.data?.response?.errors);
      }
    }
  };
  const deleteSlot = async (slot_id, index) => {
    const body = {
      slot_mapping_id: slot_id,
      // status: 0,
      // slot_date: moment(date).format("YYYY-MM-DD"),
      // start_time: moment(selectedTimeSlot, "h:mm A").format("HH:mm:ss")
    };
    const response = await axiosPrivate.post(
      process.env.REACT_APP_DELETE_SLOT,
      body
    );
    if (response?.data?.status == "200") {
      managePuppyAttendentListing(selectedTime);
      setisSuccess(!isSuccess);
      const slotdata_temp = [...slotData];
      slotdata_temp.splice(index, 1);
      setslotData(slotdata_temp);
      setSuccessMessage("Slot deleted successfully");
      setTimeout(() => {
        //setSuccess(!success);
        setSuccessMessage("");
      }, 3000);
      // onBackdropClick();
    } else {
      setdeleteError(response?.data?.response?.errors);
      setTimeout(() => {
        //setSuccess(!success);
        setdeleteError("");
      }, 3000);
    }
  };
  const editSlot = (
    slot_id,
    index,
    reg_no,
    name,
    puppy_vehicle_id,
    driver_id
  ) => {
    setFields([
      {
        puppy_vehicle_id: "",
        driver_user_id: "",
      },
    ]);

    setslotEdit(true);
    setisEdit({ [index]: !isEdit[index] });
    seteditDriverId(driver_id);
    seteditPuppyId(puppy_vehicle_id);
    seteditdrivername(name);
    seteditregistrationno(reg_no);
    setslotmappingId(slot_id);
  };
  const editSelectedSlot = async () => {
    const URL = process.env.REACT_APP_EDIT_SLOT;
    const body = {
      slot_data: [
        {
          slot_date: moment(date).format("YYYY-MM-DD"),
          start_time: moment(selectedTimeSlot, "h:mm A").format("HH:mm:ss"),
          slot_mapping_id: slotmappingId,
          driver_user_id: editdriverId,
          puppy_vehicle_id: editPuppyId,
        },
      ],
    };
    const response = await axiosPrivate.post(URL, body);
    if (response?.data?.response?.errors.length == "0") {
      setslotEdit(!slotEdited);
      setisSuccess(!isSuccess);
      setSuccessMessage("Slot edited successfully");
      setTimeout(() => {
        //setSuccess(!success);
        onBackdropClick();
      }, 3000);
    } else {
      seteditError(response?.data?.response?.errors[0]?.error?.message);
    }
  };
  return (
    <>
      <Overlay onBackdropClick={onBackdropClick}>
        <div
          class="model_box_child manageSlotsP"
          id="manageSlotsP"
          style={{ width: "530px", maxHeight: "550px", overflowY: "auto" }}
        >
          <div class="ap_heading">
            <h4 style={{ fontSize: "1.25rem", color: "#212121" }}>
              Manage slots{" "}
              <span
                class="material-symbols-rounded black close_model"
                style={{ marginLeft: "auto" }}
                onClick={onBackdropClick}
              >
                close
              </span>
            </h4>
          </div>
          <div class="contentSection">
            <section class="assignPromoP">
              <div class="promoText customer">
                <h4 style={{ color: "#212121" }}>{selectedTimeSlot}</h4>
                <p>{moment(date).format("dddd, DD MMMM")}</p>
              </div>
            </section>

            
            {auth.priviliges.includes("write_booking_slots") &&
              <>
              <section>
              <div class="slotssList">
                <ul>
                  {slotData &&
                    slotData?.length != "0" &&
                    slotData.map((data, index) => {
                      return (
                        <>
                          <li>
                            <p>
                              <span>{data.registration_no}</span>
                              <em>
                                {data.available_charging_capacity} kWh left
                              </em>
                            </p>
                            <p class="dot"></p>
                            <p>
                              <span>{data.name}</span>
                              <em>{data.phone}</em>
                            </p>
                            {selectedDate.setHours(0, 0, 0, 0) >
                              currentDate.setHours(0, 0, 0, 0) && (
                              <div class="icons flexFlowInitial">
                                <i
                                  class="material-symbols-rounded mt-m"
                                  onClick={() => {
                                    editSlot(
                                      data.id,
                                      index,
                                      data.registration_no,
                                      data.name,
                                      data.puppy_vehicle_id,
                                      data.driver_user_id
                                    );
                                  }}
                                >
                                  edit
                                </i>

                                <i
                                  class="material-symbols-rounded mt-m"
                                  onClick={() => {
                                    deleteSlot(data.id, index);
                                  }}
                                >
                                  delete
                                </i>
                              </div>
                            )}
                            {selectedDate.setHours(0, 0, 0, 0) ==
                              currentDate.setHours(0, 0, 0, 0) &&
                              slottime > currTime && (
                                <div class="icons flexFlowInitial">
                                  <i
                                    class="material-symbols-rounded mt-m"
                                    onClick={() => {
                                      editSlot(
                                        data.id,
                                        index,
                                        data.registration_no,
                                        data.name,
                                        data.puppy_vehicle_id,
                                        data.driver_user_id
                                      );
                                    }}
                                  >
                                    edit
                                  </i>

                                  <i
                                    class="material-symbols-rounded mt-m"
                                    onClick={() => {
                                      deleteSlot(data.id, index);
                                    }}
                                  >
                                    delete
                                  </i>
                                </div>
                              )}
                          </li>
                        </>
                      );
                    })}
                </ul>
              </div>
              {selectedDate.setHours(0, 0, 0, 0) >
                currentDate.setHours(0, 0, 0, 0) && (
                <div class="addSlot dForm">
                  {fields.map((field, index) => {
                    return (
                      <>
                        <div class="lists">
                          <div class="xType alignBottom">
                            <div class="fieldGroup fullWidth">
                              <em class="smallLabel">Select attendant</em>
                              <div
                                class="multiOption"
                                onClick={() => {
                                  setshowAttendantsList({
                                    [index]: !showAttendantsList[index],
                                  });
                                }}
                              >
                                <div
                                  class={
                                    showAttendantsList[index]
                                      ? "selectBox fullWidth open"
                                      : "selectBox fullWidth"
                                  }
                                >
                                  {slotEdit ? (
                                    <p>
                                      {editdrivername}
                                      <i class="material-symbols-rounded grey">
                                        expand_more
                                      </i>
                                    </p>
                                  ) : (
                                    <p>
                                      {attendantLabel[index]
                                        ? attendantLabel[index]
                                        : "Select Attendants"}
                                      <i class="material-symbols-rounded grey">
                                        expand_more
                                      </i>
                                    </p>
                                  )}

                                  <div class="selectDrop customScroll hFix">
                                    <ul class="dropMenu">
                                      {attendantList &&
                                        attendantList.length > 0 &&
                                        attendantList?.map((attendant) => {
                                          return (
                                            <>
                                              <li
                                                onClick={(event) => {
                                                  attendantInfo(
                                                    attendant.firstname,
                                                    attendant.user_id,
                                                    index,
                                                    event,
                                                    attendant?.lastname
                                                  );
                                                }}
                                                name="puppy_vehicle_id"
                                              >
                                                <a>
                                                  {attendant?.firstname +
                                                    " " +
                                                    attendant?.lastname}
                                                </a>
                                              </li>
                                            </>
                                          );
                                        })}
                                    </ul>
                                  </div>
                                  {field.driveridError && (
                                    <Error error={field.driveridError} />
                                  )}

                                  {/* {attendantsError[index] && <span style={{ color: "red" }} >{attendantsError[index]}</span>} */}
                                </div>
                              </div>
                            </div>

                            <div class="fieldGroup fullWidth">
                              <em class="smallLabel">Select puppy</em>
                              <div
                                class="multiOption"
                                onClick={() => {
                                  setshowPuppyList({
                                    [index]: !showPuppyList[index],
                                  });
                                }}
                              >
                                <div
                                  class={
                                    showPuppyList[index]
                                      ? "selectBox fullWidth open"
                                      : "selectBox fullWidth"
                                  }
                                >
                                  {slotEdit ? (
                                    <p>
                                      {editRegistrationno}
                                      <i class="material-symbols-rounded grey">
                                        expand_more
                                      </i>
                                    </p>
                                  ) : (
                                    <p>
                                      {puppyLabel[index]
                                        ? puppyLabel[index]
                                        : "Select Puppy"}
                                      <i class="material-symbols-rounded grey">
                                        expand_more
                                      </i>
                                    </p>
                                  )}
                                  {/* <p>{puppyLabel[index] ? puppyLabel[index] : "Select Puppy"}<i class="material-symbols-rounded grey">expand_more</i></p> */}
                                  <div class="selectDrop customScroll hFix">
                                    <ul class="dropMenu">
                                      {puppyList &&
                                        puppyList?.length > 0 &&
                                        puppyList?.map((puppy) => {
                                          return (
                                            <>
                                              <li
                                                onClick={(event) => {
                                                  puppyInfo(
                                                    puppy.registration_no,
                                                    puppy.vehicle_id,
                                                    index,
                                                    event
                                                  );
                                                }}
                                                name="driver_user_id"
                                              >
                                                <a>{puppy.registration_no}</a>
                                              </li>
                                            </>
                                          );
                                        })}
                                    </ul>
                                  </div>
                                  {field.puppyvehicleError && (
                                    <Error error={field.puppyvehicleError} />
                                  )}

                                  {/* {puppyErrors[index] && <span style={{ color: "red" }} >{puppyErrors[index]}</span>} */}
                                </div>
                              </div>
                            </div>

                            {fields.length > 1 && index != 0 && (
                              <div class="icons" style={{ marginTop: "60px" }}>
                                <i
                                  class="material-symbols-rounded mt-m"
                                  onClick={() => {
                                    handleremove(field.key, index);
                                  }}
                                >
                                  delete
                                </i>
                              </div>
                            )}
                          </div>
                        </div>
                      </>
                    );
                  })}
                  {slotEdit == false && (
                    <div class="link">
                      <i class="material-symbols-rounded mt-m">more_time</i>
                      <a onClick={addAnotherSlot}>Add another slot</a>
                    </div>
                  )}
                </div>
              )}
              {selectedDate.setHours(0, 0, 0, 0) ==
                currentDate.setHours(0, 0, 0, 0) &&
                slottime > currTime && (
                  <div class="addSlot dForm">
                    {fields.map((field, index) => {
                      return (
                        <>
                          <div class="lists">
                            <div class="xType alignBottom">
                              <div class="fieldGroup fullWidth">
                                <em class="smallLabel">Select attendant</em>
                                <div
                                  class="multiOption"
                                  onClick={() => {
                                    setshowAttendantsList({
                                      [index]: !showAttendantsList[index],
                                    });
                                  }}
                                >
                                  <div
                                    class={
                                      showAttendantsList[index]
                                        ? "selectBox fullWidth open"
                                        : "selectBox fullWidth"
                                    }
                                  >
                                    {slotEdit ? (
                                      <p>
                                        {editdrivername}
                                        <i class="material-symbols-rounded grey">
                                          expand_more
                                        </i>
                                      </p>
                                    ) : (
                                      <p>
                                        {attendantLabel[index]
                                          ? attendantLabel[index]
                                          : "Select Attendants"}
                                        <i class="material-symbols-rounded grey">
                                          expand_more
                                        </i>
                                      </p>
                                    )}
                                    {/* <p>{attendantLabel[index] ? attendantLabel[index] : "Select Attendants"}<i class="material-symbols-rounded grey">expand_more</i></p> */}
                                    <div class="selectDrop customScroll hFix">
                                      <ul class="dropMenu">
                                        {attendantList &&
                                          attendantList.length > 0 &&
                                          attendantList?.map((attendant) => {
                                            return (
                                              <>
                                                <li
                                                  onClick={(event) => {
                                                    attendantInfo(
                                                      attendant.firstname,
                                                      attendant.user_id,
                                                      index,
                                                      event,
                                                      attendant?.lastname
                                                    );
                                                  }}
                                                  name="puppy_vehicle_id"
                                                >
                                                  <a>
                                                    {attendant?.firstname +
                                                      " " +
                                                      attendant?.lastname}
                                                  </a>
                                                </li>
                                              </>
                                            );
                                          })}
                                      </ul>
                                    </div>

                                    {field?.driveridError && (
                                      <Error error={field?.driveridError} />
                                    )}
                                    {/* {attendantsError[index] && <span style={{ color: "red" }} >{attendantsError[index]}</span>} */}
                                  </div>
                                </div>
                              </div>

                              <div class="fieldGroup fullWidth">
                                <em class="smallLabel">Select puppy</em>
                                <div
                                  class="multiOption"
                                  onClick={() => {
                                    setshowPuppyList({
                                      [index]: !showPuppyList[index],
                                    });
                                  }}
                                >
                                  <div
                                    class={
                                      showPuppyList[index]
                                        ? "selectBox fullWidth open"
                                        : "selectBox fullWidth"
                                    }
                                  >
                                    {slotEdit ? (
                                      <p>
                                        {editRegistrationno}
                                        <i class="material-symbols-rounded grey">
                                          expand_more
                                        </i>
                                      </p>
                                    ) : (
                                      <p>
                                        {puppyLabel[index]
                                          ? puppyLabel[index]
                                          : "Select Puppy"}
                                        <i class="material-symbols-rounded grey">
                                          expand_more
                                        </i>
                                      </p>
                                    )}
                                    {/* <p>{puppyLabel[index] ? puppyLabel[index] : "Select Puppy"}<i class="material-symbols-rounded grey">expand_more</i></p> */}
                                    <div class="selectDrop customScroll hFix">
                                      <ul class="dropMenu">
                                        {puppyList &&
                                          puppyList?.length > 0 &&
                                          puppyList?.map((puppy) => {
                                            return (
                                              <>
                                                <li
                                                  onClick={(event) => {
                                                    puppyInfo(
                                                      puppy.registration_no,
                                                      puppy.vehicle_id,
                                                      index,
                                                      event
                                                    );
                                                  }}
                                                  name="driver_user_id"
                                                >
                                                  <a>{puppy.registration_no}</a>
                                                </li>
                                              </>
                                            );
                                          })}
                                      </ul>
                                    </div>
                                    {field?.puppyvehicleError && (
                                      <Error error={field?.puppyvehicleError} />
                                    )}
                                    {/* {puppyErrors[index] && <span style={{ color: "red" }} >{puppyErrors[index]}</span>} */}
                                  </div>
                                </div>
                              </div>

                              {fields.length > 1 && index != 0 && (
                                <div
                                  class="icons"
                                  style={{ marginTop: "60px" }}
                                >
                                  <i
                                    class="material-symbols-rounded mt-m"
                                    onClick={() => {
                                      handleremove(field.key, index);
                                    }}
                                  >
                                    delete
                                  </i>
                                </div>
                              )}
                            </div>
                          </div>
                        </>
                      );
                    })}

                    {slotEdit == false && (
                      <div class="link">
                        <i class="material-symbols-rounded mt-m">more_time</i>
                        <a onClick={addAnotherSlot}>Add another slot</a>
                      </div>
                    )}
                  </div>
                )}
            </section>
               {selectedDate.setHours(0, 0, 0, 0) >
              currentDate.setHours(0, 0, 0, 0) && (
              <div class="actionButtons mt-24">
                <span>
                  <a
                    class="btn prim fullW"
                    onClick={slotEdit ? editSelectedSlot : createNewSlot}
                  >
                    Update
                  </a>
                </span>
                {errors && errors?.length > "0" && (
                  <>
                    {errors.map((err) => {
                      return (
                        <>
                          <Error error={err?.error?.message} />
                          {/* <span style={{ color: "red" }}>{err?.error?.message}</span> */}
                        </>
                      );
                    })}
                  </>
                )}
              </div>
            )}
            {selectedDate.setHours(0, 0, 0, 0) ==
              currentDate.setHours(0, 0, 0, 0) &&
              slottime > currTime && (
                <div class="actionButtons mt-24">
                  <span>
                    <a
                      class="btn prim fullW"
                      onClick={slotEdit ? editSelectedSlot : createNewSlot}
                    >
                      Update
                    </a>
                  </span>

                  {errors && errors?.length > "0" && (
                    <>
                      {errors.map((err) => {
                        return (
                          <>
                            <Error error={err?.error?.message} />

                            {/* <span style={{ color: "red" }}>{err?.error?.message}<br /></span> */}
                          </>
                        );
                      })}
                    </>
                  )}
                </div>
              )}
            {editError && <Error error={editError} />}
            {deleteError &&
              deleteError?.length > "0" &&
              deleteError.map((err) => {
                return (
                  <>
                    <Error error={err?.message} />
                  </>
                );
              })}
            <Success success={successMessage} />
              </> 
          
          }
           
            {/* {successMessage && <span style={{ color: "green" }}>{successMessage}</span>} */}
          </div>
        </div>
      </Overlay>
    </>
  );
}
