import React, { useEffect } from "react";
import moment from "moment";
import Spinner from "../UI/Spinner";
import { Time } from "../../utils/Time";
import { useState } from "react";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import SlotDaySummaryTime from "./SlotDaySummaryTime";
import DataNotFound from "../UI/DataNotFound";

export default function SlotDateSummary({
  date,
  data,
  toggleValue,
  setToggleValue,
}) {
  const axiosPrivate = useAxiosIntercept();
  const [toggle, setToggle] = useState([]);
  const [slotSummary, setSlotSummary] = useState("");
  const [isToggle, setIsToggle] = useState(false);

  useEffect(() => {
    setToggle({});
    setSlotSummary("");
    let toggle_state = {};
    data &&
      Object.keys(data).length !== 0 &&
      Object.keys(data).map((registration_no) => {
        toggle_state[registration_no] = true;
      });
    setToggle(toggle_state);
  }, [date, data]);

  const handleClick = async (e, index) => {
    setSlotSummary("");
    setToggle((prev) => ({
      ...prev,
      [index]: !toggle[index],
    }));
  };

  const handleToggle = () => {
    setIsToggle(!isToggle);
    setToggleValue(!isToggle == true ? "time" : "puppy");
  };

  return (
    <>
      {data == "" ? (
        <Spinner />
      ) : data && Object.keys(data).length !== 0 ? (
        <>
          <div className="subContent SlotDetails mt-8 pt-24 open">
            <div class="xRow titleHead mb-24">
              <h2 class="mar-0">
                Puppy slot details - {moment(date).format("dddd,DD MMMM")}
              </h2>

              <div class="xRow">
                <em>Puppy</em>
                <label class="toggleSwitch fType">
                  <input
                    type="checkbox"
                    onClick={(e) => handleToggle(e)}
                    checked={isToggle && true}
                  />
                  <span class="slider round"></span>
                </label>
                <em>Time</em>
              </div>
            </div>
            {toggleValue == "puppy" ? (
              <>
                <div className="lists open">
                  {Object.keys(data).map((registration_no) => {
                    let details = data[registration_no];
                    return (
                      <>
                        <section
                          className={toggle[registration_no] ? "open" : ""}
                        >
                          <div
                            className="slotHead"
                            onClick={(e) => {
                              handleClick(e, registration_no);
                            }}
                          >
                            <div className="slotNumber">{registration_no}</div>
                            <div className="moreInfoBtn">
                              <a
                                id={registration_no}
                                style={{ cursor: "pointer" }}
                              >
                                <i
                                  className={
                                    toggle[registration_no]
                                      ? "material-symbols-rounded arrowTop mt-l"
                                      : "material-symbols-rounded arrowBottom mt-l"
                                  }
                                >
                                  expand_more
                                </i>
                              </a>
                            </div>
                          </div>
                          {details && details?.length > 0 ? (
                            <>
                              <div className="dataTableDynamic">
                                <table>
                                  <tbody>
                                    <tr>
                                      <th>Slot</th>
                                      <th>Attendant</th>
                                      <th>Status</th>
                                      <th>Customer details</th>
                                      <th>Customer Vehicle</th>

                                      <th>Package</th>
                                      <th>Service</th>
                                      <th>Address</th>
                                    </tr>
                                    {details &&
                                      details?.length > "0" &&
                                      details.map((slotdata, index2) => {
                                        var vehicle_details = "";
                                        const customer = slotdata?.customer
                                          ? slotdata?.customer
                                          : "-";
                                        const customerPhone = slotdata?.customer
                                          ? slotdata?.customer_phone
                                          : "";
                                        const brand = slotdata?.brand_name
                                          ? slotdata?.brand_name
                                          : "";
                                        const model = slotdata?.model_name
                                          ? slotdata?.model_name
                                          : "";
                                        const variant = slotdata?.variant_name
                                          ? slotdata?.variant_name
                                          : "";
                                        const capacity =
                                          slotdata?.battery_capacity
                                            ? slotdata?.battery_capacity
                                            : "";
                                        vehicle_details = brand
                                          ? vehicle_details + " " + brand
                                          : vehicle_details;
                                        vehicle_details = model
                                          ? vehicle_details + " " + model
                                          : vehicle_details;
                                        vehicle_details = variant
                                          ? vehicle_details + " " + variant
                                          : vehicle_details;
                                        vehicle_details = capacity
                                          ? vehicle_details +
                                            " (" +
                                            capacity +
                                            "kWh" +
                                            ")"
                                          : vehicle_details;
                                        var services = "";
                                        slotdata?.service &&
                                          slotdata?.service?.map((service) => {
                                            services =
                                              services + service + ", ";
                                          });

                                        return (
                                          <>
                                            <tr>
                                              <td className="">
                                                {slotdata?.slot
                                                  ? Time(slotdata?.slot)
                                                  : "-"}
                                              </td>
                                              <td className="noSpace">
                                                {slotdata?.attendant
                                                  ? slotdata?.attendant
                                                  : "-"}
                                              </td>
                                              <td
                                                className={
                                                  slotdata.status == "Booked"
                                                    ? "info"
                                                    : slotdata.status ==
                                                      "Available"
                                                    ? "success"
                                                    : "noSpace"
                                                }
                                              >
                                                {slotdata?.status
                                                  ? slotdata?.status
                                                  : "-"}
                                              </td>

                                              <td>
                                                {`${customer}`}
                                                <br />
                                                {`${customerPhone}`}
                                              </td>
                                              <td>
                                                {`${
                                                  vehicle_details
                                                    ? vehicle_details
                                                    : "-"
                                                }`}
                                                <br />
                                                {`${
                                                  vehicle_details &&
                                                  slotdata?.customer_car_plate
                                                }`}
                                              </td>
                                              <td>
                                                {slotdata?.package
                                                  ? slotdata?.package
                                                  : "-"}
                                              </td>

                                              <td>
                                                {services
                                                  ? services.substring(
                                                      0,
                                                      services.length - 2
                                                    )
                                                  : "-"}
                                              </td>
                                              <td>
                                                {slotdata?.address
                                                  ? slotdata?.address
                                                  : "-"}
                                              </td>
                                            </tr>
                                          </>
                                        );
                                      })}
                                  </tbody>
                                </table>
                              </div>
                            </>
                          ) : toggle[registration_no] &&
                            details[registration_no] == "" ? (
                            <Spinner />
                          ) : (
                            ""
                          )}
                        </section>
                      </>
                    );
                  })}
                </div>
              </>
            ) : (
              <>
                <SlotDaySummaryTime slotData={data} toggleValue={toggleValue} />
              </>
            )}
          </div>
        </>
      ) : (
        <>
          <div className="pt-24">
           <DataNotFound/>
          </div>
        </>
      )}
    </>
  );
}
