import React from "react";
import moment from "moment";
import { useEffect, useState } from "react";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import { Time } from "../../utils/Time";
import Spinner from "../UI/Spinner";
import DataNotFound from "../UI/DataNotFound";

const SlotDaySummaryTime = ({ slotData, toggleValue, setToggleValue }) => {
  const axiosPrivate = useAxiosIntercept();

  return slotData == "" ? (
    <Spinner />
  ) : slotData && Object.keys(slotData).length !== 0 ?
   (
    <div className="dataTableDynamic">
      <table>
        <tbody>
          <tr>
            <th>Slot</th>
            <th>Puppy</th>
            <th>Attendant</th>
            <th>Status</th>
            <th>Customer details</th>
            <th>Customer Vehicle</th>

            <th>Package</th>
            <th>Service</th>
            <th>Address</th>
          </tr>
          {slotData &&
            slotData?.length > "0" &&
            slotData.map((slotDetails, index2) => {
              var vehicle_details = "";
              const customer = slotDetails?.customer
                ? slotDetails?.customer
                : "-";
              const customerPhone = slotDetails?.customer
                ? slotDetails?.customer_phone
                : "";
              const brand = slotDetails?.brand_name
                ? slotDetails?.brand_name
                : "";
              const model = slotDetails?.model_name
                ? slotDetails?.model_name
                : "";
              const variant = slotDetails?.variant_name
                ? slotDetails?.variant_name
                : "";
              const capacity = slotDetails?.battery_capacity
                ? slotDetails?.battery_capacity
                : "";
              vehicle_details = brand
                ? vehicle_details + " " + brand
                : vehicle_details;
              vehicle_details = model
                ? vehicle_details + " " + model
                : vehicle_details;
              vehicle_details = variant
                ? vehicle_details + " " + variant
                : vehicle_details;
              vehicle_details = capacity
                ? vehicle_details + " (" + capacity + "kWh" + ")"
                : vehicle_details;
              var services = "";
              slotDetails?.service &&
                slotDetails?.service?.map((service) => {
                  services = services + service + ", ";
                });

              return (
                <>
                  <tr>
                    <td className="">
                      {slotDetails?.slot ? Time(slotDetails?.slot) : "-"}
                    </td>
                    <td className="noSpace">
                      {slotDetails?.puppy ? slotDetails?.puppy : "-"}
                    </td>
                    <td className="noSpace">
                      {slotDetails?.attendant ? slotDetails?.attendant : "-"}
                    </td>
                    <td
                      className={
                        slotDetails.status == "Booked"
                          ? "info"
                          : slotDetails.status == "Available"
                          ? "success"
                          : "noSpace"
                      }
                    >
                      {slotDetails?.status ? slotDetails?.status : "-"}
                    </td>

                    <td>
                      {`${customer}`}
                      <br />
                      {`${customerPhone}`}
                    </td>
                    <td>
                      {`${vehicle_details ? vehicle_details : "-"}`}
                      <br />
                      {`${vehicle_details && slotDetails?.customer_car_plate}`}
                    </td>
                    <td>{slotDetails?.package ? slotDetails?.package : "-"}</td>

                    <td>
                      {services
                        ? services.substring(0, services.length - 2)
                        : "-"}
                    </td>
                    <td>{slotDetails?.address ? slotDetails?.address : "-"}</td>
                  </tr>
                </>
              );
            })}
        </tbody>
      </table>
    </div>
  ) : (
    <>
     <div className="pt-24">
           <DataNotFound/>
          </div>
    </>
  );
};

export default SlotDaySummaryTime;
