import React, { useEffect } from "react";
import moment from "moment";
import Spinner from "../UI/Spinner";
import { Time } from "../../utils/Time";
import { useState } from "react";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import SlotDaySummaryTime from "./SlotDaySummaryTime";
import DataNotFound from "../UI/DataNotFound";
import ManageJob from "./ManageJob";
import {FormatDate} from "../../utils/FormatDate"
import AddJobNote from "./AddJobNote";
import SlotTile from "./SlotTile";
import SlotTileBooked from "./SlotTileBooked";
import useAuth from "../../hooks/useAuth";

export default function SlotWiseData({
  date,
  data,
  toggleValue,
  setToggleValue,
  isSuccess,
  setisSuccess
}) {
  const { auth } = useAuth();
  const [shiftWiseData,setShiftWiseData]=useState({});
  const [showPopUp,setShowPopUp]=useState(false);
  const [selectedSlotData,setselectedSlotData]=useState({
    time:"",
    puppy:"",
    capacity: "",
    date:""

  })
  const currentDate = new Date();
  const currTime = moment(currentDate).format("HH:mm:ss");
  const [showAddJobNote,setshowAddJobNote]=useState(false);
  const [attendantList,setAttendantList]=useState("");
  const [puppyList,setPuppyList]=useState("");
  const [slotInfo,setslotInfo]=useState({
    slol:"", 
    attendant: "",
    puppy:"",
    customer:"",
    customer_car_plate:"",
    customer_phone:"",
    brand_name:"",
    variant_name:"",
    model_name:"",
    battery_capacity:"",
    address:"",
    service:"",
    puppy_vehicle_id:"",
    date:"",
    time:"",
    booking_id:"",
    attendant_user_id:"",
    booking_status:""
  })

 
  
  const manageJobPopUp = (slotTime,puppy,slotDetails,timeArr,shift) => {
    
    setselectedSlotData({
      time:slotTime,
      puppy:puppy,
      slotDetails: slotDetails, timeArr: timeArr,
      date:date,
      shift:shift,
      
    })
    if(auth.priviliges.includes("write_booking_slots")){
      if(date.setHours(0, 0, 0, 0) >
      currentDate.setHours(0, 0, 0, 0)||(date.setHours(0, 0, 0, 0) ==
      currentDate.setHours(0, 0, 0, 0) &&
      slotTime > currTime))
      {
        setShowPopUp(true);

      }
     

    }
   
    setEditSlot(false);
  }
  
  const axiosPrivate = useAxiosIntercept();
  const [toggle, setToggle] = useState([]);
  const [slotSummary, setSlotSummary] = useState("");
  const [isToggle, setIsToggle] = useState(false);
  const [shiftWisePage,setShiftWisePage]=useState("");
  const [pageRecordsCount, setPageRecordsCount] = useState(16);
  const [pageShiftTimes, setPageShiftTimes] = useState({});
  const [editSlot,setEditSlot]=useState(false);
  const [pdfDownloaded,setpdfDownloaded]=useState(false);

  useEffect(() => {
    setShiftWiseData(data);  
    updatePageShiftTimes(data);
    setToggle({});
    setSlotSummary("");
    let toggle_state = {};
    data &&
      Object.keys(data).length !== 0 &&
      Object.keys(data).map((registration_no) => {
        toggle_state[registration_no] = true;
      });
    setToggle(toggle_state);
  }, [date, data]);

  const updatePageShiftTimes = (parent_state_data)=>{
    Object.keys(parent_state_data).map((shift_index) => {
      
       let shiftTimesTemp = parent_state_data[shift_index]['shift_time'];
       let shiftTimesArr = [];
       
       for(var i=0;i<shiftTimesTemp.length;i++){
           shiftTimesArr.push(shiftTimesTemp[i]);
       }
       setShiftWisePage((prev) => (
               {...prev,[shift_index]: 1
                })
        );
       setPageShiftTimes((prev) => (
               {...prev,[shift_index]: shiftTimesArr
                })
        );
    });
      
  }
  const handlePage = (shift,mode,shiftData) => {
      let previous_page =  shiftWisePage[shift];
      let current_page = previous_page;
      if(mode === 'D'&&shiftWisePage[shift] !== 1 ) {
        current_page = (previous_page - 1);          
      }else if(mode === 'I'&&shiftWisePage[shift] !== Math.ceil(shiftData.shift_time?.length/pageRecordsCount)) {
        current_page =  (previous_page + 1);   
      }
       setShiftWisePage((prev) => (
               {...prev,[shift]: current_page
                })
        );
    let shiftTimesTemp = shiftWiseData[shift]['shift_time'];
    let shiftTimesArr = [];
    let initial_index = ((current_page - 1) * pageRecordsCount);
    for(let i=initial_index;i<(initial_index + pageRecordsCount);i++){
 
       shiftTimesArr.push(shiftTimesTemp[i]);
    }
    //shiftTimesTemp = shiftTimesTemp.splice(((current_page - 1) * pageRecordsCount),pageRecordsCount);
    setPageShiftTimes((prev) => (
               {...prev,[shift]: shiftTimesArr
                })
    );

  };
  const manageJobNote = async(singleSlotInfo,date,time,shift) => {
    if (singleSlotInfo['booking_status']&&singleSlotInfo['booking_status'] != "D"&&auth.priviliges.includes("write_booking_slots")) {
        setshowAddJobNote(true); 
        singleSlotInfo['shift']=shift;
        setslotInfo(singleSlotInfo);
        let puppylisturl =  process.env.REACT_APP_GET_PUPPY_LIST+`&limit=1000`
        let attendantsListUrl=process.env.REACT_APP_GET_ATTENDANTS_LIST+`&limit=1000`

        try {
            const puppyListResponse = await axiosPrivate.get(puppylisturl);
            const attendantListResponse = await axiosPrivate.get(attendantsListUrl);
            if (attendantListResponse?.data?.status == "200") {

              setAttendantList(attendantListResponse?.data?.response?.data?.user_info);

            }
            if (puppyListResponse?.data?.status == "200") {
              setPuppyList(puppyListResponse?.data?.response?.data?.puppy_vehicles);
            }

        } catch (err) {
            console.log(err);

        }      
    }
   
  }
  const editSlotSuccessCallback=(slotInfoEdited,oldSlotInfo)=>{
    let current_state_data = {...shiftWiseData}
   
    current_state_data[oldSlotInfo.shiftlabel]['slot_details'][oldSlotInfo.puppy]['slots'][oldSlotInfo.time]['attendant']=slotInfoEdited.attendant
    current_state_data[oldSlotInfo.shiftlabel]['slot_details'][oldSlotInfo.puppy]['slots'][oldSlotInfo.time]['attendant_user_id']=slotInfoEdited.attendant_user_id
    current_state_data[oldSlotInfo.shiftlabel]['slot_details'][oldSlotInfo.puppy]['slots'][oldSlotInfo.time]['task_name']=slotInfoEdited.task_name
    current_state_data[oldSlotInfo.shiftlabel]['slot_details'][oldSlotInfo.puppy]['slots'][oldSlotInfo.time]['task_id']=slotInfoEdited.task_id
    current_state_data[oldSlotInfo.shiftlabel]['slot_details'][oldSlotInfo.puppy]['slots'][oldSlotInfo.time]['slot_note']=slotInfoEdited.note
    setShiftWiseData(current_state_data);
  }
  const deleteSlotSuccessCallback=(oldSlotInfo)=>{
    let current_state_data = {...shiftWiseData};
   delete current_state_data[oldSlotInfo.shiftlabel]['slot_details'][oldSlotInfo.puppy]['slots'][oldSlotInfo.time]

  }
  const jobNoteOnSuccessCallback = (slotInfoEdited,oldSlotInfo) => {
    let current_state_data = {...shiftWiseData}
    setshowAddJobNote(false);
    document.body.classList.remove("hidden");
    if(oldSlotInfo['puppy'] != slotInfoEdited['puppy']) {
            delete current_state_data[slotInfoEdited['shift']]['slot_details'][oldSlotInfo['puppy']]['slots'][oldSlotInfo['slot']];
    }
    if(current_state_data[slotInfoEdited['shift']]['slot_details'][slotInfoEdited['puppy']] !== undefined) {
        current_state_data[slotInfoEdited['shift']]['slot_details'][slotInfoEdited['puppy']]['slots'][slotInfoEdited['slot']]=slotInfoEdited;
        setShiftWiseData(current_state_data);
    }else {
        setisSuccess(!isSuccess);
    }
  };  
  const manageJobOnSuccessCallback = (newSlotsArr,shift) => {
    let current_state_data = {...shiftWiseData}
     newSlotsArr.map((newSlot)=>{
        current_state_data[shift]['slot_details'][newSlot['puppy']]['slots'][newSlot['slot']]=newSlot;
    });
    setShiftWiseData(current_state_data);
    setShowPopUp(false);
    document.body.classList.remove("hidden");
  };
  
  const handleToggle = () => {
    setIsToggle(!isToggle);
    setToggleValue(!isToggle == true ? "time" : "puppy");
  };
  const downloadPDF=async ()=>{
    setpdfDownloaded(true);
    const selecteddate=moment(date).format("YYYY-MM-DD");
    const url=process.env.REACT_APP_DOWNLOAD_SHIFT_WISE_DATA_PDF+`&slot_date=${selecteddate}`;
    const response=await axiosPrivate.get(url);
   if(response?.data?.status=="200"){
    setpdfDownloaded(false);
    const file=response?.data?.response?.data?.file;
    window.open(file, '_blank', 'noreferrer')

   }
   else{
    setpdfDownloaded(false);
   }
  }
  return (
    <>
    {pdfDownloaded&&<Spinner/>}
      {showAddJobNote&&<AddJobNote setshowAddJobNote={setshowAddJobNote} attendantList={attendantList} puppyList={puppyList} slotInfo={slotInfo} slot_date={date} isSuccess={isSuccess} jobNoteOnSuccessCallback={jobNoteOnSuccessCallback}/>}
      {showPopUp && <ManageJob setShowPopUp={setShowPopUp} selectedSlotData={selectedSlotData} setselectedSlotData={setselectedSlotData} isSuccess={ isSuccess} setisSuccess={setisSuccess} manageJobOnSuccessCallback={manageJobOnSuccessCallback} editSlot={editSlot} editSlotSuccessCallback={editSlotSuccessCallback} deleteSlotSuccessCallback={deleteSlotSuccessCallback}/>}
      {Object.keys(shiftWiseData).length <=0 || Object.keys(pageShiftTimes).length <= 0 ? (
        <Spinner />
      ) : Object.keys(pageShiftTimes).length >0 && shiftWiseData && Object.keys(shiftWiseData).length !== 0 ? (
        <>
          <div className="subContent slotBookingBrief mt-8 pt-24">
            <div className="xRow titleHead mb-24">
              <h2 className="mar-0">{moment(date).format("dddd, DD MMMM YYYY")}</h2>
              <a onClick={downloadPDF} className="btn">
              <i className="material-symbols-rounded brand mt-m">download</i>Download PDF </a>
            </div>
              {

                Object.entries(shiftWiseData).map((shiftData,index) => {
                  return (
                    <>
                    <div className="slotbookingTbl mb-24" key={"shiftData_"+index}>
                      <div className="shifts">
                        <i className="material-symbols-rounded grey mt-l">{shiftData[1].shift_icon}</i>
                        <span>{shiftData[1].shift_label}</span>
                        {/* <div className="arrwBtn">
                            <a onClick={()=>handlePage(shiftData[0],'D')} className={shiftWisePage[shiftData[0]] === 1 ? "material-symbols-rounded mt-l black prev disable" : "material-symbols-rounded mt-l black prev"}>expand_more</a>
                            <a onClick={()=>handlePage(shiftData[0],'I',shiftData[1])} className={shiftWisePage[shiftData[0]] === Math.ceil(shiftData[1].shift_time.length/pageRecordsCount) ? "material-symbols-rounded mt-l black next disable" : "material-symbols-rounded mt-l black next"}>expand_more</a>
                        </div> */}
                      </div>
                      <div className="tableSlots scrollBarC">
                        <table>
                          <thead id="bookingSlotTbl">
                            <tr>
                              <th>Puppy details</th>
                              {pageShiftTimes[shiftData[0]].map((shiftTimes) => {
                                return (<th>{Time(shiftTimes)}</th>)

                              })}

                            </tr>
                          </thead>

                          <tbody>
                            {
                              shiftData[1].slot_details&&  Object.entries(shiftData[1].slot_details).map((slotDetails,index1) => {
                                return (
                                  <>
                                    <tr>
                                      <td> {slotDetails[0]}
                                        {slotDetails[1].puppy_charger_capacity != null &&
                                          <span>
                                            <i className="material-symbols-rounded grey sm">ev_charger</i> { slotDetails[1].puppy_charger_capacity+"kWh"}</span>}
                                      </td>
                                      {
                                        pageShiftTimes[shiftData[0]].map((time,index_new) => {
                                          
                                          return (
                                            slotDetails[1]['slots'][time] != undefined ? (
                                                <SlotTile 
                                                    slotTimeDetails={slotDetails[1]['slots'][time]}
                                                    date={date}
                                                    time={time}
                                                    manageJobNote={manageJobNote}
                                                    shift={shiftData[0]}
                                                    setShowPopUp={setShowPopUp}
                                                    setEditSlot={setEditSlot}
                                                    puppy={slotDetails[0]}
                                                    slotDetails={slotDetails[1]}
                                                    setselectedSlotData={setselectedSlotData}
                                                    shiftlabel={shiftData[0]}
                                                    index={index_new}
                                                    timearr={pageShiftTimes[shiftData[0]]}

                                                >
                                                {slotDetails[1]['slots'][time]['slot_type'] === 'O' &&<>
                                                      <span>{slotDetails[1]['slots'][time]['task_name']}</span>  
                                                      {slotDetails[1]['slots'][time]['slot_note'] &&<div className="viewNotes">
                                                     <a>
                                                          <i className="material-symbols-rounded brand sm mr-5 mt-s">sticky_note_2</i> View notes </a>
                                                               <div className="viewNotesTooltip">
                                                                  {slotDetails[1]['slots'][time]['slot_note'] &&
                                                                     
                                                                     <span>{slotDetails[1]['slots'][time]['slot_note']}</span>
                                                                      
                                                                     }
                    </div>
            </div>}


                                                      </>
                                                }
                                                {slotDetails[1]['slots'][time]['slot_type'] === 'C' 
                                                    && slotDetails[1]['slots'][time]['booking_id'] === "" ?
                                                 (<span class="slotavailable">{slotDetails[1]['slots'][time]['status']}</span>
                                                  ) : slotDetails[1]['slots'][time]['slot_type'] === 'C' && slotDetails[1]['slots'][time]['booking_id'] !== "" 
                                                   ? (
                                                    <SlotTileBooked 
                                                        slotTimeDetails={slotDetails[1]['slots'][time]}
                                                    />
                                                  ) :
                                                  ""      
                                                }
                                                </SlotTile>
         
                                            ) : (<>
                                            {(slotDetails[1]['slots'][pageShiftTimes[shiftData[0]][index_new-1]]&&
                                              slotDetails[1]['slots'][pageShiftTimes[shiftData[0]][index_new-1]]['slot_type'] == "C")?"":<td  className="noborder" onClick={()=>{time!==undefined&&manageJobPopUp(time,slotDetails[0],slotDetails[1],shiftData[1].shift_time,shiftData[0])}}></td>}
                                           
                                              
                                            </>))
                                        })
                                      }
                                    </tr>
                                  </>
                                )
                              })
                            }

                          </tbody>
                        </table>
                      </div>
                    </div>  
                    </>
                  )
                })
              }

          </div>
    </>
  ) : (
    <>
      <div className="pt-24">
        <DataNotFound />
      </div>
    </>
  )
}
    </>
  );
}
