import React, { useEffect, useState } from 'react'
import { useRef } from 'react';
import MainContainer from '../UI/MainContainer';
import SubMainContainer from '../UI/SubMainContainer';
import Header from '../Layouts/Header/Header';
import SideBar from '../Layouts/SideBar/SideBar';
import BookingsInfo from './BookingsInfo';
import { pageTitles } from '../../configuration/GlobalConfig';
import useAuth from '../../hooks/useAuth';
import DataNotFound from '../UI/DataNotFound';
import NoPriviliges from '../UI/NoPriviliges';
import Spinner from '../UI/Spinner';

export default function Booking() {
    const { auth } = useAuth();
    document.title = pageTitles.BOOKINGS;
    const inputElement = useRef();
    const [error, setError] = useState({
        errType: "",
        errValue: "",
    });

    return (
        <>
            <MainContainer>
                <Header errData={error.errType} errValue={error.errValue} />
                <SubMainContainer>
                    <SideBar />
                    <div className="rightCol">
                        <div className="contentContainer">
                            <h2>Bookings</h2>
                            {auth.priviliges.length>"0"? auth.priviliges.includes("read_bookings") ?
                            <div class="subContent">
                                <BookingsInfo />
                            </div>
                            : <NoPriviliges message="no priviliges"/>:<Spinner/>}
                        </div>
                    </div>
                </SubMainContainer>

            </MainContainer>
        </>
    )
}
