import React from 'react'
import { useState } from 'react';
import useAxiosIntercept from '../../hooks/useAxiosIntercept';
import { useEffect } from 'react'
export default function BookingHeaders({ isbookingCancelled, isJobDone }) {
    const axiosPrivate = useAxiosIntercept();
    const [bookingCounts, setbookingCounts] = useState({
        active: "",
        inprogress: "",
        puppy_assigned: "",
        puppy_not_assigned: ""
    });
    const getBookingCount = async () => {
        let URL = process.env.REACT_APP_GET_BOOKING_HISTORY + `&show_booking_count=1&show_puppy_info=1`;
        let upComingBookingrequest = {
            is_active: 1

        }
        try {
            let response = await axiosPrivate.post(URL, upComingBookingrequest);
            if (response?.data?.status == "200") {
                setbookingCounts({
                    active: response?.data?.response?.data?.active,
                    inprogress: response?.data?.response?.data?.inprogress,
                    puppy_assigned: response?.data?.response?.data?.puppy_assigned,
                    puppy_not_assigned: response?.data?.response?.data?.puppy_not_assigned

                })
            }


        }
        catch (err) {
            console.log(err);
        }

    }
    useEffect(() => {
        getBookingCount();


    }, [isbookingCancelled, isJobDone])
    return (
        <>

            <div class="xRow fullWidth lookUpDataDashboard mb-24">
                <div class="boxT1 chargingData">
                    <i class="material-symbols-rounded grey fill">task</i>
                    <p>Active bookings</p>
                    <span>{bookingCounts.active}</span>
                </div>
                <div class="boxT1 inprogress">
                    <i class="material-symbols-rounded grey fill">electric_car</i>
                    <p>Inprogress</p>
                    <span>{bookingCounts.inprogress}</span>
                </div>
                <div class="boxT1 packageData">
                    <i class="material-symbols-rounded grey fill">assignment_ind</i>
                    <p>Puppy assigned</p>
                    <span>{bookingCounts.puppy_assigned}</span>
                </div>
                <div class="boxT1">
                    <i class="material-symbols-rounded grey fill">person_search</i>
                    <p>Puppy not assigned</p>
                    <span>{bookingCounts.puppy_not_assigned}</span>
                </div>
            </div>

        </>
    )
}
