import React from 'react'
import { useState, useEffect } from 'react';
import useHttp from '../../hooks/useHttp';
import usePaginate from '../../hooks/usePaginate';
import BookingsListing from './BookingsListing'
import useAxiosIntercept from '../../hooks/useAxiosIntercept'
import Pagination from '../Customer/Pagination';
import BookingHeaders from './BookingHeaders';
import NoData from '../UI/NoData';
import Loading from '../UI/Loading';
export default function BookingsInfo() {
    const [hasMore, setHasMore] = useState(false);
    const axiosPrivate = useAxiosIntercept();
    const [bookingData, setbookingData] = useState("");

    const [isbookingCancelled, setisbookingCancelled] = useState(false)
    const [isSelected, setIsSelected] = useState(0);
    const [searchValue, setSearchValue] = useState("");
    const [bookingStatus, setbookingStatus] = useState(
    );
    const [singlebookingData, setsingleBookingData] = useState(0);
    const [total_records, setTotalRecords] = useState(0);
    const [isAttendantChanged, setisAttendantChanged] = useState(false);
    const [isPuppyChanged, setisPuppyChanged] = useState(false);
    const [isJobDone, setisjobDone] = useState(false);
    const [isCancelled, setisCancelled] = useState(false);
    const perpageLimit = 10;
    const [pageNumber, setPageNumber] = useState(1);
    const { isLoading, sendRequest: getbookings } = useHttp();
    const { lastElementRef } = usePaginate(isLoading, hasMore, setPageNumber);
    let url = process.env.REACT_APP_GET_BOOKING_HISTORY + `&is_active=1&limit=${perpageLimit}&page=${pageNumber}&show_puppy_info=1&show_driver_info=1`
    let request_body = {};
    let request_method = "post";
    if (bookingStatus !== "" && bookingStatus !== undefined) {
        request_body = {
            booking_statuses: bookingStatus
        };

    }

    if (searchValue !== "") {

        url = url + `&booking_id=${searchValue}`
    }

    useEffect(() => {
        if (searchValue !== "") {
            setIsSelected(0);
            setsingleBookingData(0);
        }

        const setBookings = (booking) => {

            const { data } = booking?.data?.response;
            if (data?.booking_records) {

                setbookingData((prev) => {
                    return [...new Set([...prev, ...data?.booking_records])]

                });
                setTotalRecords(data?.total)

            }
            else {


                setbookingData({})
            }

            if (data?.total == data?.booking_records?.length) {
                setHasMore(false);
            }
            else {
                setHasMore(booking?.data?.response?.data?.booking_records?.length > 0);
            }

        };

        if (pageNumber == 1 || (Math.ceil(total_records / perpageLimit) >= pageNumber)) {
            getbookings(
                {
                    url,
                    request_method,
                    request_body

                },
                setBookings

            );


        }


    }, [url, getbookings, pageNumber, searchValue, bookingStatus, isJobDone, isCancelled])

    return (
        <>



            <BookingHeaders isbookingCancelled={isbookingCancelled} isJobDone={isJobDone} />
            <BookingsListing bookingData={bookingData} setbookingData={setbookingData}
                searchValue={searchValue} setSearchValue={setSearchValue} setbookingStatus={setbookingStatus}
                singlebookingData={singlebookingData} setsingleBookingData={setsingleBookingData} isSelected={isSelected} setIsSelected={setIsSelected}
                isbookingCancelled={isbookingCancelled} setisbookingCancelled={setisbookingCancelled} isAttendantChanged={isAttendantChanged} isPuppyChanged={isPuppyChanged}
                setisAttendantChanged={setisAttendantChanged} setisPuppyChanged={setisPuppyChanged} isJobDone={isJobDone} setisjobDone={setisjobDone} lastElementRef={lastElementRef}
                setPageNumber={setPageNumber} isCancelled={isCancelled} setisCancelled={setisCancelled}
            />
            <div>{isLoading && pageNumber != "1" && <Loading />}</div>
            {pageNumber != "1" && pageNumber > Math.ceil(total_records / perpageLimit) && (<NoData />)}
        </>
    )
}
