import React from "react";
import { useState } from "react";
import SearchBar from "../UI/SearchBar/SearchBar";
import { Time } from "../../utils/Time";
import { FormatDate } from "../../utils/FormatDate";
import Pagination from "../Customer/Pagination";
import Image from "../UI/Image";
import { Link } from "react-router-dom";
import BookingDetails from "./BookingDetails";
import moment from "moment";
import { useRef } from "react";
import useOutsideClick from "../../hooks/useOutsideClick";
import loader from "../../assets/images/spinner.gif";
import Spinner from "../UI/Spinner";
import { puppy_assigned_duration } from "../../configuration/GlobalConfig";
import Button from "../UI/Button";
import DataNotFound from "../UI/DataNotFound";
import useAuth from "../../hooks/useAuth";

export default function BookingsListing({
  lastElementRef,
  bookingData,
  setbookingData,
  bookingCount,
  searchValue,
  setSearchValue,
  setbookingStatus,
  singlebookingData,
  setsingleBookingData,
  isSelected,
  setIsSelected,
  isbookingCancelled,
  setisbookingCancelled,
  isAttendantChanged,
  isPuppyChanged,
  setisAttendantChanged,
  setisPuppyChanged,
  isJobDone,
  setisjobDone,
  setPageNumber,
  isCancelled,
  setisCancelled,
}) {
  let currentDate = new Date();
  currentDate = moment(currentDate).format("D MMMM");
  const { auth } = useAuth();
  const bookingfilterRef = useRef();
  const [checkedOption, setcheckedOption] = useState("allbookings");
  const [selectedOption, setselectedOption] = useState(false);
  const [optionlabel, setOptionlabel] = useState();
  const handleClick = (e, index) => {
    setIsSelected(index);
    var singleBookingData = index;
    setsingleBookingData(singleBookingData);
  };
  const removeBooking = (booking_index) => {
    if (booking_index !== -1) {
      const currentbookingdetails = [...bookingData];
      currentbookingdetails.splice(booking_index, 1);
      setbookingData(currentbookingdetails);
    }
  };
  const [showfilterdropdown, setshowfilterdropdown] = useState(false);
  useOutsideClick(bookingfilterRef, () => {
    if (setshowfilterdropdown) {
      setshowfilterdropdown(false);
    }
  });
  const filterDropDown = () => {
    setshowfilterdropdown(!showfilterdropdown);
  };
  const selectedfilter = (e) => {
    setbookingData([]);
    setPageNumber(1);
    setsingleBookingData(0);
    setIsSelected(0);

    setcheckedOption(e.target.id);

    setshowfilterdropdown(false);
    setselectedOption(true);

    if (e.target.id == "inprogress") {
      setOptionlabel("Inprogress");
      setbookingStatus(["I"]);
    } else if (e.target.id == "puppyassigned") {
      setOptionlabel("Puppy Assigned");
      setbookingStatus(["A"]);
    } else if (e.target.id == "puppynotassigned") {
      setOptionlabel("Puppy Not Assigned");
      setbookingStatus(["N", "R"]);
    } else {
      setOptionlabel("All Bookings");
      setbookingStatus("");
    }
  };

  return (
    <>
      <div class="searchPanel mb-24">
        <SearchBar
          placeholder={"Search booking by ID"}
          setSearchValue={setSearchValue}
          searchValue={searchValue}
          setData={setbookingData}
          setPageNumber={setPageNumber}
        />
        {auth.priviliges.includes("write_bookings") && (
          <Button
            value="Make new booking"
            btn_link={"/bookings/makeNewBooking"}
          />
        )}
      </div>
      <div class="searchPanel mb-24 puppyFilter">
        <div
          class="multiOption"
          onClick={filterDropDown}
          ref={bookingfilterRef}
        >
          <div class={showfilterdropdown ? "selectBox open" : "selectBox"}>
            <p class="selected">
              {selectedOption ? optionlabel : "All Bookings"}{" "}
              <i class="material-symbols-rounded grey">expand_more</i>
            </p>
            <div class="selectDrop">
              <ul class="dropMenu">
                <li>
                  <Link
                    class="selected"
                    id="allbookings"
                    onClick={selectedfilter}
                  >
                    All bookings
                    {"allbookings" == checkedOption && (
                      <i class="material-symbols-rounded">done</i>
                    )}
                  </Link>
                </li>
                <li>
                  <Link selected id="inprogress" onClick={selectedfilter}>
                    Inprogress
                    {"inprogress" == checkedOption && (
                      <i class="material-symbols-rounded">done</i>
                    )}
                  </Link>
                </li>
                <li>
                  <Link id="puppyassigned" onClick={selectedfilter}>
                    Puppy assigned
                    {"puppyassigned" == checkedOption && (
                      <i class="material-symbols-rounded">done</i>
                    )}
                  </Link>
                </li>
                <li>
                  <Link id="puppynotassigned" onClick={selectedfilter}>
                    Puppy not assigned
                    {"puppynotassigned" == checkedOption && (
                      <i class="material-symbols-rounded">done</i>
                    )}
                  </Link>
                </li>
              </ul>
            </div>
          </div>
        </div>
      </div>

      {bookingData === "" ||
      bookingData === undefined ||
      bookingData?.length == "0" ? (
        <Spinner />
      ) : bookingData && Object.keys(bookingData).length != "0" ? (
        <>
          {bookingData && bookingData?.length > 0 ? (
            <>
              <div class="bookingsData">
                <div class="bTimings customScroll">
                  {bookingData && bookingData?.length !== 0 ? (
                    <>
                      {bookingData.map((bookingdata, i) => {
                        const firstname = bookingdata?.user_profile_data
                          ?.firstname
                          ? bookingdata?.user_profile_data?.firstname
                          : "Guest";
                        const lastname = bookingdata?.user_profile_data
                          ?.lastname
                          ? bookingdata?.user_profile_data?.lastname
                          : "";
                        const registration_no = bookingdata?.vehicle_info
                          ?.registration_no
                          ? bookingdata?.vehicle_info?.registration_no
                          : "N/A";
                        const time = Time(
                          bookingdata?.booking_info?.booking_slot
                        );
                        const date = bookingdata?.booking_info?.booking_slot
                          ? FormatDate(
                              bookingdata?.booking_info?.booking_slot
                            ).split(",")
                          : "";
                        const sub_note =
                          bookingdata?.booking_info?.booking_sub_note;
                        const puppy_status =
                          bookingdata?.booking_info?.puppy_status;
                        const driver_firstname = bookingdata?.driver_details
                          ? bookingdata?.driver_details?.firstname
                          : "N/A";
                        const driver_lastname = bookingdata?.driver_details
                          ? bookingdata?.driver_details?.lastname
                          : "N/A";
                        const driver_userid = bookingdata?.driver_details
                          ?.user_id
                          ? bookingdata?.driver_details?.user_id
                          : "";

                        const booking_status =
                          bookingdata?.booking_info?.booking_status;
                        const booking_status_desc =
                          bookingdata?.booking_info?.booking_status_desc;
                        const puppy_registration_no = bookingdata?.puppy_info
                          ? bookingdata?.puppy_info?.registration_no
                          : "N/A";
                        const puppy_assigned_time = moment(time, "h:mm A")
                          .subtract("hours", puppy_assigned_duration)
                          .format("h:mm A");
                        const booking_type =
                          bookingdata?.booking_info?.booking_type;
                        const vehicle_brand = bookingdata?.vehicle_info
                          ?.brand_name
                          ? bookingdata?.vehicle_info?.brand_name
                          : "";
                        const vehicle_model = bookingdata?.vehicle_info
                          ?.model_name
                          ? bookingdata?.vehicle_info?.model_name
                          : "";
                        const vehicle_battery_capacity = bookingdata
                          ?.vehicle_info?.vehicle_battery_capacity
                          ? bookingdata?.vehicle_info?.vehicle_battery_capacity
                          : "";
                        const address1 = bookingdata?.user_profile_data?.address
                          ? bookingdata?.user_profile_data?.address
                          : "";
                        const address2 = bookingData?.user_profile_data
                          ?.address_2
                          ? bookingData?.user_profile_data?.address_2
                          : "";
                        if (bookingData?.length === i + 1) {
                          return (
                            <div
                              key={i}
                              ref={lastElementRef}
                              id={i}
                              onClick={(e) => handleClick(e, i)}
                              class={
                                isSelected == i ? "boxT1 fill" : "boxT1 pending"
                              }
                            >
                              <h4>
                                <span>
                                  {currentDate == date[0] ? "Today" : date[0]}
                                </span>
                                <i class="elip"></i>
                                <span>{time}</span>
                              </h4>
                              <div className="rowList">
                                <p>
                                  <i class="material-symbols-rounded mt-m grey">
                                    person
                                  </i>
                                  <span>{firstname + " " + lastname}</span>
                                  <i class="elip"></i>
                                  <em>{registration_no}</em>
                                </p>

                                <p class="vDetail">
                                  <i class="material-symbols-rounded mt-m white">
                                    person
                                  </i>
                                  <em>{vehicle_brand + " " + vehicle_model}</em>
                                  <i class="elip"></i>
                                  <em>{vehicle_battery_capacity} kWh</em>
                                </p>
                                {address1 && (
                                  <p class="vDetail">
                                    <i class="material-symbols-rounded mt-m white">
                                      person
                                    </i>
                                    <em>{address1}</em>
                                  </p>
                                )}
                                {address2 && (
                                  <p class="vDetail">
                                    <i class="material-symbols-rounded mt-m white">
                                      person
                                    </i>
                                    <em>{address2}</em>
                                  </p>
                                )}
                              </div>

                              {(booking_status == "N" ||
                                booking_status == "R" ||
                                booking_status == "T") &&
                              driver_userid == "" ? (
                                <div className="rowList">
                                  <p class="assignName">
                                    <i class="material-symbols-rounded mt-m">
                                      airport_shuttle
                                    </i>
                                    <em>
                                      {"Puppy will be assigned by" +
                                        " " +
                                        puppy_assigned_time}
                                    </em>
                                  </p>
                                </div>
                              ) : (
                                <div className="rowList">
                                  <p class="assignName">
                                    <i class="material-symbols-rounded mt-m">
                                      airport_shuttle
                                    </i>
                                    <span>
                                      {driver_firstname + " " + driver_lastname}
                                    </span>
                                    <i class="elip"></i>
                                    <em>{puppy_registration_no}</em>
                                  </p>
                                  {(booking_status == "N" ||
                                    booking_status == "R" ||
                                    booking_status == "T") &&
                                    driver_userid && (
                                      <p class="vDetail">
                                        <i className="material-symbols-rounded mt-m white">
                                          airport_shuttle
                                        </i>
                                        <em>
                                          {"Final puppy will be assigned by" +
                                            " " +
                                            puppy_assigned_time}
                                        </em>
                                      </p>
                                    )}
                                  {/* <p class="vDetail">
                                  <i class="material-symbols-rounded mt-m white">person</i>
                                  <em>{puppy_brand + " " + puppy_model}</em>
                                  <i class="elip"></i>
                                  <em>66.5 kWh</em>
                                </p> */}
                                </div>
                              )}

                              <div class="tagsList">
                                {booking_type == "normal" && (
                                  <span
                                    class={
                                      isSelected == i ? "success" : "pending"
                                    }
                                  >
                                    {booking_status_desc}
                                  </span>
                                )}
                                {booking_type != "normal" && (
                                  <span class="error">Recovery insurance</span>
                                )}
                              </div>
                            </div>
                          );
                        } else {
                          return (
                            <div
                              key={i}
                              id={i}
                              onClick={(e) => handleClick(e, i)}
                              class={
                                isSelected == i ? "boxT1 fill" : "boxT1 pending"
                              }
                            >
                              <h4>
                                <span>
                                  {currentDate == date[0] ? "Today" : date[0]}
                                </span>
                                <i class="elip"></i>
                                <span>{time}</span>
                              </h4>
                              <div className="rowList">
                                <p>
                                  <i class="material-symbols-rounded mt-m grey">
                                    person
                                  </i>
                                  <span>{firstname + " " + lastname}</span>
                                  <i class="elip"></i>
                                  <em>{registration_no}</em>
                                </p>
                                {/* {(booking_status == "N" || booking_status == "R" || booking_status == "T") && driver_userid ? <> */}
                                <p class="vDetail">
                                  <i class="material-symbols-rounded mt-m white">
                                    person
                                  </i>
                                  <em>{vehicle_brand + " " + vehicle_model}</em>
                                  <i class="elip"></i>
                                  <em>{vehicle_battery_capacity} kWh</em>
                                </p>
                                {address1 && (
                                  <p class="vDetail">
                                    <i class="material-symbols-rounded mt-m white">
                                      person
                                    </i>
                                    <em>{address1}</em>
                                  </p>
                                )}
                                {address2 && (
                                  <p class="vDetail">
                                    <i class="material-symbols-rounded mt-m white">
                                      person
                                    </i>
                                    <em>{address2}</em>
                                  </p>
                                )}
                              </div>

                              {(booking_status == "N" ||
                                booking_status == "R" ||
                                booking_status == "T") &&
                              driver_userid == "" ? (
                                <div className="rowList">
                                  <p class="assignName">
                                    <i class="material-symbols-rounded mt-m">
                                      airport_shuttle
                                    </i>
                                    <em>
                                      {"Puppy will be assigned by" +
                                        " " +
                                        puppy_assigned_time}
                                    </em>
                                  </p>
                                </div>
                              ) : (
                                <div className="rowList">
                                  <p class="assignName">
                                    <i class="material-symbols-rounded mt-m">
                                      airport_shuttle
                                    </i>
                                    <span>
                                      {driver_firstname + " " + driver_lastname}
                                    </span>
                                    <i class="elip"></i>
                                    <em>{puppy_registration_no}</em>
                                  </p>
                                  {(booking_status == "N" ||
                                    booking_status == "R" ||
                                    booking_status == "T") &&
                                    driver_userid && (
                                      <p class="vDetail">
                                        <i className="material-symbols-rounded mt-m white">
                                          airport_shuttle
                                        </i>
                                        <em>
                                          {"Final puppy will be assigned by" +
                                            " " +
                                            puppy_assigned_time}
                                        </em>
                                      </p>
                                    )}
                                </div>
                              )}

                              <div class="tagsList">
                                {booking_type == "normal" && (
                                  <span
                                    class={
                                      isSelected == i ? "success" : "pending"
                                    }
                                  >
                                    {booking_status_desc}
                                  </span>
                                )}
                                {booking_type != "normal" && (
                                  <span class="error">Recovery insurance</span>
                                )}
                              </div>
                            </div>
                          );
                        }
                      })}
                    </>
                  ) : (
                    <></>
                  )}
                </div>

                {bookingData.length > 0 && (
                  <BookingDetails
                    allbookings={bookingData}
                    bookingData={bookingData[singlebookingData]}
                    setbookingData={setbookingData}
                    index={singlebookingData}
                    removeBooking={removeBooking}
                    setisbookingCancelled={setisbookingCancelled}
                    isAttendantChanged={isAttendantChanged}
                    setisAttendantChanged={setisAttendantChanged}
                    isPuppyChanged={isPuppyChanged}
                    setisPuppyChanged={setisPuppyChanged}
                    isJobDone={isJobDone}
                    setisjobDone={setisjobDone}
                    isCancelled={isCancelled}
                    setisCancelled={setisCancelled}
                  />
                )}
              </div>
            </>
          ) : (
            <></>
          )}
        </>
      ) : (
        <>
          <DataNotFound />
        </>
      )}
    </>
  );
}
