import React from 'react'
import Success from '../UI/Success';
import { useState } from 'react';
import Overlay from '../../utils/Overlay'
import moment from 'moment';
import { useRef } from 'react';
import useAxiosIntercept from '../../hooks/useAxiosIntercept';
import useOutsideClick from '../../hooks/useOutsideClick';
import Error from '../UI/Error';
export default function ChangeAttendant({ user_firstname, user_lastname, vehicle_registration_no, driver_firstname, driver_lastname,
  registration_no, date, time, attendantList, setchangeAttendantpopup, puppy_vehicle_id, driver_user_id, booking_slot, isAttendantChanged, setisAttendantChanged,
  bookingData, setbookingData, index,booking_id

}) {
  const axiosPrivate = useAxiosIntercept();
  const [showAttendantList, setshowAttendantList] = useState(false);
  const slot_date = moment(booking_slot).format("YYYY-MM-DD");
  const start_time = moment(booking_slot).format("HH:mm:ss");
  const [driverId, setdriverId] = useState("");
  const [labels, setLabels] = useState("");
  const attendantRef = useRef();
  const [errors, setErrors] = useState("");
  const [successMessage, setsuccessMessage] = useState("");
  const [enableSubmit, setEnableSubmit] = useState(true);
  const [err, seterr] = useState("");
  const [driverDetails, setDriverDetails] = useState({
    firstname: "",
    lastname: "",
    phone: "",
    image: ""
  })


  const submit = async () => {
    const body = {
      booking_id:booking_id,
      puppy_vehicle_id: puppy_vehicle_id,
      driver_user_id: driver_user_id,
      slot_date: slot_date,
      start_time: start_time,
      update_fields: {
        driver_user_id: driverId,
        puppy_vehicle_id: puppy_vehicle_id
      }

    }
    const URL = process.env.REACT_APP_CHANGE_ATTENDANT_AND_PUPPY
    if (driverId != "" && enableSubmit == true) {
      setEnableSubmit(false);
      const response = await axiosPrivate.post(URL, body);
      if (response?.data?.response?.errors?.length == "0") {
        const temp = [...bookingData];
        temp[index]["driver_details"]["firstname"] = driverDetails.firstname;
        temp[index]["driver_details"]["lastname"] = driverDetails.lastname;
        temp[index]["driver_details"]["phone_number"] = driverDetails.phone;
        temp[index]["driver_details"]["driver_image"] = driverDetails.image;
        temp[index]["driver_details"]["user_id"] = driverId;
        setbookingData(temp);
        setsuccessMessage("Attendant updated successfully");
        document.body.classList.remove('hidden');
        setisAttendantChanged(!isAttendantChanged);
        setTimeout(() => {

          closePopUp()
        }, 3000);


      }
      else {
        setErrors(response?.data?.response?.errors)

      }

    }
    else if(driverId==""&&enableSubmit==true) {
      seterr("Please select attendant")
    }




  }
  const closePopUp = () => {
    document.body.classList.remove('hidden');
    setchangeAttendantpopup(false);

  }
  useOutsideClick(attendantRef, () => {
    if (attendantList) {
      setshowAttendantList(false);

    }

  });
  const setDriverInfo = (e, firstname, lastname, phone, image) => {
    setErrors("")
    seterr("")
    setdriverId(e.target.id);
    const label_temp = firstname + " " + lastname
    setLabels(label_temp);
    setDriverDetails({
      firstname: firstname,
      lastname: lastname,
      phone: phone,
      image: image

    })
  }
  return (
    <>
      <Overlay>
        <div class="model_box_child cancelBookingP" id="changeAttendantP" style={{ width: "400px" }}>
          <div class="ap_heading">
            <h4>Change attendant<span class="material-symbols-rounded black close_model" onClick={closePopUp}>close</span></h4>
          </div>
          <div class="contentSection">
            <section class="assignPromoP dForm">
              <div class="boxT1 fill">
                <h4><span>{date[0]}</span><i class="elip"></i><span>{time}</span></h4>
                <p>
                  <i class="material-symbols-rounded mt-m grey">person</i>
                  <span>{user_firstname + " " + user_lastname}</span>
                  <i class="elip"></i>
                  <em>{vehicle_registration_no}</em>
                </p>
                <p class="assignName">
                  <i class="material-symbols-rounded mt-m">airport_shuttle</i>
                  <span>{driver_firstname + " " + driver_lastname}</span>
                  <i class="elip"></i>
                  <em>{registration_no}</em>
                </p>
              </div>
              <div class="fieldGroup">
                <label>Select attendant</label>
                <div class="multiOption" onClick={() => { setshowAttendantList(!showAttendantList) }} ref={attendantRef}>
                  <div class={showAttendantList ? "selectBox fullWidth open" : "selectBox fullWidth"}>
                    <p>{labels ? labels : "Select attendant"} <i class="material-symbols-rounded grey">expand_more</i></p>
                    <div class="selectDrop">
                      <ul class="dropMenu">
                        {attendantList && attendantList?.length > 0 && attendantList.map((attendant) => {
                          return (<>
                            <li >
                              <a id={attendant.user_id} onClick={(e) => { setDriverInfo(e, attendant.firstname, attendant.lastname, attendant.phone, attendant.user_image) }}>{attendant.firstname + " " + attendant.lastname}</a>
                            </li>
                          </>)


                        })}

                      </ul>
                    </div>
                  </div>
                </div>
              </div>
            </section>
            <div class="actionButtons mt-24">
              <span>
                <a class="btn prim fullW" onClick={submit}>Change attendant</a>
              </span>
              {errors && errors.map((err) => {
                return (<>
                  <Error error={err.error.message} />
                </>)

              })}
              {successMessage && <Success success={successMessage} />}
              {err && <Error error={err} />}
            </div>
          </div>
        </div>
      </Overlay>

    </>
  )
}