import React, { useReducer } from 'react'
import useAxiosIntercept from '../../hooks/useAxiosIntercept';
import moment from 'moment';
import { useState } from 'react';
import Overlay from '../../utils/Overlay'
import { useRef } from 'react';
import useOutsideClick from '../../hooks/useOutsideClick';
import Error from '../UI/Error';
import Success from '../UI/Success';
export default function ChangePuppy({ user_firstname, user_lastname, vehicle_registration_no, driver_firstname, driver_lastname,
  registration_no, date, time, setchangePuppyPopup, puppyList, puppy_vehicle_id, driver_user_id, booking_slot, isPuppyChanged, setisPuppyChanged, bookingData, setbookingData, index,booking_id
}) {
  const axiosPrivate = useAxiosIntercept();
  const [showPuppyList, setshowPuppyList] = useState(false);
  const slot_date = moment(booking_slot).format("YYYY-MM-DD");
  const start_time = moment(booking_slot).format("HH:mm:ss");
  const [puppyId, setpuppyId] = useState("");
  const puppyRef = useRef();
  const [labels, setLabels] = useState("");
  const [errors, setErrors] = useState("");
  const [successMessage, setsuccessMessage] = useState("");
  const [batterycapacity, setbatterycapacity] = useState("");
  const [batteryPercentage, setbatteryPercentage] = useState("");
  const [enableSubmit, setEnableSubmit] = useState(true);
  const [err, seterr] = useState("")
  const closePopUp = () => {
    document.body.classList.remove('hidden');
    setchangePuppyPopup(false);

  }
  const submit = async () => {
    const body = {
      booking_id:booking_id,
      puppy_vehicle_id: puppy_vehicle_id,
      driver_user_id: driver_user_id,
      slot_date: slot_date,
      start_time: start_time,
      update_fields: {
        puppy_vehicle_id: puppyId,
        driver_user_id: driver_user_id
      }

    }
    const URL = process.env.REACT_APP_CHANGE_ATTENDANT_AND_PUPPY;
    if (puppyId != "" && enableSubmit == true) {
      setEnableSubmit(false);
      const response = await axiosPrivate.post(URL, body);

      if (response?.data?.response?.errors?.length == "0") {

        const temp = [...bookingData];
        temp[index]["puppy_info"]["registration_no"] = labels;
        temp[index]["puppy_info"]["charger_info"]["available_charging_capacity"] = batterycapacity;
        temp[index]["puppy_info"]["charger_info"]["battery_percentage"] = batteryPercentage;
        temp[index]["puppy_info"]["vehicle_id"] = puppyId

        setbookingData(temp);
        document.body.classList.remove('hidden');
        setisPuppyChanged(!isPuppyChanged);
        setsuccessMessage("Puppy updated successfully")
        setTimeout(() => {
          //setSuccess(!success);
          closePopUp()
        }, 3000);


      }
      else {
        setErrors(response?.data?.response?.errors)

      }

    }
    else if (puppyId==""&&enableSubmit==true) {
      seterr("Please select puppy")
    }


  }
  useOutsideClick(puppyRef, () => {
    if (showPuppyList) {
      setshowPuppyList(false);

    }

  });
  const setPuppyInfo = (e, reg_no, batterycapacity, batterypercentage) => {
    seterr("")
    setErrors("")
    setpuppyId(e.target.id);
    setLabels(reg_no);

    setbatterycapacity(batterycapacity);
    setbatteryPercentage(batterypercentage);

  }
  return (
    <>



      <Overlay>
        <div class="model_box_child cancelBookingP" id="changePuppyP" style={{ width: "400px" }}>
          <div class="ap_heading">
            <h4>Change puppy<span class="material-symbols-rounded black close_model" onClick={closePopUp}>close</span></h4>
          </div>
          <div class="contentSection">
            <section class="assignPromoP dForm">
              <div class="boxT1 fill">
                <h4><span>{date[0]}</span><i class="elip"></i><span>{time}</span></h4>
                <p>
                  <i class="material-symbols-rounded mt-m grey">person</i>
                  <span>{user_firstname + " " + user_lastname}</span>
                  <i class="elip"></i>
                  <em>{vehicle_registration_no}</em>
                </p>
                <p class="assignName">
                  <i class="material-symbols-rounded mt-m">airport_shuttle</i>
                  <span>{driver_firstname + " " + driver_lastname}</span>
                  <i class="elip"></i>
                  <em>{registration_no}</em>
                </p>
              </div>
              <div class="fieldGroup">
                <label>Select puppy</label>
                <div class="multiOption" onClick={() => { setshowPuppyList(!showPuppyList) }} ref={puppyRef}>
                  <div class={showPuppyList ? "selectBox fullWidth open" : "selectBox fullWidth"}>
                    <p>{labels ? labels : "Select puppy"} <i class="material-symbols-rounded grey">expand_more</i></p>
                    <div class="selectDrop">
                      <ul class="dropMenu">
                        {puppyList && puppyList?.length > 0 && puppyList.map((puppy) => {

                          return (<>
                            <li >
                              <a id={puppy.vehicle_id} onClick={(e) => { setPuppyInfo(e, puppy.registration_no, puppy?.charger_info?.available_charging_capacity, puppy?.charger_info?.battery_percentage) }}>{puppy.registration_no}</a>
                            </li>
                          </>)
                        })}

                      </ul>
                    </div>
                  </div>
                </div>
              </div>
            </section>
            <div class="actionButtons mt-24">
              <span>
                <a class="btn prim fullW" onClick={submit}>Change puppy</a>
              </span>
              {errors && errors.map((err) => {
                return (<>
                  <Error error={err.error.message} />
                </>)

              })}
              {successMessage && <Success success={successMessage} />}
              {err && <Error error={err} />}
            </div>
          </div>
        </div>

      </Overlay>

    </>
  )
}