import React, { useEffect } from "react";
import { useState } from "react";
import Error from "../UI/Error";
import Success from "../UI/Success";
import Overlay from "../../utils/Overlay";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import Spinner from "../UI/Spinner";
export default function JobDonePopUp({
  date,
  time,
  user_firstname,
  user_lastname,
  vehicle_registration_no,
  driver_firstname,
  driver_lastname,
  registration_no,
  addonList,
  total_addons,
  setShowJobDonePopup,
  booking_id,
  user_id,
  isJobDone,
  setisjobDone,
  vehicle_battery_capacity,
  removeBooking,
  index,
}) {
  const axiosPrivate = useAxiosIntercept();
  const [isSubmit, setisSubmit] = useState(false);
  let isValidate = true;
  let userName = "";
  userName = user_firstname ? userName + " " + user_firstname : "";
  userName = user_lastname ? userName + " " + user_lastname : userName;

  let driverName = "";
  driverName = driver_firstname ? driverName + " " + driver_firstname : "";
  driverName = driver_lastname
    ? driverName + " " + driver_lastname
    : driverName;
  const [successMessage, setsuccessMessage] = useState("");
  const [errorMessage, seterrorMessage] = useState("");
  const allserviceids =
    total_addons &&
    total_addons.length > 0 &&
    total_addons.map((addon) => {
      return addon.service_id;
    });
  const requestAddons = [];
  const [isChecked, setisChecked] = useState(false);
  const closepopUP = () => {
    setShowJobDonePopup(false);
    document.body.classList.remove("hidden");
  };
  const [data, setData] = useState({
    initial_charge: "",
    final_charge: "",
    total_charge_kwh: "",
    parking_fee: "",
  });
  const [errors, setErrors] = useState({
    initial_charge_error: "",
    final_charge_error: "",
    total_charge_error: "",
    parking_fee_error: "",
  });
  const validations = () => {
    const regex = /^[0-9]\d*(\.\d+)?$/;
    if (data.initial_charge == " " || !regex.test(data.initial_charge)) {
      setErrors((prev) => {
        return {
          ...prev,
          initial_charge_error: "Enter a valid value",
        };
      });
      isValidate = false;
    } else {
      setErrors((prev) => {
        return {
          ...prev,
          initial_charge_error: "",
        };
      });
    }
    if (data.final_charge == "" || !regex.test(data.final_charge)) {
      setErrors((prev) => {
        return {
          ...prev,
          final_charge_error: "Enter a valid value",
        };
      });
      isValidate = false;
    } else {
      setErrors((prev) => {
        return {
          ...prev,
          final_charge_error: "",
        };
      });
    }
    if (data.total_charge_kwh == "" || !regex.test(data.total_charge_kwh)) {
      setErrors((prev) => {
        return {
          ...prev,
          total_charge_error: "Enter a valid value",
        };
      });
      isValidate = false;
    } else {
      if (
        parseFloat(data.total_charge_kwh) > parseFloat(vehicle_battery_capacity)
      ) {
        setErrors((prev) => {
          return {
            ...prev,
            total_charge_error: `Energy can't be more than total charging capacity of vehicle (${vehicle_battery_capacity} kWh)`,
          };
        });
        isValidate = false;
      } else {
        setErrors((prev) => {
          return {
            ...prev,
            total_charge_error: "",
          };
        });
      }
    }
    if (data.parking_fee == "" || !regex.test(data.parking_fee)) {
      setErrors((prev) => {
        return {
          ...prev,
          parking_fee_error: "Enter a valid value",
        };
      });
      isValidate = false;
    } else {
      setErrors((prev) => {
        return {
          ...prev,
          parking_fee_error: "",
        };
      });
    }
  };
  const submit = async () => {
    for (let i = 0; i < addonList?.length; i++) {
      if (isChecked[i] == true) {
        requestAddons.push(addonList[i].service_id);
      }
    }
    validations();
    const URL = process.env.REACT_APP_MARK_JOB_DONE;
    let request = {};
    if (requestAddons?.length > 0) {
      request = {
        booking_id: booking_id,
        customer_user_id: user_id,
        booking_add_ons: requestAddons,
        initial_battery_charge: data.initial_charge,
        final_battery_charge: data.final_charge,
        total_charge_kwh: data.total_charge_kwh,
        parking_fee: data.parking_fee,
      };
    } else {
      request = {
        booking_id: booking_id,
        customer_user_id: user_id,
        initial_battery_charge: data.initial_charge,
        final_battery_charge: data.final_charge,
        total_charge_kwh: data.total_charge_kwh,
        parking_fee: data.parking_fee,
      };
    }
    if (isValidate == true) {
      setisSubmit(true);
      const response = await axiosPrivate.post(URL, request);
      if (response?.data?.status == "200") {
        setisSubmit(false);
        setsuccessMessage("Job done successfully");
        setTimeout(() => {
          setShowJobDonePopup(false);
          document.body.classList.remove("hidden");
          setisjobDone(!isJobDone);
          removeBooking(index);
        }, 3000);
      } else {
        setisSubmit(false);
        seterrorMessage(response?.data?.message);
      }
    }
  };
  const handleCheckbox = (index) => {
    setisChecked({ ...isChecked, [index]: !isChecked[index] });
  };
  useEffect(() => {
    const ids = [];
    addonList &&
      addonList?.length > 0 &&
      addonList?.map((addon, i) => {
        ids.push(addon?.service_id);
      });
    ids &&
      ids?.length > 0 &&
      ids?.map((addon, index) => {
        if (allserviceids.includes(addon)) {
          setisChecked((prev) => ({ ...prev, [index]: true }));
        } else {
          setisChecked((prev) => ({ ...prev, [index]: false }));
        }
      });
  }, []);
  return (
    <>
      <Overlay>
        <div
          class="model_box_child cancelBookingP jobDoneP"
          id="jobDoneP"
          style={{ width: "520px" }}
        >
          <div class="ap_heading">
            <h4>
              Mark job as completed
              <span
                class="material-symbols-rounded black close_model"
                onClick={closepopUP}
              >
                close
              </span>
            </h4>
          </div>
          <div class="contentSection">
            <section class="assignPromoP">
              <div class="boxT1 fill">
                <h4>
                  <span>{date[0]}</span>
                  <i class="elip"></i>
                  <span>{time}</span>
                </h4>
                <p>
                  <i class="material-symbols-rounded mt-m grey">person</i>
                  <span>{userName}</span>
                  <i class="elip"></i>
                  <em>{vehicle_registration_no}</em>
                </p>
                <p class="assignName">
                  <i class="material-symbols-rounded mt-m">airport_shuttle</i>
                  <span>{driverName}</span>
                  <i class="elip"></i>
                  <em>{registration_no}</em>
                </p>
              </div>
            </section>
            <div class="dForm xRow mt-24">
              <div>
                <div class="fieldGroup mt-0">
                  <label>Initial charge %</label>
                  <div class="multiOption">
                    <input
                      type="number"
                      placeholder="Enter initial charge"
                      name=""
                      onChange={(e) => {
                        setData({ ...data, initial_charge: e.target.value });
                        setErrors({ ...errors, initial_charge_error: "" });
                        seterrorMessage("");
                      }}
                      value={data.initial_charge}
                    />
                    <div class="sepText bg">
                      <span>%</span>
                    </div>
                  </div>
                  {errors.initial_charge_error && (
                    <Error error={errors.initial_charge_error} />
                  )}
                </div>
                <div class="fieldGroup">
                  <label>Final charge %</label>
                  <div class="multiOption">
                    <input
                      type="number"
                      placeholder="Enter final charge"
                      name=""
                      onChange={(e) => {
                        setData({ ...data, final_charge: e.target.value });
                        setErrors({ ...errors, final_charge_error: "" });
                        seterrorMessage("");
                      }}
                      value={data.final_charge}
                    />
                    <div class="sepText bg">
                      <span>%</span>
                    </div>
                  </div>
                  {errors.final_charge_error && (
                    <Error error={errors.final_charge_error} />
                  )}
                </div>
                <div class="fieldGroup">
                  <label>Total charge kWH</label>
                  <div class="multiOption">
                    <input
                      type="number"
                      placeholder="Enter total charge"
                      name=""
                      onChange={(e) => {
                        setData({ ...data, total_charge_kwh: e.target.value });
                        setErrors({ ...errors, total_charge_error: "" });
                        seterrorMessage("");
                      }}
                      value={data.total_charge_kwh}
                    />
                    <div class="sepText bg">
                      <span>kWH</span>
                    </div>
                  </div>
                  {errors.total_charge_error && (
                    <Error error={errors.total_charge_error} />
                  )}
                </div>
                <div class="fieldGroup">
                  <label>Parking fee</label>
                  <div class="multiOption">
                    <input
                      type="number"
                      placeholder="Enter parking fee charge"
                      name=""
                      onChange={(e) => {
                        setData({ ...data, parking_fee: e.target.value });
                        setErrors({ ...errors, parking_fee_error: "" });
                        seterrorMessage("");
                      }}
                      value={data.parking_fee}
                    />
                    <div class="sepText bg">
                      <span>$</span>
                    </div>
                  </div>
                  {errors.parking_fee_error && (
                    <Error error={errors.parking_fee_error} />
                  )}
                </div>
              </div>
              <div class="ml-24">
                {addonList && addonList?.length > 0 && (
                  <div class="fieldGroup mt-0">
                    <label>Upsell</label>
                    <ul class="yType">
                      {addonList &&
                        addonList?.length > 0 &&
                        addonList.map((addons, index) => {
                          let price = parseInt(addons.service_charge);
                          price = price == "0" ? "Free" : "$" + price;

                          return (
                            <>
                              {/* {allserviceids.includes(addons.service_id) ? "yess" : "noo"} */}
                              <li>
                                <input
                                  type="checkbox"
                                  id={addons.service_id}
                                  name={addons.service_id}
                                  checked={isChecked[index] ? "checked" : ""}
                                  onClick={() => {
                                    handleCheckbox(index);
                                  }}
                                />
                                <label for={addons.service_id}>
                                  {addons.service_name} ({price})
                                </label>
                              </li>
                            </>
                          );
                        })}
                    </ul>
                  </div>
                )}
              </div>
            </div>
            {isSubmit ? (
              <Spinner />
            ) : (
              <div class="actionButtons mt-24">
                <span>
                  <a class="btn prim" onClick={submit}>
                    Mark job as completed
                  </a>
                </span>
                {errorMessage && <Error error={errorMessage} />}
                {successMessage && <Success success={successMessage} />}
              </div>
            )}
          </div>
        </div>
      </Overlay>
    </>
  );
}
