import React, { useEffect } from "react";
import { useState } from "react";
import Error from "../UI/Error";
import Success from "../UI/Success";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import Spinner from "../UI/Spinner";
export default function JobDonePopUpRecoveryFirstStep({
  setPage,
  addonList,
  booking_id,
  user_id,
  bookingData,
  setRequest,
}) {
  const mobileChargingRecoveryId =
    process.env.REACT_APP_MOBILE_CHARGING_SERVICE_ID;
  const vehicle_battery_capacity =
    bookingData?.vehicle_info?.vehicle_battery_capacity;
  const total_addons = bookingData?.booking_add_ons
    ? bookingData?.booking_add_ons
    : "";
  const [showAddonChild, setShowAddonChild] = useState({});
  const axiosPrivate = useAxiosIntercept();
  const [isSubmit, setisSubmit] = useState(false);
  const [finalAddonsData, setFinalAddonsData] = useState([]);
  const [addonPriceRequired, setAddonPriceRequired] = useState({});
  const [isValidInfo, setIsValidInfo] = useState(false);
  const [showSecondSte, setShowSecondStep] = useState(true);
  let isValidate = true;

  const [successMessage, setsuccessMessage] = useState("");
  const [errorMessage, seterrorMessage] = useState("");
  const allserviceids =
    total_addons &&
    total_addons.length > 0 &&
    total_addons.map((addon) => {
      return addon.service_id;
    });
  const requestAddons = [];
  const [isChecked, setisChecked] = useState(false);
  const [mobileChargingRecoveryData, setmobileChargingRecoveryData] = useState({
    initial_charge: "",
    final_charge: "",
    total_charge_kwh: "",
    parking_fee: "",
  });
  const [errors, setErrors] = useState({
    initial_charge_error: "",
    final_charge_error: "",
    total_charge_error: "",
    parking_fee_error: "",
  });
  const validations = () => {
    const regex = /^[0-9]\d*(\.\d+)?$/;
    if (selectedAddon[mobileChargingRecoveryId] == true) {
      if (
        mobileChargingRecoveryData.initial_charge == " " ||
        !regex.test(mobileChargingRecoveryData.initial_charge)
      ) {
        setErrors((prev) => {
          return {
            ...prev,
            initial_charge_error: "Enter a valid value",
          };
        });
        isValidate = false;
      } else {
        setErrors((prev) => {
          return {
            ...prev,
            initial_charge_error: "",
          };
        });
      }
      if (
        mobileChargingRecoveryData.final_charge == "" ||
        !regex.test(mobileChargingRecoveryData.final_charge)
      ) {
        setErrors((prev) => {
          return {
            ...prev,
            final_charge_error: "Enter a valid value",
          };
        });
        isValidate = false;
      } else {
        setErrors((prev) => {
          return {
            ...prev,
            final_charge_error: "",
          };
        });
      }
      if (
        mobileChargingRecoveryData.total_charge_kwh == "" ||
        !regex.test(mobileChargingRecoveryData.total_charge_kwh)
      ) {
        setErrors((prev) => {
          return {
            ...prev,
            total_charge_error: "Enter a valid value",
          };
        });
        isValidate = false;
      } else {
        if (
          parseFloat(mobileChargingRecoveryData.total_charge_kwh) >
          parseFloat(vehicle_battery_capacity)
        ) {
          setErrors((prev) => {
            return {
              ...prev,
              total_charge_error: `Energy can't be more than total charging capacity of vehicle (${vehicle_battery_capacity} kWh)`,
            };
          });
          isValidate = false;
        } else {
          setErrors((prev) => {
            return {
              ...prev,
              total_charge_error: "",
            };
          });
        }
      }
    }

    const validateaddonPrice = (priceValue, id) => {
      let isValidPrice = true;
      if (priceValue == "" || priceValue == undefined) {
        setAddonPriceData((prev) => {
          return {
            ...prev,
            [id]: { ...addonPriceData[id], error: "Please enter price" },
          };
        });
        isValidPrice = false;
      } else if (priceValue <= 0) {
        setAddonPriceData((prev) => {
          return {
            ...prev,
            [id]: {
              ...addonPriceData[id],
              error: "Price must be greater then 0 ",
            },
          };
        });
        isValidPrice = false;
      }
      return isValidPrice;
    };

    Object.keys(addonPriceData).map((addonid) => {
      return (
        <>
          {selectedAddon[addonid] == true ? (
            Object.entries(addonPriceData).map((data) => {
              if (
                data[1].price == "" ||
                data[1].price == undefined ||
                data[1].price <= 0
              ) {
                selectedAddon[data[0]] == true &&
                  (isValidate = validateaddonPrice(
                    data[1].price != undefined ? data[1].price : undefined,
                    data[0]
                  ));
              }
            })
          ) : (
            <></>
          )}
        </>
      );
    });

    if (
      mobileChargingRecoveryData.parking_fee == "" ||
      !regex.test(mobileChargingRecoveryData.parking_fee)
    ) {
      setErrors((prev) => {
        return {
          ...prev,
          parking_fee_error: "Enter a valid value",
        };
      });
      isValidate = false;
    } else {
      setErrors((prev) => {
        return {
          ...prev,
          parking_fee_error: "",
        };
      });
    }
  };
  const submit = async () => {
    let priceDataObject = {};
    addonPriceData &&
      Object.entries(addonPriceData).map((pricedata) => {
        return pricedata[1].price
          ? (priceDataObject = {
              ...priceDataObject,
              [pricedata[0]]: pricedata[1].price,
            })
          : {};
      });

    for (const key in selectedAddon) {
      if (selectedAddon[key] === true) {
        requestAddons.push(parseInt(key)); // Convert key to integer if needed
      }
    }
    validations();
    const URL = process.env.REACT_APP_MARK_JOB_DONE;
    let request = {};
    if (requestAddons?.length > 0) {
      request = {
        booking_id: booking_id,
        customer_user_id: user_id,
        booking_add_ons: requestAddons,
        initial_battery_charge: mobileChargingRecoveryData.initial_charge,
        final_battery_charge: mobileChargingRecoveryData.final_charge,
        total_charge_kwh: mobileChargingRecoveryData.total_charge_kwh,
        parking_fee: mobileChargingRecoveryData.parking_fee,
        add_on_extra_charges: priceDataObject,
        action: "services",
      };
    } else {
      request = {
        booking_id: booking_id,
        customer_user_id: user_id,
        initial_battery_charge: mobileChargingRecoveryData.initial_charge,
        final_battery_charge: mobileChargingRecoveryData.final_charge,
        total_charge_kwh: mobileChargingRecoveryData.total_charge_kwh,
        parking_fee: mobileChargingRecoveryData.parking_fee,
        add_on_extra_charges: priceDataObject,
        action: "services",
      };
    }
    if (request) {
      Object.keys(request).forEach((key) => {
        if (
          request[key] === "" ||
          (typeof request[key] === "object" &&
            Object.keys(request[key]).length === 0)
        ) {
          delete request[key];
        }
      });
    }
    if (isValidate == true) {
      setIsValidInfo(true);
      setisSubmit(true);
      // const response = null;
      const response = await axiosPrivate.post(URL, request);
      try {
        if (response?.data?.status == "200") {
          setRequest(request);
          setisSubmit(false);
          setsuccessMessage("Job done successfully");
          setTimeout(() => {
            setPage(1);
          }, 1000);
        } else {
          setisSubmit(false);
          seterrorMessage(response?.data?.message);
        }
      } catch (error) {
        console.log(error);
      }
    }
  };
  const handleCheckbox = (index) => {
    setisChecked({ ...isChecked, [index]: !isChecked[index] });
  };
  const manipulateAddonsList = (addonList) => {
    const addonsArray = [];

    addonList.forEach((addonData) => {
      if (allserviceids.includes(addonData.service_id)) {
        setShowAddonChild((prev) => {
          return {
            ...prev,
            [addonData.service_name]: true,
          };
        });
        setSelectedAddon((prev) => {
          return {
            ...prev,
            [addonData.service_id]: true,
          };
        });
      }
      if (addonData.parent_id === "0") {
        addonsArray.push({ ...addonData, children: [] });
      } else {
        const parentIndex = addonsArray.findIndex(
          (addon) => addon.service_id === addonData.parent_id
        );
        if (parentIndex !== -1) {
          addonsArray[parentIndex].children.push({ ...addonData });
        }
      }
    });

    return addonsArray;
  };

  useEffect(() => {
    const ids = [];
    addonList &&
      addonList?.length > 0 &&
      addonList?.map((addon, i) => {
        ids.push(addon?.service_id);
      });
    setFinalAddonsData(manipulateAddonsList(addonList));
    ids &&
      ids?.length > 0 &&
      ids?.map((addon, index) => {
        if (allserviceids.includes(addon)) {
          setisChecked((prev) => ({ ...prev, [index]: true }));
        } else {
          setisChecked((prev) => ({ ...prev, [index]: false }));
        }
      });
  }, []);
  const [addonsInfo, setAddonsInfo] = useState({
    addonName: "",
    addonId: "",
  });
  const [addonPriceData, setAddonPriceData] = useState([]);
  const handleAddonPrice = (e, priceData) => {
    const addonInfoObject = {
      id: "",
      name: "",
      addonchecked: "",
    };

    setAddonPriceData((prev) => {
      return {
        ...prev,
        [priceData.service_id]: {
          id: priceData.service_id,
          price: e.target.value,
        },
      };
    });
  };
  const [selectedAddon, setSelectedAddon] = useState({});
  const handleAddon = (e, addondata) => {
    if (addondata.is_price_required == "1") {
      setAddonPriceRequired((prev) => {
        return {
          ...prev,
          [addondata.service_id]: true,
        };
      });
      setAddonPriceData((prev) => {
        return {
          ...prev,
          [addondata.service_id]: {
            id: addondata.service_id,
            name: addondata.service_name,
          },
        };
      });
    }
    setSelectedAddon((prev) => {
      return {
        ...prev,
        [addondata.service_id]: !selectedAddon[addondata.service_id],
      };
    });
    setAddonsInfo((prev) => {
      return {
        addonName: addondata.service_name,
        addonId: addondata.service_id,
      };
    });
    let updatedChildValue = showAddonChild[addondata.service_name]
      ? false
      : true;
    let mobileChargingRecoverySelected = showAddonChild[addondata.service_name]
      ? false
      : true;
    setShowAddonChild((prev) => {
      return {
        ...prev,
        [addondata.service_name]: !showAddonChild[addondata.service_name],
      };
    });
    if (addondata.children.length > 0 && updatedChildValue == false) {
      addondata.children.map((child) => {
        setShowAddonChild((prev) => {
          return {
            ...prev,
            [child.service_name]: false,
          };
        });
        setSelectedAddon((prev) => {
          return {
            ...prev,
            [child.service_id]: false,
          };
        });
        child.is_price_required == "1" &&
          setAddonPriceData((prev) => {
            return {
              ...prev,
              [child.service_id]: {},
            };
          });
      });
    }
    if (
      addondata.service_id == mobileChargingRecoveryId &&
      mobileChargingRecoverySelected == false
    ) {
      setmobileChargingRecoveryData((prev) => {
        return {
          ...prev,
          initial_charge: "",
          final_charge: "",
          total_charge_kwh: "",
        };
      });
      setErrors((prev) => {
        return {
          ...prev,
          initial_charge_error: "",
          final_charge_error: "",
          total_charge_error: "",
        };
      });
    }
  };
  return (
    <>
      <div class="xRow mt-24">
        <div>
          <h5 class="mb-8">Services</h5>
          <ul class="yType mb-16 servicesList  ">
            {finalAddonsData &&
              finalAddonsData.length > 0 &&
              finalAddonsData.map((data) => {
                return (
                  <li>
                    <input
                      type="checkbox"
                      id={data.service_id}
                      name="sercheckbox"
                      checked={
                        showAddonChild[data.service_name] == true && true
                      }
                    />
                    <label
                      for={data.service_id}
                      onClick={(e) => handleAddon(e, data)}
                    >
                      {data.service_name}
                    </label>
                    {showAddonChild["Mobile charging recovery"] == true &&
                      data.service_id == mobileChargingRecoveryId && (
                        <div class="subdet">
                          <div class="xType gap16 mt-16">
                            <div class="fieldGroup mt-0">
                              <label class="sm">Initial charge %</label>

                              <div class="multiOption">
                                <input
                                  type="number"
                                  placeholder="Enter initial charge"
                                  name=""
                                  onChange={(e) => {
                                    setmobileChargingRecoveryData({
                                      ...mobileChargingRecoveryData,
                                      initial_charge: e.target.value,
                                    });
                                    setErrors({
                                      ...errors,
                                      initial_charge_error: "",
                                    });
                                    seterrorMessage("");
                                  }}
                                  value={
                                    mobileChargingRecoveryData.initial_charge
                                  }
                                />
                                <div class="sepText bg">
                                  <span>%</span>
                                </div>
                              </div>
                              {errors.initial_charge_error && (
                                <Error error={errors.initial_charge_error} />
                              )}
                            </div>

                            <div class="fieldGroup">
                              <label class="sm">Final charge %</label>
                              <div class="multiOption">
                                <input
                                  type="number"
                                  placeholder="Enter final charge"
                                  name=""
                                  onChange={(e) => {
                                    setmobileChargingRecoveryData({
                                      ...mobileChargingRecoveryData,
                                      final_charge: e.target.value,
                                    });
                                    setErrors({
                                      ...errors,
                                      final_charge_error: "",
                                    });
                                    seterrorMessage("");
                                  }}
                                  value={
                                    mobileChargingRecoveryData.final_charge
                                  }
                                />
                                <div class="sepText bg">
                                  <span>%</span>
                                </div>
                              </div>
                              {errors.final_charge_error && (
                                <Error error={errors.final_charge_error} />
                              )}
                            </div>
                            <div class="fieldGroup">
                              <label class="sm">Total charge kWH</label>
                              <div class="multiOption">
                                <input
                                  type="number"
                                  placeholder="Enter total charge"
                                  name=""
                                  onChange={(e) => {
                                    setmobileChargingRecoveryData({
                                      ...mobileChargingRecoveryData,
                                      total_charge_kwh: e.target.value,
                                    });
                                    setErrors({
                                      ...errors,
                                      total_charge_error: "",
                                    });
                                    seterrorMessage("");
                                  }}
                                  value={
                                    mobileChargingRecoveryData.total_charge_kwh
                                  }
                                />
                                <div class="sepText bg">
                                  <span>kWH</span>
                                </div>
                              </div>
                              {errors.total_charge_error && (
                                <Error error={errors.total_charge_error} />
                              )}
                            </div>
                          </div>
                        </div>
                      )}
                    {showAddonChild[data.service_name] &&
                      data.children &&
                      data.children.length > 0 &&
                      data.children.map((addonChildData) => {
                        return (
                          <div class="subdet">
                            <div class="xType gap16 mt-16">
                              <div class="fieldGroup mt-0">
                                <div>
                                  <input
                                    type="checkbox"
                                    id={addonChildData.service_id}
                                    checked={
                                      showAddonChild[
                                        addonChildData.service_name
                                      ] == true && true
                                    }
                                    name="sercheckbox"
                                  />
                                  <label
                                    for={addonChildData.service_id}
                                    onClick={(e) =>
                                      handleAddon(e, addonChildData)
                                    }
                                  >
                                    {addonChildData.service_name}
                                  </label>
                                </div>

                                {showAddonChild[addonChildData.service_name] ==
                                  true &&
                                  addonPriceRequired[
                                    addonChildData.service_id
                                  ] == true && (
                                    <div class="multiOption">
                                      <input
                                        type="number"
                                        placeholder="Enter charge"
                                        name=""
                                        onChange={(e) =>
                                          handleAddonPrice(e, addonChildData)
                                        }
                                      />

                                      <div class="sepText bg">
                                        <span>$</span>
                                      </div>
                                    </div>
                                  )}
                                {addonPriceData &&
                                  addonPriceData[addonChildData.service_id] !=
                                    undefined &&
                                  addonPriceData[addonChildData.service_id]
                                    .error != undefined && (
                                    <Error
                                      error={
                                        addonPriceData[
                                          addonChildData.service_id
                                        ].error
                                      }
                                    />
                                  )}
                              </div>
                            </div>
                          </div>
                        );
                      })}
                  </li>
                );
              })}
          </ul>
        </div>
      </div>

      <div class="inlineFlex">
        <div class="fieldGroup">
          <label>Parking fee</label>
          <div class="multiOption">
            <input
              type="number"
              placeholder="Enter parking fee charge"
              name=""
              onChange={(e) => {
                setmobileChargingRecoveryData({
                  ...mobileChargingRecoveryData,
                  parking_fee: e.target.value,
                });
                setErrors({ ...errors, parking_fee_error: "" });
                seterrorMessage("");
              }}
              value={mobileChargingRecoveryData.parking_fee}
            />
            <div class="sepText bg">
              <span>$</span>
            </div>
          </div>
          {errors.parking_fee_error && (
            <Error error={errors.parking_fee_error} />
          )}
        </div>
      </div>

      {isSubmit ? (
        <Spinner />
      ) : (
        <div class="actionButtons mt-24">
          <span>
            <a class="btn prim" onClick={submit}>
              Next
            </a>
          </span>
          {errorMessage && <Error error={errorMessage} />}
          {successMessage && <Success success={successMessage} />}
        </div>
      )}
      {/* </div> */}
      {/* </div> */}
      {/* </Overlay> */}
    </>
  );
}
