import React from "react";
import Overlay from "../../utils/Overlay";
import { useEffect } from "react";
import { axiosPrivate } from "../../api/PrivateRequestServices";
import { useState } from "react";
import Error from "../UI/Error";
import Spinner from "../UI/Spinner";
import Success from "../UI/Success";

const JobDonePopUpRecoverySecondStep = ({
  booking_id,
  request,
  setShowJobDonePopup,
  removeBooking,
  index,
  setisjobDone,
  isJobDone,
}) => {
  const [bookingDetails, setBookingDetails] = useState([]);
  const [utrNumber, setutrNumber] = useState("");
  const [successMessage, setsuccessMessage] = useState("");
  const [errorMessage, seterrorMessage] = useState("");
  const [parkingFee, setParkingFee] = useState();
  const [totalBill, setTotalBill] = useState();
  const [gstRate, setGstRate] = useState();
  const [errors, setErrors] = useState({
    utrNumber_error: "",
  });
  const [loading, setLoading] = useState(false);
  var isValidate = true;

  useEffect(() => {
    const getBookingDetails = async () => {
      setLoading(true);
      const url = process.env.REACT_APP_GET_BOOKING_DETAILS;
      const response = await axiosPrivate.post(url, { booking_id: booking_id });
      if (response?.data?.status == "200") {
        setLoading(false);
        setBookingDetails(response?.data?.response?.data);
        let serviceFee =
          response?.data?.response?.data?.package_info &&
          response?.data?.response?.data?.package_info?.service_fee;
        let chargeRate =
          response?.data?.response?.data?.charging_data &&
          response?.data?.response?.data?.charging_data?.f_charging_cost;
        let gst = response?.data?.response?.data?.booking_info?.gst_rate;
        let fee =
          request.parking_fee -
          response?.data?.response?.data?.package_info?.parking_fee_inclusive;
        setParkingFee(
          request.parking_fee -
            response?.data?.response?.data?.package_info?.parking_fee_inclusive
        );
        let sub_total = response?.data?.response?.data?.booking_info?.subtotal;
        let total_before_gst =
          parseFloat(sub_total) + parseFloat(serviceFee) + parseFloat(fee);
        let gst_cost = (parseFloat(total_before_gst) * parseFloat(gst)) / 100;
        setGstRate(gst_cost);
        let total_after_gst =
          parseFloat(total_before_gst) + parseFloat(gst_cost);
        setTotalBill(total_after_gst);
      } else {
        setLoading(false);
      }
    };
    getBookingDetails();
  }, []);
  const validations = () => {
    const utrRegex = /^[A-Za-z0-9]*$/;
    if (utrNumber != "" && !utrRegex.test(utrNumber)) {
      setErrors((prev) => {
        return {
          ...prev,
          utrNumber_error: "Enter valid utr number",
        };
      });
      isValidate = false;
    } else {
      isValidate = true;
    }
    return isValidate;
  };
  const submit = async () => {
    setLoading(true);
    const finalRequest = {
      action: "order",
      booking_id: request.booking_id,
      customer_user_id: request.customer_user_id,
      parking_fee: request.parking_fee,
      utr: utrNumber && utrNumber,
    };
    if (finalRequest) {
      Object.keys(finalRequest).forEach((key) => {
        if (
          finalRequest[key] === "" ||
          (typeof finalRequest[key] === "object" &&
            Object.keys(finalRequest[key]).length === 0)
        ) {
          delete finalRequest[key];
        }
      });
    }
    const isValid = validations();
    const URL = process.env.REACT_APP_MARK_JOB_DONE;
    if (isValid) {
      const response = await axiosPrivate.post(URL, finalRequest);
      try {
        if (response?.data?.status == "200") {
          setLoading(false);
          setsuccessMessage("Job done successfully");

          setTimeout(() => {
            setShowJobDonePopup(false);
            document.body.classList.remove("hidden");
            seterrorMessage("");
            setsuccessMessage("");
            setisjobDone(!isJobDone);
            removeBooking(index);
          }, 3000);
        } else {
          setLoading(false);
          seterrorMessage(response?.data?.message);
        }
      } catch (error) {}
    }
  };
  return (
    <>
      {loading && <Spinner />}
      {bookingDetails == "" ? (
        <Spinner />
      ) : Object.keys(bookingDetails).length !== 0 ? (
        <>
          <div class="billDetails">
            <h5>Bill details</h5>
            <ul>
              <li>
                <span>
                  Charge rate{" "}
                  {bookingDetails?.charging_data &&
                    "@ " +
                      bookingDetails?.charging_data?.service_charge +
                      " X " +
                      bookingDetails?.charging_data?.f_charging_done}
                </span>
                <span class="">
                  $
                  {bookingDetails?.charging_data &&
                    bookingDetails?.charging_data?.f_charging_cost}
                </span>
              </li>
              {bookingDetails &&
                bookingDetails.booking_add_ons &&
                bookingDetails.booking_add_ons.length > 0 &&
                bookingDetails.booking_add_ons.map((bookingAddons) => {
                  // values.push(...bookingAddons.service_charge);
                  return (
                    <li>
                      <span>{bookingAddons.service_name}</span>
                      <span
                        className={
                          bookingAddons.service_charge != "0.00"
                            ? ""
                            : "success"
                        }
                      >
                        {bookingAddons.service_charge != "0.00"
                          ? "$" + bookingAddons.service_charge
                          : "Free"}
                      </span>
                    </li>
                  );
                })}

              <li>
                <span>Parking fee</span>
                <span class="">${parkingFee && parkingFee}</span>
              </li>
              <li>
                <span>Service charge</span>
                <span
                  class={
                    bookingDetails?.package_info?.service_fee &&
                    bookingDetails?.package_info?.service_fee != "0.00"
                      ? ""
                      : "success"
                  }
                >
                  {bookingDetails?.package_info?.service_fee &&
                  bookingDetails?.package_info?.service_fee != "0.00"
                    ? "$" + bookingDetails?.package_info?.service_fee
                    : "Free"}
                </span>
              </li>
              <li>
                <span>GST</span>
                <span class="">
                  $
                  {gstRate &&
                    gstRate.toString().match(/^-?\d+(?:\.\d{0,2})?/)[0]}
                </span>
              </li>
            </ul>
          </div>

          <div class="UTRTable mt-24">
            <p>
              <span>Total bill amount</span>
              <span class="fs20">
                $
                {totalBill &&
                  totalBill.toString().match(/^-?\d+(?:\.\d{0,2})?/)[0]}
              </span>
            </p>
            <p>
              <span>Enter UTR number</span>
              <input
                type="text"
                placeholder="Enter UTR number"
                name=""
                value={utrNumber}
                onChange={(e) => {
                  setutrNumber(e.target.value);
                  setErrors({ ...errors, utrNumber_error: "" });
                }}
              />
            </p>
          </div>
          {errors.utrNumber_error && <Error error={errors.utrNumber_error} />}

          <div class="actionButtons mt-24">
            <span>
              <a href="javascript:void(0);" class="btn prim" onClick={submit}>
                Mark job as completed
              </a>
            </span>
            {errorMessage && <Error error={errorMessage} />}
            {successMessage && <Success success={successMessage} />}
          </div>
        </>
      ) : (
        <>data not found</>
      )}
    </>
  );
};

export default JobDonePopUpRecoverySecondStep;
