import React, { useState } from "react";
import JobDonePopUpRecoveryFirstStep from "./JobDonePopUpRecoveryFirstStep";
import JobDonePopUpRecoverySecondStep from "./JobDonePopUpRecoverySecondStep";
import Overlay from "../../utils/Overlay";

const JobDonePopUpRecoverySteps = ({
  bookingData,
  date,
  time,
  registration_no,
  setShowJobDonePopup,
  addonList,
  booking_id,
  user_id,
  removeBooking,
  index,
  setisjobDone,
  isJobDone,
}) => {
  const user_firstname = bookingData?.user_profile_data?.firstname
    ? bookingData?.user_profile_data?.firstname
    : "Guest";
  const user_lastname = bookingData?.user_profile_data?.firstname
    ? bookingData?.user_profile_data?.lastname
    : "";
  let userName = "";
  userName = user_firstname ? userName + " " + user_firstname : "";
  userName = user_lastname ? userName + " " + user_lastname : userName;
  const vehicle_registration_no = bookingData?.vehicle_info?.registration_no
    ? bookingData?.vehicle_info?.registration_no
    : "N/A";
  const driver_firstname = bookingData?.driver_details?.firstname
    ? bookingData?.driver_details?.firstname
    : "N/A";
  const driver_lastname = bookingData?.driver_details?.lastname
    ? bookingData?.driver_details?.lastname
    : "";
  let driverName = "";
  driverName = driver_firstname ? driverName + " " + driver_firstname : "";
  driverName = driver_lastname
    ? driverName + " " + driver_lastname
    : driverName;

  const [page, setPage] = useState(0);
  const [request, setRequest] = useState();
  const Titles = ["Enter services", "Confirm payment"];
  const closepopUP = () => {
    setShowJobDonePopup(false);
    document.body.classList.remove("hidden");
  };

  return (
    <Overlay>
      <div
        class="model_box_child cancelBookingP jobDoneRecoveryP"
        id="jobDoneRecoveryP"
        style={{ width: "640px" }}
      >
        <div class="ap_heading">
          <h4>
            Mark job as completed
            <span
              class="material-symbols-rounded black close_model"
              onClick={closepopUP}
            >
              close
            </span>
          </h4>
        </div>
        <div class="contentSection dForm">
          <section>
            <div class="boxT1 fill">
              <h4>
                <span>{date[0]}</span>
                <i class="elip"></i>
                <span>{time}</span>
              </h4>
              <p>
                <i class="material-symbols-rounded mt-m grey">person</i>
                <span>{userName}</span>
                <i class="elip"></i>
                <em>{vehicle_registration_no}</em>
              </p>
              <p class="assignName">
                <i class="material-symbols-rounded mt-m">airport_shuttle</i>
                <span>{driverName}</span>
                <i class="elip"></i>
                <em>{registration_no}</em>
              </p>
            </div>
          </section>
          <div class="formSteps pt-24">
            <ul>
              {page === 0 ? (
                <li>
                  <i>{page + 1}</i>
                  <a href="">{Titles[page]}</a>
                </li>
              ) : (
                <li className="previous">
                  <i></i>
                  <a href="">{Titles[page - 1]}</a>
                </li>
              )}
              {page === 0 ? (
                <li className="next">
                  <i>{page + 2}</i>
                  <a href="">{Titles[page + 1]}</a>
                </li>
              ) : (
                <li>
                  <i>{page + 1}</i>
                  <a href="">{Titles[page]}</a>
                </li>
              )}
              {/* <!-- <li className="next"><i>3</i><a href="javascript:void(0);">Next step</a></li> --> */}
            </ul>
          </div>
          {console.log(page, "page")}
          {page === 0 ? (
            <JobDonePopUpRecoveryFirstStep
              page={page}
              setPage={setPage}
              setShowJobDonePopup={setShowJobDonePopup}
              addonList={addonList}
              bookingData={bookingData}
              booking_id={booking_id}
              user_id={user_id}
              removeBooking={removeBooking}
              index={index}
              setisjobDone={setisjobDone}
              isJobDone={isJobDone}
              setRequest={setRequest}
              request={request}
            />
          ) : (
            <JobDonePopUpRecoverySecondStep
              page={page}
              setPage={setPage}
              booking_id={booking_id}
              request={request}
              setRequest={setRequest}
              setShowJobDonePopup={setShowJobDonePopup}
              removeBooking={removeBooking}
              index={index}
              setisjobDone={setisjobDone}
              isJobDone={isJobDone}
            />
          )}
        </div>
      </div>
    </Overlay>
  );
};

export default JobDonePopUpRecoverySteps;
