import React from "react";
import { useState } from "react";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import { useEffect } from "react";
import Map from "../Map/Map";
import MapAutoComplete from "../../components/Map/MapAutoComplete";
import { FormatDate } from "../../utils/FormatDate";
import { Time } from "../../utils/Time";
import MainContainer from "../UI/MainContainer";
import SubMainContainer from "../UI/SubMainContainer";
import SideBar from "../Layouts/SideBar/SideBar";
import { Link } from "react-router-dom";
import Header from "../Layouts/Header/Header";
import Message from "../../utils/Message";
import Error from "../UI/Error";
import { useRef } from "react";
import Spinner from "../UI/Spinner";
import axios from "axios";
import moment from "moment";
import OutsideClickSection from "../UI/OutsideClickSection";

const MakeNewBooking = () => {
  const vehicleRef = useRef();
  const dateRef = useRef();
  const timeRef = useRef();
  const attendantRef = useRef();
  const puppyRef = useRef();
  const [services, setServices] = useState([]);
  const [isChecked, setisChecked] = useState(false);
  const [isSuccess, setIsSuccess] = useState(false);
  const [message, setMessage] = useState({});
  const [dateVal, setDateVal] = useState("");
  const [timeVal, setTimeVal] = useState("");
  const [dateIndex, setDateIndex] = useState("");
  const [packageStatus, setPackageStatus] = useState(1);
  const [bookingSlotTime, setBookingSlotTime] = useState([]);
  const [dropDownValue, setDropDownValue] = useState({
    vehicle: false,
    bookingDate: false,
    bookingTime: false,
    attendantList: false,
    puppyList: false,
  });

  const [vehicleData, setVehicleData] = useState([]);
  const [openPopup, setOpenPopup] = useState({
    vehicle: false,
    address: false,
    bookingDate: false,
    bookingTime: false,
  });
  const [userProfile, setUserProfile] = useState({});
  const [addressType, setAddressType] = useState("saveAddress");
  const [bookingType, setBookingType] = useState("normal");
  const [vehicleName, setVehicleName] = useState("");
  const [userAddress, setUserAddress] = useState([]);
  const [isSubmit, setisSubmit] = useState(false);
  const [isLoading, setIsLoading] = useState(false);
  const [attendantListing, setAttendantListing] = useState([]);
  const [puppyListing, setPuppyListing] = useState([]);
  const [attendantInfo, setAttendantInfo] = useState({
    id: "",
    name: "",
  });
  const [isRescuePlan, setIsRescuePlan] = useState(false);
  const [puppyInfo, setPuppyInfo] = useState({
    id: "",
    name: "",
  });
  const [id, setId] = useState({
    user_id: "",
    vehicle_id: "",
    payment_by_user_id: "",
    package_id: "",
    profile_id: "",
    slot_id: "",
    serviceId: [],
    booking_package_id: "",
  });
  const [vehicleTotalRecords, setVehicleTotalRecords] = useState("");
  const [vehicleInfo, setVehicleInfo] = useState([]);
  const [isVehicleApiResult, setIsVehicleApiResult] = useState(false);
  const [isCustomerApiResult, setIsCustomerApiResult] = useState(false);
  const [isCardApiResult, setIsCardApiResult] = useState(false);
  const [isValid, setIsValid] = useState({
    phoneNumber: false,
    paymentCard: false,
    newBooking: false,
  });
  const [showMessage, setShowMessage] = useState(false);
  const [lat, setLat] = useState("");
  const [lng, setLng] = useState("");
  const [address, setAddress] = useState("");
  const [request, setRequest] = useState({
    phone_number: "",
  });
  const axiosPrivate = useAxiosIntercept();
  const controller = new AbortController();
  const [phoneNo, setPhoneNo] = useState("");
  const [cardDetails, setCardDetails] = useState([]);
  const [cardToken, setCardToken] = useState("");
  const [selectedVehicle, setSelectedVehicle] = useState([]);
  const [addressVal, setAddressVal] = useState("");
  const [corporate, setcorporate] = useState("");
  const [parkingLocationVal, setParkingLocationVal] = useState("");
  const [bookingSlots, setBookingSlots] = useState([]);
  const [isNormalPackage, setIsNormalPackage] = useState(true);
  const [error, setError] = useState({
    phoneError: "",
  });

  useEffect(() => {
    if (address !== "") {
      setUserProfile((prev) => {
        return {
          ...prev,
          latitude: lat,
          longitude: lng,
          address: address,
        };
      });
    }
  }, [address]);
  useEffect(() => {
    async function fetchData() {
      if (vehicleInfo && bookingType) {
        setServices([]);
        var vehicledetails = [];
        var selectedVehicleDetails = [];
        var vehiclePackageInfo = [];
        if (vehicleInfo) {
          selectedVehicleDetails = vehicleInfo.filter((selectedVehicle) => {
            return selectedVehicle.vehicle_id == id.vehicle_id;
          });
          setSelectedVehicle(selectedVehicleDetails);
          vehiclePackageInfo =
            selectedVehicleDetails.length > 0 &&
            selectedVehicleDetails[0].package_info &&
            selectedVehicleDetails[0].package_info.filter(
              (vehilepackageinfo) => {
                if (vehilepackageinfo.package_group == "rescue") {
                  setIsRescuePlan(true);
                }
                return vehilepackageinfo.package_group == bookingType;
              }
            );
        }
        if (
          vehiclePackageInfo == undefined ||
          (vehiclePackageInfo != undefined && vehiclePackageInfo.length == 0) ||
          (vehiclePackageInfo.length > 0 &&
            vehiclePackageInfo[0].user_package_id == "") ||
          (vehiclePackageInfo.length > 0 &&
            vehiclePackageInfo[0].user_package_id == undefined)
        ) {
          setIsLoading(true);
          setIsNormalPackage(true);
          const request = {
            vehicle_id: selectedVehicleDetails[0].vehicle_id,
            customer_user_id: id.user_id,
            eep: 1,
          };
          const url = process.env.REACT_APP_GET_ACCOUNT_TYPES_URL;
          const response = await axiosPrivate.post(url, request);
          const packageTypeId =
            response?.data?.response?.data?.package_account_type[0]
              .package_types[0].package_type_id;

          const packageRequest = {
            vehicle_id: selectedVehicleDetails[0].vehicle_id,
            package_type_id: packageTypeId,
            services: 1,
            package_status: 1,
            partner_id: selectedVehicleDetails[0].vehicle_partner_id,
          };
          const packageUrl = process.env.REACT_APP_GET_PACKAGES_URL;
          const packageResponse = await axiosPrivate.post(
            packageUrl,
            packageRequest
          );
          if (
            packageResponse?.status == 200 &&
            packageResponse?.data?.response?.data?.packages?.length > 0
          ) {
            setIsLoading(false);
            var bookingPackageId =
              packageResponse?.data?.response?.data?.packages[0].package_id;

            var servicesArray =
              packageResponse?.data?.response?.data?.packages[0].services;
            setPackageStatus(
              packageResponse?.data?.response?.data?.packages[0].package_status
            );
            setServices(
              packageResponse?.data?.response?.data?.packages[0].services
            );
          } else {
            setPackageStatus(0);
            setServices([]);
            corporate == 1 && setBookingType("rescue");
            setIsNormalPackage(false);
            setIsLoading(false);
          }
        } else {
          setServices(vehiclePackageInfo && vehiclePackageInfo[0].services);
        }
        let idArray = [];
        services
          ? services.map((serviceData) => {
              idArray.push(serviceData.service_id);
            })
          : servicesArray &&
            servicesArray.map((serviceData) => {
              idArray.push(serviceData.service_id);
            });
        if (
          (bookingPackageId != "" && bookingPackageId != undefined) ||
          (vehiclePackageInfo.length > 0 &&
            vehiclePackageInfo[0].user_package_id != "" &&
            vehiclePackageInfo[0].user_package_id != undefined)
        ) {
          let bookingSlotTimeUrl =
            vehiclePackageInfo != undefined &&
            vehiclePackageInfo.length > 0 &&
            vehiclePackageInfo[0].user_package_id != "" &&
            vehiclePackageInfo[0].user_package_id != undefined
              ? process.env.REACT_APP_GET_BOOKING_TIME_SLOTS +
                "&customer_user_id=" +
                id.user_id +
                "&user_package_id=" +
                vehiclePackageInfo[0].user_package_id +
                "&vehicle_id=" +
                selectedVehicleDetails[0].vehicle_id
              : process.env.REACT_APP_GET_BOOKING_TIME_SLOTS +
                "&customer_user_id=" +
                id.user_id +
                "&booking_package_id=" +
                bookingPackageId +
                "&vehicle_id=" +
                selectedVehicleDetails[0].vehicle_id;

          // try {
          const bookingSlotTimeresponse = await axiosPrivate.get(
            bookingSlotTimeUrl,
            {
              signal: controller.signal,
            }
          );

          setBookingSlots(bookingSlotTimeresponse?.data?.response?.data);
          setVehicleTotalRecords(
            bookingSlotTimeresponse?.data?.response?.data?.total
          );

          setId((prev) => ({
            ...prev,
            booking_package_id: bookingPackageId,
            vehicle_id: selectedVehicleDetails[0].vehicle_id,
            payment_by_user_id: selectedVehicleDetails[0].payment_by_user_id,
            package_id:
              vehiclePackageInfo &&
              vehiclePackageInfo.length > 0 &&
              vehiclePackageInfo[0].user_package_id,
            serviceId: idArray,
          }));

          const addressUrl = process.env.REACT_APP_GET_PERSONAL_DETAILS;
          const addressresponse = await axiosPrivate.get(
            addressUrl + `&user_id=${id.user_id}`
          );
          if (
            addressresponse?.data?.status == 200 &&
            addressresponse?.data?.response?.data?.user_profiles_info.length > 0
          ) {
            setUserAddress(
              addressresponse?.data?.response?.data?.user_profiles_info
            );
          }
        }
      }
    }
    fetchData();
  }, [bookingType, id.vehicle_id, id.user_id]);
  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    const getVehicle = async () => {
      setIsLoading(true);
      let URL = process.env.REACT_APP_GET_USER_VEHICLE_LIST;

      try {
        const response = await axiosPrivate.get(
          URL + `&limit=9999&user_id=${id.user_id}`,

          {
            signal: controller.signal,
          }
        );
        let vehicleArray = [];
        if (response?.data?.status == 200) {
          setIsLoading(false);
          isMounted && setIsVehicleApiResult(true);
          setVehicleInfo(response?.data?.response?.data?.user_vehicles);
          response?.data?.response?.data?.user_vehicles.length > 0 &&
            response?.data?.response?.data?.user_vehicles.map((data) => {
              if (data?.package_info) {
                data?.package_info.map((packageData, index) => {
                  packageData.booking_left < 1 &&
                    data.package_info.splice(index, 1);
                });
              }
              vehicleArray.push(data);
            });
          setVehicleData(vehicleArray);
          setVehicleTotalRecords(response?.data?.response?.data?.total);
        } else {
          setIsLoading(false);
        }
      } catch (err) {}
    };
    getVehicle();
    return () => {
      isMounted = false;
      controller.abort();
    };
  }, [id.user_id]);
  useEffect(() => {
    if (bookingType != "normal") {
      const moment = require("moment");

      const generateTimeArray = () => {
        const timeArray = [];
        let currentTime = moment(); // Get current time
        currentTime.startOf("minute"); // Reset seconds and milliseconds to zero for precision

        if (currentTime.minute() < 30) {
          currentTime.minute(30);
        } else {
          currentTime.add(1, "hours").startOf("hour").minute(0);
        }

        const endTime = moment().add(1, "day").startOf("day");

        while (currentTime.isBefore(endTime)) {
          const formattedTime = currentTime.format("hh:mm A");

          timeArray.push(formattedTime);

          currentTime.add(30, "minutes");
        }

        return timeArray;
      };

      const timeArray = generateTimeArray();
      setBookingSlotTime(timeArray);
    }
  }, [bookingType, addressType, phoneNo, id.vehicle_id]);
  const handleDropdown = (e) => {
    if (e.currentTarget.id !== undefined) {
      setDropDownValue({
        [e.currentTarget.id]: !dropDownValue[e.currentTarget.id],
      });
    } else {
      setDropDownValue({
        vehicle: false,
        bookingDate: false,
        bookingTime: false,
        attendantList: false,
        puppyList: false,
      });
    }
  };

  const handleAttendantDetails = (details) => {
    let fullname = details.firstname && details.firstname;
    fullname =
      fullname + " " + details.lastname &&
      details.firstname + " " + details.lastname;
    setAttendantInfo({
      id: details.user_id,
      name: fullname,
    });
    setDropDownValue({ ...dropDownValue, attendantList: false });
  };
  const handlePuppyDetails = (details) => {
    setPuppyInfo({
      id: details.vehicle_id,
      name: details.registration_no,
    });
    setDropDownValue({ ...dropDownValue, puppyList: false });
  };

  const onBackdropClick = () => {
    setShowMessage(false);
  };

  const sendMeUpdate = (placeObj) => {
    setLat(placeObj.geometry.location.lat());
    setLng(placeObj.geometry.location.lng());
    setAddress(placeObj.formatted_address);
  };

  const validNumber = (e) => {
    setError("");
    setPhoneNo(e.target.value);
    setIsValid((prev) => ({
      ...prev,
      phoneNumber: false,
    }));
    setRequest((prev) => ({
      ...prev,
      phone_number: "",
    }));
    setId({
      user_id: "",
      vehicle_id: "",
      payment_by_user_id: "",
    });
    setVehicleTotalRecords("");
  };
  const checkNumber = async (e) => {
    if (e.code === "Enter") {
      setIsLoading(true);
      /* Reset all states on number search enter starts */
      setId({
        user_id: "",
        vehicle_id: "",
        payment_by_user_id: "",
        package_id: "",
        profile_id: "",
        slot_id: "",
        serviceId: [],
        booking_package_id: "",
      });
      setVehicleName("");
      setVehicleInfo([]);
      setVehicleData([]);
      setCardDetails([]);
      setCardToken("");
      setAddressVal("");
      setUserAddress([]);
      setAddressType("saveAddress");
      setAddress("");
      setLat("");
      setLng("");
      setParkingLocationVal("");
      setDateVal("");
      setTimeVal("");
      setPackageStatus(1);
      setisChecked(false);
      setcorporate("");
      setIsValid({
        phoneNumber: false,
        paymentCard: false,
        newBooking: false,
      });
      setIsCustomerApiResult(false);
      setIsVehicleApiResult(false);
      setIsCardApiResult(false);
      setBookingSlotTime([]);
      setAttendantInfo({ name: "", id: "" });
      setPuppyInfo({ name: "", id: "" });
      setBookingType("normal");
      setAddressType("saveAddress");
      let isValidate = true;
      const phoneregex = /^[0-9]{8,10}$/;
      if (phoneNo === "" || !phoneregex.test(phoneNo)) {
        setIsLoading(false);
        isValidate = false;
        setError(() => {
          return {
            phoneError: "Enter a valid phone",
          };
        });
      }
      if (isValidate == true) {
        setIsLoading(true);
        setRequest((prev) => ({
          ...prev,
          phone_number: e.target.value,
        }));

        const url = process.env.REACT_APP_USER_INFO_URL;

        const response = await axiosPrivate.get(
          url + `&search_by=phone&search_keyword=${e.target.value}`,
          {
            signal: controller.signal,
          }
        );

        if (response?.data?.status == 200) {
          setIsLoading(false);
          setIsCustomerApiResult(true);
          setId({
            user_id: response?.data?.response?.data?.user_info[0]?.user_id,
          });
          setUserProfile({
            user_id: response?.data?.response?.data?.user_info[0]?.user_id,
            firstname: response?.data?.response?.data?.user_info[0]?.firstname,
            lastname: response?.data?.response?.data?.user_info[0]?.lastname,
            phone: response?.data?.response?.data?.user_info[0]?.phone,
            email: response?.data?.response?.data?.user_info[0]?.email,
          });
          const records = response?.data?.response?.data?.total_records;
          if (records > 0) {
            setIsValid((prev) => ({
              ...prev,
              phoneNumber: true,
            }));
          }
        }
      }
    }
  };

  const handleAddress = (e) => {
    setOpenPopup({ [e.currentTarget.id]: !openPopup[e.currentTarget.id] });
  };
  const handleAddressType = (e) => {
    setAddressType(e.currentTarget.id);
    setAddress("");
    setId((prev) => {
      return {
        ...prev,
        profile_id: "",
      };
    });
    setAddressVal("");
    setUserProfile((prev) => {
      return {
        ...prev,
        latitude: "",
        longitude: "",
        address: "",
      };
    });
    setParkingLocationVal("");
    setDateVal("");
    setTimeVal("");
    setBookingSlotTime([]);
  };

  const handleBookingType = async (e) => {
    setServices([]);
    setBookingType(e.currentTarget.id);
    setAddress("");
    setId((prev) => {
      return {
        ...prev,
        profile_id: "",
      };
    });
    setAddressVal("");
    setUserProfile((prev) => {
      return {
        ...prev,
        latitude: "",
        longitude: "",
        address: "",
      };
    });
    setParkingLocationVal("");
    setDateVal("");
    setTimeVal("");
    setBookingSlotTime([]);
  };

  const addressValue = (e, profileId, address) => {
    setId({ ...id, profile_id: profileId });
    setAddressVal(address);
  };

  const handleVehicleId = async (
    e,
    vehicleid,
    modelName,
    brandName,
    packageName,
    paymentByUserId,
    packageId,
    servicesArray,
    isCorporate,
    vehicle_partner_id,
    registration_no
  ) => {
    setServices([]);
    setisChecked(false);
    setPackageStatus(1);
    setcorporate(isCorporate);
    setCardDetails([]);
    setCardToken("");
    setIsCardApiResult(false);
    setIsLoading(true);
    setBookingType("normal");
    setIsRescuePlan(false);
    setAddressType("saveAddress");
    let idArray = [];
    setId((prev) => {
      return {
        ...prev,
        vehicle_id: vehicleid,
      };
    });

    setVehicleName(registration_no + " - " + modelName + " " + brandName);
    const request = {
      user_id: paymentByUserId,
      only_default_card: 1,
    };
    if (isCorporate !== "1") {
      const url = process.env.REACT_APP_GET_ALL_CARDS;
      const response = await axiosPrivate.post(url, request);

      if (response?.data?.status == 200) {
        setIsLoading(false);
        setIsCardApiResult(true);
        if (response?.data?.response?.data?.cards.length > 0) {
          setIsValid((prev) => ({
            ...prev,
            paymentCard: true,
          }));
        }
      } else {
      }
      setCardDetails(response?.data?.response?.data?.cards);

      setCardToken(response?.data?.response?.data?.cards[0].pup_card_token);
    } else {
      setIsLoading(false);
    }
  };
  const handleParkingLocation = (e) => {
    setParkingLocationVal(e.target.value);
  };

  const handleDateValue = (dates, index = 0) => {
    setBookingSlotTime([]);
    let timeArray = [];
    let booking_slot_array =
      bookingSlots && bookingSlots?.booking_date_slot_time[index];

    booking_slot_array.booking_slots &&
      booking_slot_array.booking_slots.map((time) => {
        const currentTime = moment();

        const targetTime = moment(time.booking_date_time);

        const isGreaterThanCurrentTime = targetTime.isAfter(currentTime);
        if (time.slot_available == "true") {
          if (bookingType != "normal") {
            isGreaterThanCurrentTime && timeArray.push(time);
          } else {
            timeArray.push(time);
          }
        }
      });

    setDateVal(dates);
    setDateIndex(index);
    setTimeVal("");
    setBookingSlotTime(timeArray);
  };
  const handleTimeValue = async (e, time, slotId) => {
    setAttendantInfo({ name: "", id: "" });
    setPuppyInfo({ name: "", id: "" });
    setTimeVal(time);
    setId({ ...id, slot_id: slotId });
    setDropDownValue({ bookingTime: false });
    if (time && bookingType == "rescue") {
      setIsLoading(true);
      const attendantListingUrl =
        process.env.REACT_APP_DRIVERS_INFO_URL +
        `&status=A&slot_data=1&slot_date=${moment().format(
          "YYYY-MM-DD"
        )}&start_time=${moment(time, "h:mm A").format("HH:mm:ss")}&limit= 1000`;
      const puppyListingUrl =
        process.env.REACT_APP_PUPPY_INFO_URL +
        `&status=A&slot_data=1&slot_date=${moment().format(
          "YYYY-MM-DD"
        )}&start_time=${moment(time, "h:mm A").format("HH:mm:ss")}&limit= 1000`;

      const attendantLitingResponse = await axiosPrivate.get(
        attendantListingUrl
      );
      const puppyListingResponse = await axiosPrivate.get(puppyListingUrl);
      if (attendantLitingResponse.status == 200) {
        setIsLoading(false);
        setAttendantListing(
          attendantLitingResponse?.data?.response?.data?.user_info
        );
      }
      if (puppyListingResponse.status == 200) {
        setIsLoading(false);
        setPuppyListing(
          puppyListingResponse?.data?.response?.data?.puppy_vehicles
        );
      }
    }
  };
  const handleService = (e, index) => {
    setisChecked({ ...isChecked, [index]: !isChecked[index] });
  };
  const requestAddons = [];
  const makeNewBooking = async () => {
    setisSubmit(true);

    if (services !== null) {
      for (let i = 0; i < services?.length; i++) {
        if (isChecked[i] == true) {
          requestAddons.push(services[i].service_id);
        }
      }

      setId({ serviceId: requestAddons });
    }
    var saveAddressRequest = {};
    var newAddressrequest = {};
    if (corporate == 1) {
      saveAddressRequest = {
        customer_user_id: id.user_id,
        booking_vehicle_id: id.vehicle_id,
        user_package_id: id.package_id,
        booking_package_id: id.booking_package_id,
        parking_note: parkingLocationVal,
        profile_id: id.profile_id,
        slot_id: bookingType == "normal" && id.slot_id,

        booking_slot:
          bookingType == "rescue"
            ? `${moment().format("YYYY-MM-DD")} ${moment(
                timeVal,
                "h:mm A"
              ).format("HH:mm:ss")}`
            : timeVal,
        booking_service_ids: requestAddons,
        puppy_vehicle_id:
          bookingType == "rescue" && puppyInfo.id != "" && puppyInfo.id,
        puppy_driver_id:
          bookingType == "rescue" && attendantInfo.id != "" && attendantInfo.id,
      };
      newAddressrequest = {
        customer_user_id: id.user_id,
        booking_vehicle_id: id.vehicle_id,
        booking_package_id: id.booking_package_id,
        user_package_id: id.package_id,
        parking_note: parkingLocationVal,
        profile_data: userProfile,
        slot_id: bookingType == "normal" && id.slot_id,
        booking_slot:
          bookingType == "rescue"
            ? `${moment().format("YYYY-MM-DD")} ${moment(
                timeVal,
                "h:mm A"
              ).format("HH:mm:ss")}`
            : timeVal,
        booking_service_ids: requestAddons,
        puppy_vehicle_id:
          bookingType == "rescue" && puppyInfo.id != "" && puppyInfo.id,
        puppy_driver_id:
          bookingType == "rescue" && attendantInfo.id != "" && attendantInfo.id,
      };
    } else {
      saveAddressRequest = {
        customer_user_id: id.user_id,
        booking_vehicle_id: id.vehicle_id,
        user_package_id: id.package_id,
        booking_package_id: id.booking_package_id,
        parking_note: parkingLocationVal,
        profile_id: id.profile_id,
        slot_id: bookingType == "normal" && id.slot_id,
        booking_slot:
          bookingType == "rescue"
            ? `${moment().format("YYYY-MM-DD")} ${moment(
                timeVal,
                "h:mm A"
              ).format("HH:mm:ss")}`
            : timeVal,

        pup_card_token: cardToken,
        booking_service_ids: requestAddons,
        puppy_vehicle_id:
          bookingType == "rescue" && puppyInfo.id != "" && puppyInfo.id,
        puppy_driver_id:
          bookingType == "rescue" && attendantInfo.id != "" && attendantInfo.id,
      };
      newAddressrequest = {
        customer_user_id: id.user_id,
        booking_vehicle_id: id.vehicle_id,
        booking_package_id: id.booking_package_id,
        user_package_id: id.package_id,
        parking_note: parkingLocationVal,
        profile_data: userProfile,
        slot_id: bookingType == "normal" && id.slot_id,
        booking_slot:
          bookingType == "rescue"
            ? `${moment().format("YYYY-MM-DD")} ${moment(
                timeVal,
                "h:mm A"
              ).format("HH:mm:ss")}`
            : timeVal,
        pup_card_token: cardToken,
        booking_service_ids: requestAddons,
        puppy_vehicle_id:
          bookingType == "rescue" && puppyInfo.id != "" && puppyInfo.id,
        puppy_driver_id:
          bookingType == "rescue" && attendantInfo.id != "" && attendantInfo.id,
      };
    }
    const url = process.env.REACT_APP_MAKE_NEW_BOOKINGS;
    const response = await axiosPrivate.post(
      bookingType == "normal" ? url : url + "&is_recovery_booking=1",
      addressType === "saveAddress" ? saveAddressRequest : newAddressrequest
    );

    if (
      response?.data?.status == 200 &&
      response?.data?.response?.data?.booking_id != undefined
    ) {
      setPhoneNo("");

      setisSubmit(false);
      setIsSuccess(true);
      setShowMessage(true);
      setMessage({
        id: 1,
        text: `Booking added successfully`,
      });
    } else {
      setPhoneNo("");

      setIsSuccess(false);
      setShowMessage(true);
      setisSubmit(false);
      setMessage({
        id: 2,
        text: response?.data?.message,
      });
    }
  };

  function getClassForSubmitButton() {
    let class_name = "btn prim";
    if (
      id.user_id == "" ||
      id.vehicle_id == "" ||
      id.slot_id == "" ||
      (corporate == 1 && id.booking_package_id == "") ||
      timeVal == "" ||
      (addressType == "saveAddress" &&
        (id.profile_id === undefined || id.profile_id == "")) ||
      (addressType == "addNewAddress" && address == "") ||
      (bookingType != "normal" &&
        (attendantInfo.id == "" || puppyInfo.id == ""))
    ) {
      class_name = "btn prim disable";
    }
    return class_name;
  }
  return (
    <>
      {isLoading && <Spinner />}
      {showMessage && (
        <Message
          message={message}
          onBackdropClick={onBackdropClick}
          errorLink="/bookings/makeNewBooking"
          successLink="/bookings"
          errorValue="Try again"
          successValue="Go back to bookings"
          isSuccess={isSuccess}
        />
      )}
      <MainContainer>
        <Header />
        <SubMainContainer>
          <SideBar />
          <SubMainContainer SubMainContainerCustomClass="rightCol">
            <div className="contentContainer">
              <h2>
                <Link to="/bookings">
                  <span className="material-symbols-rounded mt-l black">
                    arrow_back
                  </span>
                </Link>
                Make new booking
              </h2>
              <div class="border radius formSection">
                <div class="subContent pad-24">
                  <div class="assignPromoP dForm w300">
                    <div class="fieldGroup mt-0">
                      <label>Customer mobile number</label>
                      <div class="searchPanel">
                        <div class="searchBar fullWidth">
                          <i class="material-symbols-rounded mt-m grey">
                            search
                          </i>
                          <input
                            type="text"
                            maxLength="10"
                            autoComplete="off"
                            placeholder="Search customer by phone number"
                            class="fullWidth"
                            value={phoneNo}
                            onChange={(e) => validNumber(e)}
                            onKeyUp={(e) => checkNumber(e)}
                          />
                        </div>
                      </div>
                    </div>
                    {error.phoneError !== "" && error.phoneError && (
                      <Error error={error.phoneError} />
                    )}
                    {request.phone_number != "" &&
                      isValid.phoneNumber === false &&
                      isCustomerApiResult === true && (
                        <div class="fieldGroup promoText">
                          <p class="xTypeBox grey">
                            <i class="material-symbols-rounded mt-m mr-8">
                              person_off
                            </i>
                            No customer found with this number
                          </p>
                        </div>
                      )}

                    {isValid.phoneNumber && phoneNo && (
                      <>
                        {vehicleData.length > 0 ? (
                          <div class="fieldGroup widthAuto">
                            <label>Select vehicle</label>

                            <div
                              ref={vehicleRef}
                              class="multiOption"
                              id="vehicle"
                              onClick={(e) => handleDropdown(e)}
                            >
                              <div
                                style={{ minWidth: "300px" }}
                                class={
                                  dropDownValue.vehicle
                                    ? "selectBox open "
                                    : "selectBox "
                                }
                              >
                                <p class="selected">
                                  {vehicleName ? vehicleName : "Select vehicle"}
                                  <i class="material-symbols-rounded grey">
                                    expand_more
                                  </i>
                                </p>

                                <div class="selectDrop customScroll hFix">
                                  <ul class="dropMenu">
                                    {vehicleData &&
                                      vehicleData.map((vehicleDetails) => {
                                        return (
                                          <li
                                            class={
                                              vehicleDetails?.vehicle_id ===
                                              id.vehicle_id
                                                ? "selected"
                                                : ""
                                            }
                                          >
                                            <a
                                              id={vehicleDetails?.vehicle_id}
                                              href="javascript:void(0);"
                                              onClick={(e) =>
                                                handleVehicleId(
                                                  e,
                                                  vehicleDetails?.vehicle_id,
                                                  vehicleDetails.brand_name,
                                                  vehicleDetails.model_name,
                                                  vehicleDetails?.package_info &&
                                                    vehicleDetails
                                                      ?.package_info[0]
                                                      ?.package_name,

                                                  vehicleDetails.payment_by_user_id,
                                                  vehicleDetails?.package_info &&
                                                    vehicleDetails
                                                      ?.package_info[0]
                                                      ?.user_package_id,
                                                  vehicleDetails?.package_info &&
                                                    vehicleDetails
                                                      ?.package_info[0]
                                                      ?.services,
                                                  vehicleDetails?.is_corporate,
                                                  vehicleDetails?.vehicle_partner_id,
                                                  vehicleDetails?.registration_no
                                                )
                                              }
                                            >
                                              {`${
                                                vehicleDetails?.registration_no +
                                                " - "
                                              } ${vehicleDetails.brand_name} ${
                                                vehicleDetails.model_name
                                              }`}
                                              {vehicleDetails?.vehicle_id ===
                                                id.vehicle_id && (
                                                <i class="material-symbols-rounded">
                                                  done
                                                </i>
                                              )}
                                            </a>
                                          </li>
                                        );
                                      })}
                                  </ul>
                                </div>
                              </div>
                            </div>
                          </div>
                        ) : isVehicleApiResult === true &&
                          vehicleInfo.length <= 0 ? (
                          <div class="fieldGroup promoText">
                            <p class="xTypeBox grey">
                              <i class="material-symbols-rounded mt-m mr-8">
                                electric_car
                              </i>
                              No vehicle found for this number
                            </p>
                          </div>
                        ) : isVehicleApiResult === true &&
                          vehicleInfo.length > 0 ? (
                          <div class="fieldGroup promoText">
                            <p class="xTypeBox grey">
                              <i class="material-symbols-rounded mt-m mr-8">
                                electric_car
                              </i>
                              No vehicle found with package
                            </p>
                          </div>
                        ) : (
                          " "
                        )}
                        {packageStatus != 1 && isRescuePlan == false ? (
                          <div class="fieldGroup promoText">
                            <p class="error mt-8 xTypeBox">
                              <i class="material-symbols-rounded mt-m error mr-8">
                                list_alt
                              </i>
                              Package is not active
                            </p>
                          </div>
                        ) : (
                          <>
                            {id.vehicle_id !== undefined &&
                            id.vehicle_id != "" &&
                            corporate != "1" &&
                            packageStatus !== 0 &&
                            isCardApiResult === true &&
                            isValid.paymentCard == true
                              ? selectedVehicle &&
                                selectedVehicle.map((vehicleDetail) => {
                                  return (
                                    <div class="dataTable booking mt-16 inlineFlex newBookingTableDetails radius">
                                      <div>
                                        <p>
                                          <span>Customer name</span>
                                          <span>{cardDetails[0].name}</span>
                                        </p>
                                        <p>
                                          <span>Credit card</span>
                                          <span>
                                            <i class="material-symbols-rounded mt-m success mr-8">
                                              credit_score
                                            </i>
                                            <b class="success">Added</b>
                                          </span>
                                        </p>
                                        {vehicleDetail.package_info &&
                                        vehicleDetail.package_info.length >
                                          0 ? (
                                          <>
                                            {vehicleDetail.package_info
                                              .length == 1 ? (
                                              <p>
                                                <span>Plan</span>
                                                <span>
                                                  {vehicleDetail.package_info[0]
                                                    .package_name &&
                                                    vehicleDetail
                                                      .package_info[0]
                                                      .package_name}
                                                </span>
                                              </p>
                                            ) : (
                                              vehicleDetail.package_info &&
                                              vehicleDetail.package_info.map(
                                                (packagedetail) => {
                                                  return (
                                                    <>
                                                      {packagedetail.package_group ==
                                                        "normal" && (
                                                        <p>
                                                          <span>Plan</span>
                                                          <span>
                                                            {packagedetail.package_group ==
                                                              "normal" &&
                                                              packagedetail.package_name}
                                                          </span>
                                                        </p>
                                                      )}
                                                      {packagedetail.package_group ==
                                                        "rescue" && (
                                                        <p>
                                                          <span>
                                                            Emergency recovery
                                                          </span>
                                                          <span>
                                                            {packagedetail.package_group ==
                                                              "rescue" &&
                                                              packagedetail.package_name}
                                                          </span>
                                                        </p>
                                                      )}
                                                    </>
                                                  );
                                                }
                                              )
                                            )}
                                          </>
                                        ) : (
                                          <p>
                                            <span>Plan</span>
                                            <span>Pay-as-you-go</span>
                                          </p>
                                        )}
                                      </div>
                                    </div>
                                  );
                                })
                              : id.vehicle_id !== undefined &&
                                id.vehicle_id != "" &&
                                isCardApiResult === true &&
                                corporate != "1" && (
                                  <div class="fieldGroup promoText">
                                    <p class="error mt-8 xTypeBox">
                                      <i class="material-symbols-rounded mt-m error mr-8">
                                        credit_card_off
                                      </i>
                                      No credit card added by the user
                                    </p>
                                  </div>
                                )}

                            {((id.vehicle_id !== "" ||
                              id.vehicle_id !== undefined) &&
                              isValid.paymentCard == true) ||
                            corporate == 1 ? (
                              <div class="fieldGroup map widthAuto">
                                <label>Booking type</label>
                                <ul class="xType mb-16">
                                  <li
                                    onClick={(e) =>
                                      isNormalPackage == true &&
                                      handleBookingType(e)
                                    }
                                    id="normal"
                                  >
                                    <input
                                      type="radio"
                                      name="bookingType"
                                      checked={
                                        (bookingType == "normal" ||
                                          isNormalPackage == true) &&
                                        true
                                      }
                                      disabled={
                                        corporate == "1" &&
                                        isNormalPackage == false &&
                                        true
                                      }
                                    />
                                    <label for="yTypeRadio4">Normal</label>
                                  </li>
                                  <li
                                    onClick={(e) =>
                                      isRescuePlan == true &&
                                      handleBookingType(e)
                                    }
                                    id="rescue"
                                  >
                                    <input
                                      type="radio"
                                      disabled={isRescuePlan == false}
                                      name="bookingType"
                                      checked={bookingType == "rescue" && true}
                                    />
                                    <label for="yTypeRadio555">
                                      Recovery insurance
                                    </label>
                                  </li>
                                </ul>
                              </div>
                            ) : (
                              <></>
                            )}

                            {((id.vehicle_id !== "" ||
                              id.vehicle_id !== undefined) &&
                              isValid.paymentCard == true) ||
                            corporate == 1 ? (
                              <div class="fieldGroup map widthAuto">
                                <label>Charging address</label>
                                <ul class="xType mb-16">
                                  <li
                                    onClick={(e) => handleAddressType(e)}
                                    id="saveAddress"
                                  >
                                    <input
                                      type="radio"
                                      name="addressType"
                                      checked={
                                        addressType == "saveAddress" && true
                                      }
                                    />
                                    <label for="yTypeRadio4">
                                      Choose from saved address
                                    </label>
                                  </li>
                                  <li
                                    onClick={(e) => handleAddressType(e)}
                                    id="addNewAddress"
                                  >
                                    <input
                                      type="radio"
                                      name="addressType"
                                      checked={
                                        addressType == "addNewAddress" && true
                                      }
                                    />
                                    <label for="yTypeRadio5">
                                      Add new address
                                    </label>
                                  </li>
                                </ul>

                                {addressType === "saveAddress" && (
                                  <div
                                    class="multiOption"
                                    id="address"
                                    onClick={(e) => handleAddress(e)}
                                  >
                                    <div
                                      className={
                                        openPopup.address
                                          ? "selectBox open"
                                          : "selectBox"
                                      }
                                      style={{ minWidth: "280px" }}
                                    >
                                      <p class="selected">
                                        {addressVal
                                          ? addressVal
                                          : "Select address"}
                                        <i class="material-symbols-rounded grey">
                                          expand_more
                                        </i>
                                      </p>
                                      <div class="selectDrop customScroll hFix">
                                        <ul class="dropMenu">
                                          {userAddress &&
                                            userAddress.map(
                                              (addressDetails) => {
                                                return (
                                                  <li
                                                    class={
                                                      id.profile_id ===
                                                      addressDetails.profile_id
                                                        ? "selected"
                                                        : ""
                                                    }
                                                    onClick={(e) =>
                                                      addressValue(
                                                        e,
                                                        addressDetails.profile_id,
                                                        addressDetails?.address
                                                      )
                                                    }
                                                  >
                                                    <a href="javascript:void(0);">
                                                      {addressDetails.address}
                                                      {id.profile_id ===
                                                        addressDetails.profile_id && (
                                                        <i class="material-symbols-rounded">
                                                          done
                                                        </i>
                                                      )}
                                                    </a>
                                                  </li>
                                                );
                                              }
                                            )}
                                        </ul>
                                      </div>
                                    </div>
                                  </div>
                                )}

                                {addressType == "addNewAddress" && (
                                  <MapAutoComplete setMapState={sendMeUpdate} />
                                )}
                              </div>
                            ) : (
                              <></>
                            )}
                            {(addressType == "saveAddress" &&
                              id.profile_id !== undefined &&
                              id.profile_id != "") ||
                            (addressType == "addNewAddress" &&
                              address != "") ? (
                              <div class="addTime dForm">
                                <div class="lists">
                                  <div class="xType alignBottom">
                                    <div class="fieldGroup mt-0">
                                      <label>Parking location</label>
                                      <input
                                        type="text"
                                        placeholder="Enter parking location"
                                        class="fullWidth"
                                        onChange={(e) =>
                                          handleParkingLocation(e)
                                        }
                                      />
                                    </div>
                                    {bookingType == "normal" && (
                                      <div class="fieldGroup fullWidth">
                                        <label>Booking date</label>
                                        <div
                                          ref={dateRef}
                                          class="multiOption"
                                          id="bookingDate"
                                          onClick={(e) => handleDropdown(e)}
                                        >
                                          <div
                                            class={
                                              dropDownValue.bookingDate
                                                ? "selectBox fullWidth open"
                                                : "selectBox fullWidth"
                                            }
                                          >
                                            <p>
                                              {dateVal
                                                ? FormatDate(dateVal)
                                                : "Select date"}

                                              <i class="material-symbols-rounded grey">
                                                expand_more
                                              </i>
                                            </p>

                                            <div class="selectDrop customScroll hFix">
                                              <ul className="dropMenu">
                                                {bookingSlots &&
                                                  bookingSlots?.booking_date_slot_time.map(
                                                    (dates, index) => {
                                                      return (
                                                        <>
                                                          <li
                                                            class={
                                                              dateVal ===
                                                              dates.booking_date
                                                                ? "selected"
                                                                : ""
                                                            }
                                                            onClick={(e) =>
                                                              handleDateValue(
                                                                dates.booking_date,
                                                                index
                                                              )
                                                            }
                                                          >
                                                            <a>
                                                              {FormatDate(
                                                                dates.booking_date
                                                              )}
                                                              {dateVal ===
                                                                dates.booking_date && (
                                                                <i class="material-symbols-rounded">
                                                                  done
                                                                </i>
                                                              )}
                                                            </a>
                                                          </li>
                                                        </>
                                                      );
                                                    }
                                                  )}
                                              </ul>
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                    )}

                                    <div class="fieldGroup fullWidth">
                                      <label>Booking time</label>
                                      <div
                                        ref={timeRef}
                                        class="multiOption"
                                        id="bookingTime"
                                        onClick={(e) => handleDropdown(e)}
                                      >
                                        <div
                                          class={
                                            dropDownValue.bookingTime
                                              ? "selectBox fullWidth open"
                                              : "selectBox fullWidth"
                                          }
                                        >
                                          {bookingType == "normal" ? (
                                            <p className="selected">
                                              {timeVal
                                                ? Time(timeVal)
                                                : "Select Time"}

                                              <i class="material-symbols-rounded grey">
                                                expand_more
                                              </i>
                                            </p>
                                          ) : (
                                            <p className="selected">
                                              {timeVal
                                                ? timeVal
                                                : "Select Time"}

                                              <i class="material-symbols-rounded grey">
                                                expand_more
                                              </i>
                                            </p>
                                          )}
                                          <div class="selectDrop customScroll hFix">
                                            <ul className="dropMenu">
                                              {bookingSlots &&
                                              dateIndex >= 0 &&
                                              bookingSlotTime.length > 0 ? (
                                                bookingSlotTime.map((time) => {
                                                  return (
                                                    <>
                                                      {bookingType ==
                                                      "rescue" ? (
                                                        <li
                                                          class={
                                                            timeVal === time
                                                              ? "selected"
                                                              : ""
                                                          }
                                                          onClick={(e) =>
                                                            handleTimeValue(
                                                              e,
                                                              time
                                                            )
                                                          }
                                                        >
                                                          <a>
                                                            {time}
                                                            {timeVal ===
                                                              time && (
                                                              <i class="material-symbols-rounded">
                                                                done
                                                              </i>
                                                            )}
                                                          </a>
                                                        </li>
                                                      ) : (
                                                        <li
                                                          class={
                                                            timeVal ===
                                                            time.booking_date_time
                                                              ? "selected"
                                                              : ""
                                                          }
                                                          onClick={(e) =>
                                                            handleTimeValue(
                                                              e,
                                                              time.booking_date_time,
                                                              time.slot_id
                                                            )
                                                          }
                                                        >
                                                          <a>
                                                            {Time(
                                                              time.booking_date_time
                                                            )}
                                                            {timeVal ===
                                                              time.booking_date_time && (
                                                              <i class="material-symbols-rounded">
                                                                done
                                                              </i>
                                                            )}
                                                          </a>
                                                        </li>
                                                      )}
                                                    </>
                                                  );
                                                })
                                              ) : (
                                                <div class="promoText mt-0">
                                                  <p class="xTypeBox grey">
                                                    No slots found
                                                  </p>
                                                </div>
                                              )}
                                            </ul>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                  {bookingType == "rescue" && timeVal && (
                                    <div class="xType alignBottom mt-16">
                                      <div class="fieldGroup fullWidth">
                                        <label disabled>Select attendant</label>
                                        <div
                                          ref={attendantRef}
                                          class="multiOption"
                                          id="attendantList"
                                          onClick={(e) => handleDropdown(e)}
                                        >
                                          <div
                                            class={
                                              dropDownValue.attendantList
                                                ? "selectBox fullWidth open"
                                                : "selectBox fullWidth"
                                            }
                                          >
                                            <p class="selected">
                                              {attendantInfo.name
                                                ? attendantInfo.name
                                                : "Select attendant"}
                                              <i class="material-symbols-rounded grey">
                                                expand_more
                                              </i>
                                            </p>
                                            <div class="selectDrop customScroll hFix">
                                              <ul class="dropMenu">
                                                {attendantListing.length > 0 &&
                                                  attendantListing.map(
                                                    (attendantDetails) => {
                                                      return (
                                                        <li
                                                          class={
                                                            attendantInfo.id ==
                                                            attendantDetails.user_id
                                                              ? "selected"
                                                              : ""
                                                          }
                                                          onClick={() =>
                                                            handleAttendantDetails(
                                                              attendantDetails
                                                            )
                                                          }
                                                        >
                                                          <a href="javascript:void(0);">
                                                            {attendantDetails.firstname &&
                                                              attendantDetails.firstname +
                                                                " "}
                                                            {attendantDetails.lastname &&
                                                              attendantDetails.lastname}
                                                            {attendantInfo.id ==
                                                              attendantDetails.user_id && (
                                                              <i class="material-symbols-rounded">
                                                                done
                                                              </i>
                                                            )}
                                                          </a>
                                                        </li>
                                                      );
                                                    }
                                                  )}
                                              </ul>
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                      <div class="fieldGroup fullWidth">
                                        <label>Select puppy</label>
                                        <div
                                          ref={puppyRef}
                                          class="multiOption"
                                          id="puppyList"
                                          onClick={(e) => handleDropdown(e)}
                                        >
                                          <div
                                            class={
                                              dropDownValue.puppyList
                                                ? "selectBox fullWidth open"
                                                : "selectBox fullWidth"
                                            }
                                          >
                                            <p class="selected">
                                              {puppyInfo.name
                                                ? puppyInfo.name
                                                : "Select puppy"}
                                              <i class="material-symbols-rounded grey">
                                                expand_more
                                              </i>
                                            </p>
                                            <div class="selectDrop customScroll hFix">
                                              <ul class="dropMenu">
                                                {puppyListing.length > 0 &&
                                                  puppyListing.map(
                                                    (puppyDetails) => {
                                                      return (
                                                        <li
                                                          class={
                                                            puppyInfo.id ==
                                                            puppyDetails.vehicle_id
                                                              ? "selected"
                                                              : ""
                                                          }
                                                          onClick={() =>
                                                            handlePuppyDetails(
                                                              puppyDetails
                                                            )
                                                          }
                                                        >
                                                          <a href="javascript:void(0);">
                                                            {
                                                              puppyDetails.registration_no
                                                            }
                                                            {puppyInfo.id ==
                                                              puppyDetails.vehicle_id && (
                                                              <i class="material-symbols-rounded">
                                                                done
                                                              </i>
                                                            )}
                                                          </a>
                                                        </li>
                                                      );
                                                    }
                                                  )}
                                              </ul>
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                  )}
                                  {services && services.length != 0 && (
                                    <div class="fieldGroup">
                                      <label>Add-ons</label>
                                      <ul class="yType">
                                        {services.map((serviceData, index) => {
                                          return (
                                            <li>
                                              <input
                                                type="checkbox"
                                                id={
                                                  "service_checkbox_" +
                                                  serviceData.service_id
                                                }
                                                name={serviceData.service_id}
                                                checked={
                                                  isChecked[index]
                                                    ? "checked"
                                                    : ""
                                                }
                                                onClick={(e) => {
                                                  handleService(e, index);
                                                }}
                                              />
                                              <label
                                                for={
                                                  "service_checkbox_" +
                                                  serviceData.service_id
                                                }
                                              >
                                                {serviceData.service_name}
                                              </label>
                                            </li>
                                          );
                                        })}
                                      </ul>
                                    </div>
                                  )}
                                </div>
                              </div>
                            ) : (
                              ""
                            )}
                          </>
                        )}
                      </>
                    )}
                    {isSubmit && <Spinner />}
                    <div class="actionButtons mt-24">
                      <span class="">
                        <a
                          href="javascript:void(0);"
                          className={getClassForSubmitButton()}
                          onClick={makeNewBooking}
                          style={{
                            pointerEvents:
                              id.user_id == "" ||
                              id.vehicle_id == "" ||
                              id.slot_id == "" ||
                              (corporate == 1 && id.booking_package_id == "") ||
                              timeVal == "" ||
                              (addressType == "saveAddress" &&
                                (id.profile_id === undefined ||
                                  id.profile_id == "")) ||
                              (addressType == "addNewAddress" &&
                                address == "") ||
                              (bookingType != "normal" &&
                                (attendantInfo.id == "" || puppyInfo.id == ""))
                                ? "none"
                                : "",
                          }}
                        >
                          Make new booking
                        </a>
                      </span>
                    </div>
                  </div>
                </div>
              </div>
              {(dropDownValue.attendantList ||
                dropDownValue.bookingDate ||
                dropDownValue.bookingTime ||
                dropDownValue.puppyList ||
                dropDownValue.vehicle) && (
                <OutsideClickSection callBackFunction={handleDropdown} />
              )}
            </div>
          </SubMainContainer>
        </SubMainContainer>
      </MainContainer>
    </>
  );
};

export default MakeNewBooking;
