import { useState, useEffect } from "react";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import BrandListing from "./BrandListing";
import { pageTitles } from "../../configuration/GlobalConfig";
import { messages } from "../../configuration/GlobalConfig";
import Spinner from "../UI/Spinner";

const locals = {
  SEARCH_BY: "firstname",
  CURRENT_PAGE: 1,
  USERS_PER_PAGE: 5,
};

const BrandInfo = ({ searchValue, setSearchValue }) => {
  document.title = pageTitles.BRAND;
  const [brands, setBrands] = useState([]);
  const [isLoading, setIsLoading] = useState(false);
  const axiosPrivate = useAxiosIntercept();
  const [error, setError] = useState("");
  const search_keyword = searchValue;

  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    const getbrands = async () => {
      setIsLoading(true);
      let URL = process.env.REACT_APP_GET_VEHICLE_BRAND_LIST;
      if (searchValue === "")
        URL =
          URL + `&page=${locals.CURRENT_PAGE}&limit=${locals.USERS_PER_PAGE}`;
      if (searchValue != "") {
        URL =
          URL +
          `&search_by=${locals.SEARCH_BY}&search_keyword=${search_keyword}&limit=${locals.USERS_PER_PAGE}`;
      }
      try {
        const { data } = await axiosPrivate.get(URL, {
          signal: controller.signal,
        });
        setIsLoading(false);
        if (data?.status === 200) {
          setBrands(data.response.data.brand_details);
        } else {
          setError(messages.API_ERROR);
        }
      } catch (err) {
        setError(messages.NETWORK_ERROR);
      }
    };

    isMounted && getbrands();
    return () => {
      isMounted = false;
      controller.abort();
    };
  }, [searchValue, locals.CURRENT_PAGE]);

  return (
    <>
      {isLoading ? (
        <Spinner />
      ) : error === "" ? (
        <BrandListing brands={brands} setSearchValue={setSearchValue} />
      ) : (
        <>{error}</>
      )}
    </>
  );
};

export default BrandInfo;
