import React from "react";
import { useNavigate } from "react-router-dom";
import { Text } from "../UI/Text";
import Card from "../UI/Card";
const BrandListing = ({ brands, setSearchValue }) => {
  const navigate = useNavigate();
  const style = {
    mainDivClass: "userInfo",
    subDivClass: "name",
  };
  return (
    <>
      {console.log("hereeeeeeee")}
      {brands.length != 0 ? (
        <div className="customersList">
          {brands.map((brandList, i) => {
            const { id, name, image } = brandList;
            return (
              <React.Fragment key={i}>
                <div
                  className="infoEntry"
                  onClick={() => {
                    navigate(`/brand/BrandModelVariantList/${id}`);
                  }}
                >
                  <Card
                    userImage={image}
                    userFirstName={name}
                    className={style}
                  />

                  <div className="moreInfoBtn">
                    show variant
                    <i
                      className="material-symbols-rounded arrowRight mt-l"
                      style={{ cursor: "pointer" }}
                    >
                      expand_more
                    </i>
                  </div>
                </div>
              </React.Fragment>
            );
          })}
        </div>
      ) : (
        <section>
          <div className="head">
            <p>No record found</p>
          </div>
        </section>
      )}
    </>
  );
};
export default BrandListing;
