import React from "react";
import { useState, useEffect, useRef } from "react";
import { useNavigate, useLocation, Link, useParams } from "react-router-dom";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import Pagination from "../Customer/Pagination";
import Card from "../UI/Card";
const BrandInfo = ({ searchValue, setSearchValue, inputElement }) => {
  const [brandVariantDetails, setBrandVariantDetails] = useState([]);
  const navigate = useNavigate();
  const location = useLocation();
  const params = useParams();
  const axiosPrivate = useAxiosIntercept();
  const [error, seterror] = useState("");
  const search_keyword = searchValue;
  const [currentPage, setCurrentPage] = useState(1);
  const [usersPerPage, setUsersPerPage] = useState(5);
  const [total_records, setTotalRecords] = useState(0);
  const search_by = "firstname";
  const style = {
    mainDivClass: "userInfo",
    subDivClass: "name",
  };
  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    const getbrands = async () => {
      let URL = process.env.REACT_APP_GET_VEHICLE_BRAND_MODEL_LIST;
      if (searchValue === "")
        URL = URL + `&page=${currentPage}&limit=${usersPerPage}`;
      if (searchValue != "") {
        URL =
          URL +
          `&search_by=${search_by}&search_keyword=${search_keyword}&limit=${usersPerPage}`;
      }
      try {
        const response = await axiosPrivate.get(
          URL + `&brand_id=${params.id}`,
          {
            signal: controller.signal,
          }
        );
        isMounted &&
          setBrandVariantDetails(response?.data?.response?.data?.models);
        setTotalRecords(response?.data?.response?.data?.total_records);
        inputElement.current.value = "";
      } catch (err) {
        seterror(err);
      }
    };

    getbrands();
    // }

    return () => {
      isMounted = false;
      controller.abort();
      // effectRun.current = true; // update the value of effectRun to true
    };
  }, [searchValue, currentPage]);

  const paginate = (number) => {
    setCurrentPage(number);
  };
  return (
    <>
      {brandVariantDetails ? (
        <>
          <div className="customersList">
            {brandVariantDetails.map((modelList) => {
              return (
                <React.Fragment key={modelList.id}>
                  {modelList.variants.map((variantDetails) => {
                    return (
                      <div key={variantDetails.id} className="infoEntry">
                        <Card
                          userImage={variantDetails.image}
                          userFirstName={variantDetails.name}
                          className={style}
                        />
                        <div className="userInfo">
                          <div className="vehiclesType">
                            <span>Model Name</span>
                            <span>{modelList.name}</span>
                          </div>
                        </div>
                        <div className="userInfo">
                          <div className="vehiclesType">
                            <span>Variant Year</span>
                            <span>{variantDetails.year}</span>
                          </div>
                        </div>
                        <div className="userInfo">
                          <div className="vehiclesType">
                            <span>Variant BatteryCapacity</span>
                            <span>{variantDetails.battery_capacity}</span>
                          </div>
                        </div>
                        <div className="userInfo">
                          <div className="vehiclesType">
                            <span></span>
                            <span></span>
                          </div>
                        </div>
                      </div>
                    );
                  })}
                </React.Fragment>
              );
            })}
          </div>
        </>
      ) : (
        <>no model</>
      )}
      <Pagination
        paginate={paginate}
        currentPage={currentPage}
        usersPerPage={usersPerPage}
        total_records={total_records}
        setUsersPerPage={setUsersPerPage}
        setCurrentPage={setCurrentPage}
      />
    </>
  );
};

export default BrandInfo;
