import React, { useState } from 'react'
import { useEffect } from 'react';
import useAxiosIntercept from '../../../hooks/useAxiosIntercept';
import Button from '../../UI/Button';

const CreateBrand = () => {
    const axiosPrivate=useAxiosIntercept();
    const [name,setName]=useState('');
    const [image,setImage]=useState('');
    const [msg,setMsg]=useState('');
    useEffect(()=>{
        setTimeout(()=>{
setMsg("");
        },5000);
    },[msg]);
    const submit=(e)=>{
       e.preventDefault();
   const createBrand=async ()=>{
    try {
        const formData=new FormData();
        formData.append("brand_logo",image);
        formData.append("brand_name",name);
        const config = {headers : {'content-type':'multipart/form-data'}}
        const response = await axiosPrivate.post(
          process.env.REACT_APP_CREATE_VEHICLE_BRAND,
          formData,
          config
        );
        setImage("");
        setName("");
        document.getElementById('myForm').reset();
        if(response?.data?.message==="success")
        {
            setMsg("data added successfully");
        }
        else if(response?.data?.response?.errors.length!=0)
        {
            setMsg(response?.data?.response?.errors[0]?.message)
        }
       
      } 
      
      catch (err) {
       // return responseHandler(err, "NETWORK_ERROR");
      }
   }
   createBrand();
        
    }
    return (
        <form className="fieldGroup" id="myForm">
            <ul className="">
               {msg!=""?(<p >{msg}</p>):("")}
            <li>
                    <span className="pt-8">
                        <label >Brand Name</label>
                        <input type="text" placeholder="Enter new brand name" value={name} onChange={(e)=>setName(e.target.value)} />
                    </span>
                </li>
                <li>
                    <span className="pt-8">
                        <label >Brand Logo</label>
                        <input type="file" placeholder="Enter new brand name"  onChange={(e)=>setImage(e.target.files[0])} />
                    </span>
                </li>
                <li>
                    <span className="pt-8">
                        <Button value="submit" click={submit} />
                    </span>
                </li>

            </ul>
        </form>
    )
}

export default CreateBrand;