import React from 'react'
import { useNavigate } from 'react-router-dom'
import { useState } from 'react'
import { useEffect } from 'react'
import MapAutoComplete from '../Map/MapAutoComplete'
import useAxiosIntercept from '../../hooks/useAxiosIntercept'
import Error from '../UI/Error'
import Success from '../UI/Success'
import Message from '../../utils/Message'
import { pageTitles } from '../../configuration/GlobalConfig'


export default function AddDeploymentCentre() {
    document.title = pageTitles.CHARGING_CENTRES_CREATION;

    const navigate = useNavigate();
    const [isSubmit, setisSubmit] = useState(false);
    const axiosPrivate = useAxiosIntercept();
    const [lat, setLat] = useState("");
    const [lng, setLng] = useState("");
    const [fullySuccess, setfullySuccess] = useState();
    const [enableSubmit, setEnableSubmit] = useState(true);
    const [message, setMessage] = useState({
        text: ""
    })
    let baySerialNumberCount = 0;
    let bayChargingCapacityCount = 0;
    let batterySerialNumberCout = 0;
    let batteryCapacityCount = 0;
    const baySuccessMessage = "Bay created successfully";
    const batterySuccessMessage = "Battery created successfully"


    const [address, setAddress] = useState("");
    const [chargingStationName, setchargingStationName] = useState("");
    const [swappableBattery, setswappableBattery] = useState([{
        key: Date.now(),
        serial_number: "",
        total_charging_capacity: "",
        charger_type: "S"
    }]);
    const [chargingBay, setchargingBay] = useState([{
        key: Date.now(),
        bay_serial_number: "",
        total_charging_power: ""
    }]);
    const sendMeUpdate = (placeObj) => {
        setLat(placeObj.geometry.location.lat());
        setLng(placeObj.geometry.location.lng());
        setAddress(placeObj.formatted_address);
    };
    const addAnotherBattery = () => {
        setswappableBattery([...swappableBattery,
        {
            key: Date.now(),
            serial_number: "",
            total_charging_capacity: "",
            charger_type: "S"

        }])

    }
    const addAnotherBay = () => {
        setchargingBay([...chargingBay,
        {
            key: Date.now(),
            bay_serial_number: "",
            total_charging_power: ""
        }])

    }
    const validations = () => {

        const battery = [...swappableBattery];
        const bay = [...chargingBay];
        for (let index = 0; index < battery.length; index++) {
            if (battery[index].serial_number == "") {

                battery[index].batteryIdError = "Charger identifier number is required"
            }

            else {

                batterySerialNumberCout++;
                battery[index].batteryIdError = ""

            }

            if (battery[index].total_charging_capacity == "") {
                battery[index].batteryCapacityError = "Battery capacity is required"
            }
            else {
                if (battery[index].total_charging_capacity <= 0) {
                    battery[index].batteryCapacityError = "Value should be greater than 0"

                }
                else {
                    batteryCapacityCount++;
                    battery[index].batteryCapacityError = ""

                }


            }
        }
        for (let index = 0; index < bay.length; index++) {
            if (bay[index].bay_serial_number == "") {
                bay[index].bayIdError = "Bay identifier number is required"
            }
            else {
                baySerialNumberCount++;
                bay[index].bayIdError = ""

            }
            if (bay[index].total_charging_power == "") {
                bay[index].bayCapacityError = "Bay charger capacity is required"
            }
            else {
                if (bay[index].total_charging_power <= 0) {
                    bay[index].bayCapacityError = "Value should be greater than 0"
                }
                else {
                    bayChargingCapacityCount++;
                    bay[index].bayCapacityError = ""

                }


            }

        }
        setswappableBattery(battery);
        setchargingBay(bay);
    }
    const addChargingStation = async () => {
        setisSubmit(true);
        const request = {
            centre_name: chargingStationName,
            latitude: lat,
            longitude: lng,
            address: address,
            chargers: swappableBattery,
            charger_bay: chargingBay
        }
        validations();


        if (chargingStationName !== "" && lat !== "" && lng !== "" && baySerialNumberCount == chargingBay.length && bayChargingCapacityCount == chargingBay.length
            && batteryCapacityCount == swappableBattery.length && batterySerialNumberCout == swappableBattery.length && enableSubmit == true
          
        ) {
  setEnableSubmit(false)
            for (var i = 0; i < chargingBay.length; i++) {

                delete chargingBay[i]["bayIdError"];
                delete chargingBay[i]["bayCapacityError"];
                delete chargingBay[i]["bayError"];
                delete chargingBay[i]["baySuccess"];

            }
            for (var i = 0; i < swappableBattery.length; i++) {


                delete swappableBattery[i]["batteryIdError"];
                delete swappableBattery[i]["batteryCapacityError"];
                delete swappableBattery[i]["batteryError"];
                delete swappableBattery[i]["batterySuccess"];

            }
            const URL = process.env.REACT_APP_CREATE_CHARGING_STATION;
            const response = await axiosPrivate.post(URL, request);
            if (response?.data?.status == "200") {
                  setEnableSubmit(false)

                setMessage({
                    text: "Charging centre created successfully"
                })
                setfullySuccess(true);


            }
            else {
                  setEnableSubmit(true)
                const data = [...chargingBay];
                chargingBay.map((bay, i) => {
                    if (response?.data?.response?.errors?.charger_bay && response?.data?.response?.errors?.charger_bay?.length > "0") {
                        response?.data?.response?.errors?.charger_bay.map((err, index) => {

                            if (bay.key == err?.key) {

                                data[i].bayError = err?.errors[0]?.message

                            }

                        })
                    }

                })
                const sbattery = [...swappableBattery];
                swappableBattery.map((battery, i) => {
                    if (response?.data?.response?.errors?.chargers && response?.data?.response?.errors?.chargers?.length > "0") {
                        response?.data?.response?.errors?.chargers.map((err, index) => {

                            if (battery.key == err?.key) {

                                sbattery[i].batteryError = err?.errors[0]?.message

                            }

                        })
                    }
                })
                setswappableBattery(sbattery);
                setchargingBay(data);
            }


        }
    }
    const removeBattery = (id, index) => {
        const filtered = swappableBattery.filter((obj) => { return obj.key !== id })
        setswappableBattery(filtered);

    }
    const removeBay = (id, index) => {
        const filtered = chargingBay.filter((obj) => { return obj.key !== id })
        setchargingBay(filtered);

    }
    const onBackdropClick = () => {
        setfullySuccess(false);

    }
    return (
        <>

            {fullySuccess && <Message
                message={message}
                successLink="/charging_centers"
                successValue="Go Back To Charging Centre Listing"
                isSuccess={true}
                onBackdropClick={onBackdropClick}
            />}

            <div class="border radius formSection">
                <div class="subContent pad-24">
                    <div class="assignPromoP dForm w300">
                        <div class="fieldGroup mt-0">
                            <label>Charging station name</label>
                            <span><input type="text" placeholder="Enter station name" class="fullWidth" value={chargingStationName} onChange={(e) => { setchargingStationName(e.target.value) }} /></span>
                            {isSubmit && chargingStationName == "" && <Error error={"Charging station name is mandatory"} />}

                        </div>
                        <div class="fieldGroup map widthAuto">
                            <label>Charging station location</label>
                            <MapAutoComplete setMapState={sendMeUpdate} />

                            {isSubmit && address == "" && <Error error={"Address is mandatory"} />}
                        </div>
                        <div class="addTime dForm mt-16">
                            <div class="fieldGroup mt-0 fullWidth mr-16"><label>Add swappable battery</label></div>
                            <div class="lists">
                                {swappableBattery && swappableBattery?.length > "0" && swappableBattery.map((battery, index) => {
                                    return (<>
                                        <div className={index == 0 ? "xType mt-0" : "xType mt-16"}>
                                            <div className="fieldGroup mt-0 fullWidth mr-16">

                                                <span><input type="text" placeholder="Enter charger identifier number" class="fullWidth" value={swappableBattery[index].serial_number} onChange={(e) => {
                                                    const data = [...swappableBattery];
                                                    data[index]["serial_number"] = e.target.value;
                                                    data[index]["batteryIdError"] = "";
                                                    data[index]["batteryError"] = "";
                                                    setswappableBattery(data);
                                                }} /></span>
                                                {swappableBattery[index].batteryIdError && <Error error={swappableBattery[index].batteryIdError} />}


                                            </div>

                                            <div class="fieldGroup mt-0 fullWidth mr-16" className="fieldGroup fullWidth mt-0">

                                                <span><input type="number" placeholder="Enter battery capacity (kWh)" class="fullWidth" value={swappableBattery[index].total_charging_capacity} onChange={(e) => {
                                                    const data = [...swappableBattery];
                                                    data[index]["total_charging_capacity"] = e.target.value;
                                                    data[index]["batteryCapacityError"] = "";
                                                    data[index]["batteryError"] = "";
                                                    setswappableBattery(data);
                                                }} /></span>
                                                {swappableBattery[index].batteryCapacityError && <Error error={swappableBattery[index].batteryCapacityError} />}


                                            </div>
                                            <div class="ml-12" style={{ visibility: index == 0 ? "hidden" : "" }}><i class="material-symbols-rounded grey mt-m arrow cPointer" onClick={() => { removeBattery(battery.key, index) }}>delete</i></div>
                                        </div>

                                        {swappableBattery[index].batteryError && <Error error={swappableBattery[index].batteryError} />}
                                        {swappableBattery[index].batterySuccess && <Success success={swappableBattery[index].batterySuccess} />}

                                    </>)


                                })}
                                <div class="xType alignBottom mt-16">
                                    <i class="material-symbols-rounded mt-m activeFill mr-4">
                                        battery_charging_30
                                    </i>
                                    <a onClick={addAnotherBattery}>Add another battery</a>
                                </div>


                            </div>
                        </div>
                        <div class="addTime dForm mt-16">
                            <div class="fieldGroup mt-0 fullWidth mr-16"><label>Add charging bay</label></div>
                            <div class="lists">

                                {chargingBay && chargingBay?.length > "0" && chargingBay.map((bay, index) => {
                                    return (<>
                                        <div className={index == 0 ? "xType mt-0" : "xType mt-16"} >
                                            <div className="fieldGroup mt-0 fullWidth mr-16">

                                                <span><input type="text" placeholder="Enter charger identifier number" value={chargingBay[index].bay_serial_number} class="fullWidth" onChange={(e) => {
                                                    const data = [...chargingBay];
                                                    data[index]["bay_serial_number"] = e.target.value;
                                                    data[index]["bayIdError"] = "";
                                                    data[index]["bayError"] = "";
                                                    setchargingBay(data);
                                                }} /></span>
                                                {chargingBay[index].bayIdError && <Error error={chargingBay[index].bayIdError} />}
                                            </div>
                                            <div className="fieldGroup fullWidth mt-0">

                                                <span><input type="number" placeholder="Enter charging power" value={chargingBay[index].total_charging_power} class="fullWidth" onChange={(e) => {
                                                    const data = [...chargingBay];
                                                    data[index]["total_charging_power"] = e.target.value;
                                                    data[index]["bayCapacityError"] = "";
                                                    data[index]["bayError"] = "";
                                                    setchargingBay(data);


                                                }} />
                                                </span>
                                                {chargingBay[index].bayCapacityError && <Error error={chargingBay[index].bayCapacityError} />}
                                            </div>
                                            <div class="ml-12" style={{ visibility: index == 0 ? "hidden" : "" }}><i class="material-symbols-rounded grey mt-m arrow cPointer" onClick={() => { removeBay(bay.key, index) }}>delete</i></div>
                                        </div>
                                        {chargingBay[index].bayError && <Error error={chargingBay[index].bayError} />}
                                        {chargingBay[index].baySuccess && <Success success={chargingBay[index].baySuccess} />}
                                    </>)

                                })}

                            </div>


                        </div>
                        <div class="xType alignBottom mt-16">
                            <i class="material-symbols-rounded mt-m activeFill mr-4">ev_charger</i>
                            <a onClick={addAnotherBay}>Add another bay</a>
                        </div>

                        <div class="actionButtons mt-24">

                            <span class="">

                                <a class="btn prim" onClick={addChargingStation}>Add charging station</a>
                            </span>
                        </div>
                        {/* {fullySuccess == false && message.text && <Success success={message.text} />}
                        <br />
                        {fullySuccess == false && <a onClick={() => { navigate(-1) }}>Go back to Listing</a>} */}


                    </div>
                </div>
            </div>

        </>
    )
}
